/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.mem;

import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.mem.AbstractTransientStore;
import org.apache.slide.store.mem.VersionedUriKey;

public class TransientContentStore
extends AbstractTransientStore
implements ContentStore {
    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        VersionedUriKey key = new VersionedUriKey(uri, revisionDescriptor.getRevisionNumber());
        this.debug("retrieveRevisionContent {0}", key);
        byte[] content = (byte[])this.get(key);
        if (content != null) {
            NodeRevisionContent revisionContent = new NodeRevisionContent();
            revisionContent.setContent(content);
            return revisionContent;
        }
        throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        VersionedUriKey key = new VersionedUriKey(uri, revisionDescriptor.getRevisionNumber());
        this.debug("createRevisionContent {0}", key);
        byte[] content = (byte[])this.get(key);
        if (content != null) {
            throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
        }
        this.put(key, revisionContent.getContentBytes());
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        VersionedUriKey key = new VersionedUriKey(uri, revisionDescriptor.getRevisionNumber());
        this.debug("storeRevisionContent {0}", key);
        byte[] content = (byte[])this.get(key);
        if (content == null) {
            throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
        }
        this.put(key, revisionContent.getContentBytes());
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        VersionedUriKey key = new VersionedUriKey(uri, revisionDescriptor.getRevisionNumber());
        this.debug("storeRevisionContent {0}", key);
        this.remove(key);
    }
}

