/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.mem;

import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.mem.AbstractTransientStore;
import org.apache.slide.store.mem.VersionedUriKey;

public class TransientDescriptorStore
extends AbstractTransientStore
implements RevisionDescriptorStore {
    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.debug("retrieveRevisionDescriptor {0} {1}", uri, revisionNumber);
        NodeRevisionDescriptor descriptor = (NodeRevisionDescriptor)this.get(new VersionedUriKey(uri, revisionNumber));
        if (descriptor != null) {
            return descriptor;
        }
        throw new RevisionDescriptorNotFoundException(uri.toString());
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.debug("createRevisionDescriptor {0} {1}", uri, revisionDescriptor.getRevisionNumber());
        this.put(new VersionedUriKey(uri, revisionDescriptor.getRevisionNumber()), revisionDescriptor);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.debug("createRevisionDescriptor {0} {1}", uri, revisionDescriptor.getRevisionNumber());
        VersionedUriKey key = new VersionedUriKey(uri, revisionDescriptor.getRevisionNumber());
        NodeRevisionDescriptor descriptor = (NodeRevisionDescriptor)this.get(key);
        if (descriptor == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        this.put(key, revisionDescriptor);
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        this.debug("removeRevisionDescriptor {0} {1}", uri, revisionNumber);
        this.remove(new VersionedUriKey(uri, revisionNumber));
    }
}

