/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.UnknownObjectClassException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.txfile.XMLResourceDescriptor;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractXMLResourceDescriptor {
    protected final Format outputFormat = Format.getPrettyFormat();
    protected Object txId;
    protected String uri;
    protected SimpleDateFormat dateFormat;
    protected boolean registeredForSaving = false;
    protected ObjectNode object;
    protected Vector permissions;
    protected Vector locks;
    protected NodeRevisionDescriptors revisionDescriptors;
    protected Hashtable descriptor;
    static /* synthetic */ Class class$org$apache$slide$structure$LinkNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    protected static String booleanToString(boolean aBoolean) {
        return aBoolean ? "true" : "false";
    }

    protected static Element createBindings(String aParent, String aChild, Enumeration aEnum) {
        Element aElement = new Element(aParent);
        while (aEnum.hasMoreElements()) {
            ObjectNode.Binding binding = (ObjectNode.Binding)aEnum.nextElement();
            Element childNode = new Element(aChild);
            childNode.setAttribute(new Attribute("name", binding.getName()));
            childNode.setAttribute(new Attribute("uuri", binding.getUuri()));
            aElement.addContent((Content)childNode);
        }
        return aElement;
    }

    protected static Element createElements(String aParent, String aChild, Enumeration aEnum) {
        Element aElement = new Element(aParent);
        while (aEnum.hasMoreElements()) {
            Object aObject = aEnum.nextElement();
            Element aItem = new Element(aChild);
            aItem.setAttribute("val", aObject.toString());
            aElement.addContent((Content)aItem);
        }
        return aElement;
    }

    protected static NodePermission decodePermission(Element aElement, String aUri) {
        String aRevisionNumber = aElement.getAttributeValue("revisionNumber");
        String aSubject = aElement.getAttributeValue("subjectUri");
        String aAction = aElement.getAttributeValue("actionUri");
        boolean aInheritable = new Boolean(aElement.getAttributeValue("inheritable"));
        boolean aNegative = new Boolean(aElement.getAttributeValue("negative"));
        return new NodePermission(aUri, aRevisionNumber, aSubject, aAction, aInheritable, aNegative);
    }

    protected static Element encodeNodePermission(NodePermission aPermission) {
        Element aElementPermission = new Element("permission");
        NodeRevisionNumber aRevisionNumber = aPermission.getRevisionNumber();
        if (aRevisionNumber != null) {
            aElementPermission.setAttribute("revisionNumber", AbstractXMLResourceDescriptor.encodeRevisionNumber(aRevisionNumber));
        }
        aElementPermission.setAttribute("subjectUri", aPermission.getSubjectUri());
        aElementPermission.setAttribute("actionUri", aPermission.getActionUri());
        aElementPermission.setAttribute("inheritable", AbstractXMLResourceDescriptor.booleanToString(aPermission.isInheritable()));
        aElementPermission.setAttribute("negative", AbstractXMLResourceDescriptor.booleanToString(aPermission.isNegative()));
        return aElementPermission;
    }

    protected static Element encodeRevisionDescriptor(NodeRevisionDescriptor aDescriptor) {
        Element aRevisions = new Element("revisions");
        aRevisions.setAttribute("branchName", aDescriptor.getBranchName());
        aRevisions.setAttribute("number", AbstractXMLResourceDescriptor.encodeRevisionNumber(aDescriptor.getRevisionNumber()));
        aRevisions.addContent((Content)AbstractXMLResourceDescriptor.createElements("labels", "label", aDescriptor.enumerateLabels()));
        Element aProperties = new Element("properties");
        Enumeration aEnum = aDescriptor.enumerateProperties();
        while (aEnum.hasMoreElements()) {
            Object aObject = aEnum.nextElement();
            NodeProperty aProp = (NodeProperty)aObject;
            aProperties.addContent((Content)AbstractXMLResourceDescriptor.encodeNodeProperty(aProp));
        }
        aRevisions.addContent((Content)aProperties);
        return aRevisions;
    }

    protected static Element encodeNodeProperty(NodeProperty aProp) {
        Element aElement = new Element("property");
        aElement.setAttribute("name", aProp.getName());
        aElement.setAttribute("namespace", aProp.getNamespace());
        aElement.setAttribute("value", aProp.getValue().toString());
        aElement.setAttribute("type", aProp.getType());
        aElement.setAttribute("protected", AbstractXMLResourceDescriptor.booleanToString(aProp.isProtected()));
        Element aPermissions = new Element("permissions");
        Enumeration aEnum = aProp.enumeratePermissions();
        while (aEnum.hasMoreElements()) {
            NodePermission aPermission = (NodePermission)aEnum.nextElement();
            aPermissions.addContent((Content)AbstractXMLResourceDescriptor.encodeNodePermission(aPermission));
        }
        aElement.addContent((Content)aPermissions);
        return aElement;
    }

    protected static Vector createVector(Element aElement, String aParentName, String aChildName) {
        Element aParent = aElement.getChild(aParentName);
        Vector<String> aRet = new Vector<String>();
        List aList = aParent.getChildren(aChildName);
        for (int i = 0; i < aList.size(); ++i) {
            Element aChild = (Element)aList.get(i);
            aRet.addElement(aChild.getAttributeValue("val"));
        }
        return aRet;
    }

    protected static Vector createBindingVector(Element aElement, String aParentName, String aChildName, boolean parentBindings) {
        Element aParent = aElement.getChild(aParentName);
        Vector<Object> aRet = new Vector<Object>();
        Iterator it = aParent.getChildren().iterator();
        while (it.hasNext()) {
            Element aChild = (Element)it.next();
            String name = aChild.getAttributeValue("name");
            String uuri = aChild.getAttributeValue("uuri");
            if (parentBindings) {
                aRet.add(new ObjectNode.ParentBinding(name, uuri));
                continue;
            }
            aRet.add(new ObjectNode.Binding(name, uuri));
        }
        return aRet;
    }

    protected static String encodeRevisionNumber(NodeRevisionNumber aRevisionNumber) {
        return aRevisionNumber.getMajor() + "." + aRevisionNumber.getMinor();
    }

    protected static Object createObject(String aNomClasse, Class[] aTypes, Object[] aArgs) throws UnknownObjectClassException {
        Class<?> aClasse = null;
        try {
            aClasse = Class.forName(aNomClasse);
            Constructor<?> aConstructor = aClasse.getConstructor(aTypes);
            if (aConstructor == null) {
                aConstructor = aClasse.getSuperclass().getConstructor(aTypes);
            }
            return aConstructor.newInstance(aArgs);
        }
        catch (Exception e) {
            throw new UnknownObjectClassException(aNomClasse);
        }
    }

    protected static NodeRevisionNumber decodeRevisionNumber(Element aElement) {
        Element aElementRevision = aElement.getChild("revision");
        return new NodeRevisionNumber(Integer.parseInt(aElementRevision.getAttributeValue("major")), Integer.parseInt(aElementRevision.getAttributeValue("minor")));
    }

    protected static NodeRevisionNumber decodeRevisionNumber(String aStr) {
        return aStr == null ? null : new NodeRevisionNumber(aStr);
    }

    protected static NodeProperty decodeNodeProperty(Element aElement, String aUri) {
        String aName = aElement.getAttributeValue("name");
        String aValue = aElement.getAttributeValue("value");
        String aNamespace = aElement.getAttributeValue("namespace");
        String aType = aElement.getAttributeValue("type");
        boolean aProtected = new Boolean(aElement.getAttributeValue("protected"));
        Element aPermisionsElement = aElement.getChild("permissions");
        List aList = aPermisionsElement.getChildren();
        Vector<NodePermission> aPermission = new Vector<NodePermission>();
        for (int i = 0; i < aList.size(); ++i) {
            Element aChild = (Element)aList.get(i);
            aPermission.addElement(AbstractXMLResourceDescriptor.decodePermission(aChild, aUri));
        }
        return new NodeProperty(aName, (Object)aValue, aNamespace, aType, aProtected);
    }

    public AbstractXMLResourceDescriptor(Uri uri, Object txId, String characterEncoding) throws ServiceAccessException {
        this.outputFormat.setEncoding(characterEncoding);
        this.dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
        this.txId = txId;
        if (uri == null) {
            throw new ServiceAccessException(null, "Trying to initialize XMLResourceDescriptor with null URI");
        }
        this.uri = uri.toString();
    }

    public ObjectNode retrieveObject() throws ServiceAccessException, ObjectNotFoundException {
        if (this.object == null) {
            throw new ObjectNotFoundException(this.uri);
        }
        return this.object.cloneObject();
    }

    public void storeObject(ObjectNode aObject) throws ServiceAccessException, ObjectNotFoundException {
        this.object = aObject.cloneObject();
    }

    public void removeObject(ObjectNode aObject) throws ServiceAccessException, ObjectNotFoundException {
        this.object = null;
    }

    public void grantPermission(NodePermission permission) throws ObjectNotFoundException, ServiceAccessException {
        if (this.permissions == null) {
            this.permissions = new Vector();
        }
        this.permissions.addElement(permission.cloneObject());
    }

    public void revokePermission(NodePermission permission) throws ObjectNotFoundException, ServiceAccessException {
        if (this.permissions != null) {
            this.permissions.removeElement(permission);
        }
    }

    public void revokePermissions() throws ObjectNotFoundException, ServiceAccessException {
        if (this.permissions != null) {
            this.permissions.removeAllElements();
        }
    }

    public Enumeration enumeratePermissions() throws ServiceAccessException {
        if (this.permissions == null) {
            this.permissions = new Vector();
        }
        return this.permissions.elements();
    }

    public void putLock(NodeLock lock) throws ObjectNotFoundException, ServiceAccessException {
        if (this.locks == null) {
            this.locks = new Vector();
        }
        this.locks.addElement(lock.cloneObject());
    }

    public void renewLock(NodeLock lock) throws LockTokenNotFoundException, ObjectNotFoundException, ServiceAccessException {
        boolean wasPresent;
        if (this.locks == null) {
            this.locks = new Vector();
        }
        if (!(wasPresent = this.locks.removeElement(lock))) {
            throw new LockTokenNotFoundException(lock);
        }
        this.locks.addElement(lock.cloneObject());
    }

    public void removeLock(NodeLock lock) throws LockTokenNotFoundException, ObjectNotFoundException, ServiceAccessException {
        if (this.locks == null) {
            throw new LockTokenNotFoundException(lock);
        }
        boolean wasPresent = this.locks.removeElement(lock);
        if (!wasPresent) {
            throw new LockTokenNotFoundException(lock);
        }
    }

    public Enumeration enumerateLocks() throws ServiceAccessException {
        if (this.locks == null) {
            this.locks = new Vector();
        }
        return this.locks.elements();
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors() throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptors == null) {
            throw new RevisionDescriptorNotFoundException(this.uri.toString());
        }
        return this.revisionDescriptors.cloneObject();
    }

    public void createRevisionDescriptors(NodeRevisionDescriptors aRevisionDescriptors) throws ObjectNotFoundException, ServiceAccessException {
        this.revisionDescriptors = aRevisionDescriptors.cloneObject();
    }

    public void storeRevisionDescriptors(NodeRevisionDescriptors aRevisionDescriptors) throws RevisionDescriptorNotFoundException, ObjectNotFoundException, ServiceAccessException {
        if (!this.revisionDescriptors.getUri().equals(this.uri.toString())) {
            throw new RevisionDescriptorNotFoundException(this.uri.toString());
        }
        this.revisionDescriptors = aRevisionDescriptors.cloneObject();
    }

    public void removeRevisionDescriptors() throws ObjectNotFoundException, ServiceAccessException {
        this.revisionDescriptors = null;
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        Object result = null;
        if (this.descriptor != null && revisionNumber != null) {
            result = this.descriptor.get(revisionNumber.toString());
        }
        if (result == null) {
            throw new RevisionDescriptorNotFoundException(this.uri.toString());
        }
        return ((NodeRevisionDescriptor)result).cloneObject();
    }

    public void createRevisionDescriptor(NodeRevisionDescriptor aRevisionDescriptor) throws ObjectNotFoundException, ServiceAccessException {
        if (this.descriptor == null) {
            this.descriptor = new Hashtable();
        }
        this.descriptor.put(aRevisionDescriptor.getRevisionNumber().toString(), aRevisionDescriptor.cloneObject());
    }

    public void storeRevisionDescriptor(NodeRevisionDescriptor aRevisionDescriptor) throws RevisionDescriptorNotFoundException, ObjectNotFoundException, ServiceAccessException {
        String key = aRevisionDescriptor.getRevisionNumber().toString();
        if (this.descriptor == null || !this.descriptor.containsKey(key)) {
            throw new RevisionDescriptorNotFoundException(this.uri.toString());
        }
        this.descriptor.put(key, aRevisionDescriptor.cloneObject());
    }

    public void removeRevisionDescriptor(NodeRevisionNumber number) throws ObjectNotFoundException, ServiceAccessException {
        if (this.descriptor == null) {
            return;
        }
        this.descriptor.remove(number.toString());
    }

    public void registerForSaving() {
        this.registeredForSaving = true;
    }

    public boolean isRegisteredForSaving() {
        return this.registeredForSaving;
    }

    public abstract void save() throws ServiceAccessException, ObjectNotFoundException;

    public abstract void load() throws ServiceAccessException, ObjectNotFoundException;

    public abstract void create() throws ServiceAccessException, ObjectAlreadyExistsException;

    public abstract void delete() throws ServiceAccessException, ObjectNotFoundException;

    public String getUri() {
        return this.uri;
    }

    public Object getTxId() {
        return this.txId;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof XMLResourceDescriptor && ((XMLResourceDescriptor)o).uri.equals(this.uri) && ((XMLResourceDescriptor)o).txId.equals(this.txId);
    }

    public String toString() {
        return this.txId + ": " + this.uri;
    }

    protected void save(OutputStream os) throws ServiceAccessException, IOException {
        Element aRoot = this.encode();
        Document aDocument = new Document(aRoot);
        XMLOutputter aOutputter = new XMLOutputter(this.outputFormat);
        aOutputter.output(aDocument, os);
        os.flush();
    }

    protected void load(InputStream is) throws ServiceAccessException, JDOMException, IOException {
        SAXBuilder aBuilder = new SAXBuilder();
        Document aDocument = aBuilder.build(is);
        this.decode(aDocument.getRootElement());
    }

    protected void init() throws ServiceAccessException {
        this.object = null;
        this.permissions = new Vector();
        this.locks = new Vector();
        this.revisionDescriptors = new NodeRevisionDescriptors(this.uri, null, new Hashtable(), new Hashtable(), new Hashtable(), false);
        this.descriptor = new Hashtable();
    }

    protected Element encode() throws ServiceAccessException {
        Element aRoot = new Element("data");
        aRoot.addContent((Content)this.encodeObject());
        aRoot.addContent((Content)this.encodePermissions());
        aRoot.addContent((Content)this.encodeLocks());
        aRoot.addContent((Content)this.encodeRevisionDescriptors());
        aRoot.addContent((Content)this.encodeRevisionDescriptor());
        return aRoot;
    }

    protected Element encodeObject() {
        Element aElementObjectNode = new Element("objectnode");
        if (this.object != null) {
            aElementObjectNode.setAttribute("classname", this.object.getClass().getName());
            aElementObjectNode.setAttribute("uri", this.object.getUri());
            if (this.object instanceof LinkNode) {
                aElementObjectNode.setAttribute("linkTo", ((LinkNode)this.object).getLinkedUri());
            }
            aElementObjectNode.addContent((Content)AbstractXMLResourceDescriptor.createBindings("children", "child", this.object.enumerateBindings()));
            aElementObjectNode.addContent((Content)AbstractXMLResourceDescriptor.createBindings("parents", "parent", this.object.enumerateParentBindings()));
            aElementObjectNode.addContent((Content)AbstractXMLResourceDescriptor.createElements("links", "link", this.object.enumerateLinks()));
        } else {
            aElementObjectNode.setAttribute("classname", "null");
            aElementObjectNode.setAttribute("uri", this.uri.toString());
        }
        return aElementObjectNode;
    }

    protected Element encodePermissions() {
        Element aPermissions = new Element("permissions");
        if (this.permissions == null) {
            return aPermissions;
        }
        int aSize = this.permissions.size();
        for (int i = 0; i < aSize; ++i) {
            NodePermission aPermission = (NodePermission)this.permissions.elementAt(i);
            aPermissions.addContent((Content)AbstractXMLResourceDescriptor.encodeNodePermission(aPermission));
        }
        return aPermissions;
    }

    protected Element encodeLocks() {
        Element aElementLocks = new Element("locks");
        if (this.locks == null) {
            return aElementLocks;
        }
        int aSize = this.locks.size();
        for (int i = 0; i < aSize; ++i) {
            NodeLock aLock = (NodeLock)this.locks.elementAt(i);
            Element aElementLock = new Element("lock");
            aElementLock.setAttribute("subjectUri", aLock.getSubjectUri());
            aElementLock.setAttribute("typeUri", aLock.getTypeUri());
            aElementLock.setAttribute("date", this.dateFormat.format(aLock.getExpirationDate()));
            aElementLock.setAttribute("inheritance", AbstractXMLResourceDescriptor.booleanToString(aLock.isInheritable()));
            aElementLock.setAttribute("exclusive", AbstractXMLResourceDescriptor.booleanToString(aLock.isExclusive()));
            aElementLock.setAttribute("lockId", aLock.getLockId());
            aElementLock.setAttribute("owner", aLock.getOwnerInfo() == null ? "" : aLock.getOwnerInfo());
            aElementLocks.addContent((Content)aElementLock);
        }
        return aElementLocks;
    }

    protected Element encodeRevisionDescriptors() {
        NodeRevisionNumber aRevisionNumber;
        Element aRevisionsHistory = new Element("revisionsHistory");
        if (this.revisionDescriptors == null) {
            return aRevisionsHistory;
        }
        aRevisionsHistory.setAttribute("initialRevision", AbstractXMLResourceDescriptor.encodeRevisionNumber(this.revisionDescriptors.getInitialRevision()));
        aRevisionsHistory.setAttribute("useVersioning", AbstractXMLResourceDescriptor.booleanToString(this.revisionDescriptors.isVersioned()));
        Element aBranchesElement = new Element("branches");
        Enumeration aBranches = this.revisionDescriptors.enumerateBranchNames();
        while (aBranches.hasMoreElements()) {
            String aBranchName = (String)aBranches.nextElement();
            Element aElementBranch = new Element("branch");
            aElementBranch.setAttribute("name", aBranchName);
            aRevisionNumber = this.revisionDescriptors.getLatestRevision(aBranchName);
            aElementBranch.setAttribute("lastestRevision", AbstractXMLResourceDescriptor.encodeRevisionNumber(aRevisionNumber));
            aBranchesElement.addContent((Content)aElementBranch);
        }
        aRevisionsHistory.addContent((Content)aBranchesElement);
        Element aRevisionsElement = new Element("revisions");
        Enumeration aRevisions = this.revisionDescriptors.enumerateRevisionNumbers();
        while (aRevisions.hasMoreElements()) {
            aRevisionNumber = (NodeRevisionNumber)aRevisions.nextElement();
            Element aRevisionElement = new Element("branch");
            aRevisionElement.setAttribute("start", AbstractXMLResourceDescriptor.encodeRevisionNumber(aRevisionNumber));
            Enumeration aSuccessors = this.revisionDescriptors.getSuccessors(aRevisionNumber);
            while (aSuccessors.hasMoreElements()) {
                NodeRevisionNumber aSuccessorRevisionNumber = (NodeRevisionNumber)aSuccessors.nextElement();
                Element aSuccessorRevisionElement = new Element("revision");
                aSuccessorRevisionElement.setAttribute("number", AbstractXMLResourceDescriptor.encodeRevisionNumber(aSuccessorRevisionNumber));
                aRevisionElement.addContent((Content)aSuccessorRevisionElement);
            }
            aRevisionsElement.addContent((Content)aRevisionElement);
        }
        aRevisionsHistory.addContent((Content)aRevisionsElement);
        return aRevisionsHistory;
    }

    protected Element encodeRevisionDescriptor() {
        Element aRet = new Element("descriptor");
        if (this.descriptor == null) {
            return aRet;
        }
        Enumeration aEnum = this.descriptor.elements();
        while (aEnum.hasMoreElements()) {
            NodeRevisionDescriptor aRevisionDescriptor = (NodeRevisionDescriptor)aEnum.nextElement();
            aRet.addContent((Content)AbstractXMLResourceDescriptor.encodeRevisionDescriptor(aRevisionDescriptor));
        }
        return aRet;
    }

    protected void decode(Element aRoot) throws ServiceAccessException {
        this.decodeObject(aRoot);
        this.decodePermissions(aRoot);
        this.decodeLocks(aRoot);
        this.decodeRevisionDescriptors(aRoot);
        this.decodeRevisionDescriptor(aRoot);
    }

    protected void decodeObject(Element aElement) throws ServiceAccessException {
        Element aElementObjectNode = aElement.getChild("objectnode");
        String aClasseName = aElementObjectNode.getAttributeValue("classname");
        if (!"null".equals(aClasseName)) {
            try {
                String aUri = aElementObjectNode.getAttributeValue("uri");
                Vector aChilds = AbstractXMLResourceDescriptor.createBindingVector(aElementObjectNode, "children", "child", false);
                Vector aParents = AbstractXMLResourceDescriptor.createBindingVector(aElementObjectNode, "parents", "parent", true);
                Vector aLinks = AbstractXMLResourceDescriptor.createVector(aElementObjectNode, "links", "link");
                Class[] aTypes = null;
                Object[] aArgs = null;
                if (aClasseName.equals((class$org$apache$slide$structure$LinkNode == null ? (class$org$apache$slide$structure$LinkNode = AbstractXMLResourceDescriptor.class$("org.apache.slide.structure.LinkNode")) : class$org$apache$slide$structure$LinkNode).getName())) {
                    String aLinkTo = aElementObjectNode.getAttributeValue("linkTo");
                    aTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractXMLResourceDescriptor.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = AbstractXMLResourceDescriptor.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = AbstractXMLResourceDescriptor.class$("java.util.Vector")) : class$java$util$Vector, class$java$lang$String == null ? (class$java$lang$String = AbstractXMLResourceDescriptor.class$("java.lang.String")) : class$java$lang$String};
                    aArgs = new Object[]{aUri, aChilds, aLinks, aLinkTo};
                } else {
                    aTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AbstractXMLResourceDescriptor.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = AbstractXMLResourceDescriptor.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = AbstractXMLResourceDescriptor.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = AbstractXMLResourceDescriptor.class$("java.util.Vector")) : class$java$util$Vector};
                    aArgs = new Object[]{aUri, aChilds, aParents, aLinks};
                }
                this.object = (ObjectNode)AbstractXMLResourceDescriptor.createObject(aClasseName, aTypes, aArgs);
                this.object.setUri(this.object.getUuri());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceAccessException(null, (Throwable)e);
            }
            this.uri = this.object.getUri();
        } else {
            this.object = null;
            this.uri = aElementObjectNode.getAttributeValue("uri");
        }
    }

    protected void decodePermissions(Element aElement) {
        this.permissions = new Vector();
        Element aPermissions = aElement.getChild("permissions");
        List aList = aPermissions.getChildren();
        for (int i = 0; i < aList.size(); ++i) {
            Element aChild = (Element)aList.get(i);
            this.permissions.addElement(AbstractXMLResourceDescriptor.decodePermission(aChild, this.uri));
        }
    }

    protected void decodeLocks(Element aElement) throws ServiceAccessException {
        try {
            this.locks = new Vector();
            Element aElementLocks = aElement.getChild("locks");
            List aList = aElementLocks.getChildren();
            for (int i = 0; i < aList.size(); ++i) {
                Element aChild = (Element)aList.get(i);
                String aSubject = aChild.getAttributeValue("subjectUri");
                String aType = aChild.getAttributeValue("typeUri");
                Date aDateExpiration = this.dateFormat.parse(aChild.getAttributeValue("date"));
                boolean aInheritable = new Boolean(aChild.getAttributeValue("inheritance"));
                boolean aNegative = new Boolean(aChild.getAttributeValue("exclusive"));
                String aLockId = aChild.getAttributeValue("lockId");
                String ownerInfo = aChild.getAttributeValue("owner");
                this.locks.addElement(new NodeLock(aLockId, this.uri, aSubject, aType, aDateExpiration, aInheritable, aNegative, ownerInfo));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException(null, (Throwable)e);
        }
    }

    protected void decodeRevisionDescriptors(Element aElement) {
        Element aRevisionsHistory = aElement.getChild("revisionsHistory");
        NodeRevisionNumber aInitialRevision = AbstractXMLResourceDescriptor.decodeRevisionNumber(aRevisionsHistory.getAttributeValue("initialRevision"));
        boolean aUseVersionning = new Boolean(aRevisionsHistory.getAttributeValue("useVersioning"));
        Element aBranchesElement = aRevisionsHistory.getChild("branches");
        if (aBranchesElement == null) {
            this.revisionDescriptors = new NodeRevisionDescriptors(this.uri, aInitialRevision, new Hashtable(), new Hashtable(), new Hashtable(), aUseVersionning);
            return;
        }
        List aList = aBranchesElement.getChildren();
        Hashtable<String, NodeRevisionNumber> aLastestRevisions = new Hashtable<String, NodeRevisionNumber>();
        for (int i = 0; i < aList.size(); ++i) {
            Element aChild = (Element)aList.get(i);
            String aName = aChild.getAttributeValue("name");
            NodeRevisionNumber aRevisionNumber = AbstractXMLResourceDescriptor.decodeRevisionNumber(aChild.getAttributeValue("lastestRevision"));
            aLastestRevisions.put(aName, aRevisionNumber);
        }
        Hashtable aBranches = new Hashtable();
        Element aRevisionsElement = aRevisionsHistory.getChild("revisions");
        aList = aRevisionsElement.getChildren();
        for (int i = 0; i < aList.size(); ++i) {
            Element aChild = (Element)aList.get(i);
            NodeRevisionNumber aStartNumber = AbstractXMLResourceDescriptor.decodeRevisionNumber(aChild.getAttributeValue("start"));
            List aSuccessors = aChild.getChildren();
            Vector<NodeRevisionNumber> aSuccessorsNumbers = new Vector<NodeRevisionNumber>();
            for (int k = 0; k < aSuccessors.size(); ++k) {
                Element aSuccessor = (Element)aSuccessors.get(k);
                NodeRevisionNumber aRevisionNumber = AbstractXMLResourceDescriptor.decodeRevisionNumber(aSuccessor.getAttributeValue("number"));
                aSuccessorsNumbers.addElement(aRevisionNumber);
            }
            aBranches.put(aStartNumber, aSuccessorsNumbers);
        }
        this.revisionDescriptors = new NodeRevisionDescriptors(this.uri, aInitialRevision, new Hashtable(), aLastestRevisions, aBranches, aUseVersionning);
    }

    protected void decodeRevisionDescriptor(Element aParent) {
        this.descriptor = new Hashtable();
        Element aElement = aParent.getChild("descriptor");
        if (aElement == null) {
            return;
        }
        List aList = aElement.getChildren();
        for (int i = 0; i < aList.size(); ++i) {
            Element aChild = (Element)aList.get(i);
            String aBranchName = aChild.getAttributeValue("branchName");
            NodeRevisionNumber aRevisionNumber = AbstractXMLResourceDescriptor.decodeRevisionNumber(aChild.getAttributeValue("number"));
            Vector<String> aLabels = new Vector<String>();
            Element aLabelsElement = aChild.getChild("labels");
            List aLabelList = aLabelsElement.getChildren();
            for (int k = 0; k < aLabelList.size(); ++k) {
                Element aLabel = (Element)aLabelList.get(k);
                aLabels.addElement(aLabel.getAttributeValue("val"));
            }
            Hashtable<String, NodeProperty> aProperties = new Hashtable<String, NodeProperty>();
            Element aPropertiesElement = aChild.getChild("properties");
            List aPropertiesList = aPropertiesElement.getChildren();
            for (int k = 0; k < aPropertiesList.size(); ++k) {
                Element aProperty = (Element)aPropertiesList.get(k);
                NodeProperty aProp = AbstractXMLResourceDescriptor.decodeNodeProperty(aProperty, this.uri);
                String key = aProperty.getAttributeValue("namespace") + aProperty.getAttributeValue("name");
                aProperties.put(key, aProp);
            }
            NodeRevisionDescriptor aNode = new NodeRevisionDescriptor(aRevisionNumber, aBranchName, aLabels, aProperties);
            this.descriptor.put(aRevisionNumber.toString(), aNode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

