/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.store.txfile.AbstractXMLResourceDescriptor;
import org.apache.slide.store.txfile.TxXMLFileDescriptorsStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.jdom.JDOMException;

public class XMLResourceDescriptor
extends AbstractXMLResourceDescriptor {
    protected static final String PATH_EXTENSION = ".def.xml";
    protected final FileResourceManager rm;
    protected final TxXMLFileDescriptorsStore store;
    protected final String loadPath;
    protected LoggerFacade logger;
    static /* synthetic */ Class class$org$apache$slide$store$txfile$XMLResourceDescriptor;

    public XMLResourceDescriptor(Uri uri, TxXMLFileDescriptorsStore store, FileResourceManager rm, Object txId, String characterEncoding) throws ServiceAccessException {
        super(uri, txId, characterEncoding);
        this.logger = rm.getLogger().createLogger((class$org$apache$slide$store$txfile$XMLResourceDescriptor == null ? (class$org$apache$slide$store$txfile$XMLResourceDescriptor = XMLResourceDescriptor.class$("org.apache.slide.store.txfile.XMLResourceDescriptor")) : class$org$apache$slide$store$txfile$XMLResourceDescriptor).getName());
        this.rm = rm;
        this.store = store;
        this.loadPath = uri.toString() + PATH_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save() throws ServiceAccessException, ObjectNotFoundException {
        block16: {
            if (this.txId == null) {
                this.store.throwInternalError("Not inside tx");
            }
            this.logger.logFine("Tx " + this.txId + " saves data for " + this.loadPath);
            OutputStream os = null;
            os = this.rm.writeResource(this.txId, (Object)this.loadPath);
            this.save(os);
            this.registeredForSaving = false;
            Object var4_2 = null;
            try {
                if (os != null) {
                    os.close();
                }
                break block16;
            }
            catch (IOException e2) {}
            break block16;
            {
                catch (ResourceManagerException e) {
                    if (e.getStatus() == 4002) {
                        throw new ObjectNotFoundException(this.uri);
                    }
                    this.store.throwInternalError(e, this.uri);
                    Object var4_3 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {}
                    break block16;
                }
                catch (IOException e) {
                    this.store.throwInternalError(e);
                    Object var4_4 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void create() throws ServiceAccessException, ObjectAlreadyExistsException {
        this.logger.logFiner("Tx " + this.txId + " creates " + this.loadPath);
        if (this.txId == null) {
            this.store.throwInternalError("Not inside tx");
        }
        try {
            this.rm.createResource(this.txId, (Object)this.loadPath, false);
            this.init();
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4001) {
                throw new ObjectAlreadyExistsException(this.uri.toString());
            }
            this.store.throwInternalError(e, this.uri);
        }
    }

    public void delete() throws ServiceAccessException, ObjectNotFoundException {
        this.logger.logFiner("Tx " + this.txId + " deletes " + this.loadPath);
        if (this.txId == null) {
            this.store.throwInternalError("Not inside tx");
        }
        try {
            this.rm.deleteResource(this.txId, (Object)this.loadPath, false);
            this.object = null;
            this.registeredForSaving = false;
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4002) {
                throw new ObjectNotFoundException(this.uri.toString());
            }
            this.store.throwInternalError(e, this.uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() throws ServiceAccessException, ObjectNotFoundException {
        block23: {
            InputStream is;
            block22: {
                this.logger.logFiner("Tx " + this.txId + " loads data for " + this.loadPath);
                is = null;
                if (this.txId != null) {
                    if (this.rm.resourceExists(this.txId, (Object)this.loadPath)) {
                        is = this.rm.readResource(this.txId, (Object)this.loadPath);
                        this.load(is);
                    } else {
                        this.init();
                    }
                    break block22;
                }
                this.logger.logFinest("Faking read access from outside tx for " + this.loadPath);
                if (this.rm.resourceExists((Object)this.loadPath)) {
                    is = this.rm.readResource((Object)this.loadPath);
                    this.load(is);
                    break block22;
                }
                this.init();
            }
            Object var4_2 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block23;
            }
            catch (IOException e2) {}
            break block23;
            {
                catch (JDOMException je) {
                    this.store.throwInternalError(je, this.uri);
                    Object var4_3 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block23;
                    }
                    catch (IOException e2) {}
                    break block23;
                }
                catch (IOException ioe) {
                    this.store.throwInternalError(ioe, this.uri);
                    Object var4_4 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block23;
                    }
                    catch (IOException e2) {}
                    break block23;
                }
                catch (ResourceManagerException e) {
                    if (e.getStatus() == 4002) {
                        throw new ObjectNotFoundException(this.uri);
                    }
                    this.store.throwInternalError(e, this.uri);
                    Object var4_5 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block23;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

