/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.Version;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.FopImage;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.layout.Page;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.fonts.LazyFont;

public class PDFDocument {
    private static final Integer locationPlaceholder = new Integer(0);
    protected static final String pdfVersion = "1.3";
    protected int position = 0;
    protected List location = new ArrayList();
    private List trailerObjects = new ArrayList();
    protected int objectcount = 0;
    protected List objects = new ArrayList();
    protected int xref;
    protected PDFRoot root;
    private PDFOutline outlineRoot = null;
    private PDFPages pages;
    protected PDFInfo info;
    protected PDFResources resources;
    protected IDReferences idReferences;
    protected PDFEncryption encryption;
    protected ColorSpace colorspace = new ColorSpace(2);
    protected int patternCount = 0;
    protected int shadingCount = 0;
    protected int xObjectCount = 0;
    protected List xObjects = new ArrayList();
    protected Map xObjectsMap = new HashMap();
    protected List pendingLinks = null;
    public static final String ENCODING = "ISO-8859-1";

    public PDFDocument() {
        this.pages = this.makePages();
        this.root = this.makeRoot(this.pages);
        this.resources = this.makeResources();
        this.info = this.makeInfo();
    }

    public void setProducer(String producer) {
        this.info.setProducer(producer);
    }

    public void setEncryption(String ownerPassword, String userPassword, boolean allowPrint, boolean allowCopyContent, boolean allowEditContent, boolean allowEditAnnotations) {
        this.encryption = new PDFEncryption(++this.objectcount);
        this.encryption.setOwnerPassword(ownerPassword);
        this.encryption.setUserPassword(userPassword);
        this.encryption.setAllowPrint(allowPrint);
        this.encryption.setAllowCopyContent(allowCopyContent);
        this.encryption.setAllowEditContent(allowEditContent);
        this.encryption.setAllowEditAnnotation(allowEditAnnotations);
        this.encryption.init();
        this.addTrailerObject(this.encryption);
    }

    public PDFRoot makeRoot(PDFPages pages) {
        PDFRoot pdfRoot = new PDFRoot(++this.objectcount, pages);
        this.addTrailerObject(pdfRoot);
        return pdfRoot;
    }

    public PDFPages makePages() {
        PDFPages pdfPages = new PDFPages(++this.objectcount);
        this.addTrailerObject(pdfPages);
        return pdfPages;
    }

    public PDFResources makeResources() {
        PDFResources pdfResources = new PDFResources(++this.objectcount);
        this.addTrailerObject(pdfResources);
        return pdfResources;
    }

    protected PDFInfo makeInfo() {
        PDFInfo pdfInfo = new PDFInfo(++this.objectcount);
        pdfInfo.setProducer(Version.getVersion());
        this.objects.add(pdfInfo);
        return pdfInfo;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theSize, int theBitsPerSample, int theOrder, List theEncode, List theDecode, StringBuffer theFunctionDataStream, List theFilter) {
        PDFFunction function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theSize, theBitsPerSample, theOrder, theEncode, theDecode, theFunctionDataStream, theFilter);
        this.objects.add(function);
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theCZero, List theCOne, double theInterpolationExponentN) {
        PDFFunction function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theCZero, theCOne, theInterpolationExponentN);
        this.objects.add(function);
        return function;
    }

    public PDFFunction makeFunction(int theFunctionType, List theDomain, List theRange, List theFunctions, List theBounds, List theEncode) {
        PDFFunction function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theFunctions, theBounds, theEncode);
        this.objects.add(function);
        return function;
    }

    public PDFFunction makeFunction(int theNumber, int theFunctionType, List theDomain, List theRange, StringBuffer theFunctionDataStream) {
        PDFFunction function = new PDFFunction(++this.objectcount, theFunctionType, theDomain, theRange, theFunctionDataStream);
        this.objects.add(function);
        return function;
    }

    public PDFShading makeShading(int theShadingType, ColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theDomain, List theMatrix, PDFFunction theFunction) {
        String theShadingName = new String("Sh" + ++this.shadingCount);
        PDFShading shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theDomain, theMatrix, theFunction);
        this.objects.add(shading);
        this.resources.addShading(shading);
        return shading;
    }

    public PDFShading makeShading(int theShadingType, ColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theCoords, List theDomain, PDFFunction theFunction, List theExtend) {
        String theShadingName = new String("Sh" + ++this.shadingCount);
        PDFShading shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theCoords, theDomain, theFunction, theExtend);
        this.resources.addShading(shading);
        this.objects.add(shading);
        return shading;
    }

    public PDFShading makeShading(int theShadingType, ColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, int theBitsPerFlag, List theDecode, PDFFunction theFunction) {
        String theShadingName = new String("Sh" + ++this.shadingCount);
        PDFShading shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theBitsPerFlag, theDecode, theFunction);
        this.resources.addShading(shading);
        this.objects.add(shading);
        return shading;
    }

    public PDFShading makeShading(int theShadingType, ColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, List theDecode, int theVerticesPerRow, PDFFunction theFunction) {
        String theShadingName = new String("Sh" + ++this.shadingCount);
        PDFShading shading = new PDFShading(++this.objectcount, theShadingName, theShadingType, theColorSpace, theBackground, theBBox, theAntiAlias, theBitsPerCoordinate, theBitsPerComponent, theDecode, theVerticesPerRow, theFunction);
        this.resources.addShading(shading);
        this.objects.add(shading);
        return shading;
    }

    public PDFPattern makePattern(int thePatternType, PDFResources theResources, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        String thePatternName = new String("Pa" + ++this.patternCount);
        PDFPattern pattern = new PDFPattern(++this.objectcount, thePatternName, theResources, 1, thePaintType, theTilingType, theBBox, theXStep, theYStep, theMatrix, theXUID, thePatternDataStream);
        this.resources.addPattern(pattern);
        this.objects.add(pattern);
        return pattern;
    }

    public PDFPattern makePattern(int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        String thePatternName = new String("Pa" + ++this.patternCount);
        PDFPattern pattern = new PDFPattern(++this.objectcount, thePatternName, 2, theShading, theXUID, theExtGState, theMatrix);
        this.resources.addPattern(pattern);
        this.objects.add(pattern);
        return pattern;
    }

    public int getColorSpace() {
        return this.colorspace.getColorSpace();
    }

    public void setColorSpace(int theColorspace) {
        this.colorspace.setColorSpace(theColorspace);
    }

    public PDFPattern createGradient(boolean radial, ColorSpace theColorspace, List theColors, List theBounds, List theCoords) {
        PDFShading myShad;
        double interpolation = 1.0;
        ArrayList<PDFFunction> theFunctions = new ArrayList<PDFFunction>();
        int lastPosition = theColors.size() - 1;
        int currentPosition = 0;
        while (currentPosition < lastPosition) {
            PDFColor currentColor = (PDFColor)theColors.get(currentPosition);
            PDFColor nextColor = (PDFColor)theColors.get(currentPosition + 1);
            if (this.colorspace.getColorSpace() != currentColor.getColorSpace()) {
                currentColor.setColorSpace(this.colorspace.getColorSpace());
            }
            if (this.colorspace.getColorSpace() != nextColor.getColorSpace()) {
                nextColor.setColorSpace(this.colorspace.getColorSpace());
            }
            ArrayList theCzero = currentColor.getVector();
            ArrayList theCone = nextColor.getVector();
            PDFFunction myfunc = this.makeFunction(2, null, null, (List)theCzero, (List)theCone, interpolation);
            theFunctions.add(myfunc);
            ++currentPosition;
        }
        PDFFunction myfunky = this.makeFunction(3, null, null, theFunctions, theBounds, null);
        if (radial) {
            if (theCoords.size() == 6) {
                myShad = this.makeShading(3, this.colorspace, null, null, false, theCoords, null, myfunky, null);
            } else {
                ArrayList newCoords = new ArrayList();
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(theCoords.get(2));
                newCoords.add(theCoords.get(0));
                newCoords.add(theCoords.get(1));
                newCoords.add(new Double(0.0));
                myShad = this.makeShading(3, this.colorspace, null, null, false, newCoords, null, myfunky, null);
            }
        } else {
            myShad = this.makeShading(2, this.colorspace, null, null, false, theCoords, null, myfunky, null);
        }
        PDFPattern myPattern = this.makePattern(2, myShad, null, null, null);
        return myPattern;
    }

    public PDFEncoding makeEncoding(String encodingName) {
        PDFEncoding encoding = new PDFEncoding(++this.objectcount, encodingName);
        this.objects.add(encoding);
        return encoding;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream iccStream = new PDFICCStream(++this.objectcount);
        this.objects.add(iccStream);
        return iccStream;
    }

    public PDFFont makeFont(String fontname, String basefont, String encoding, FontMetric metrics, FontDescriptor descriptor) {
        if (descriptor == null) {
            PDFFont font = new PDFFont(++this.objectcount, fontname, 1, basefont, encoding);
            this.objects.add(font);
            return font;
        }
        byte subtype = 1;
        if (metrics instanceof Font) {
            subtype = ((Font)metrics).getSubType();
        }
        PDFFontDescriptor pdfdesc = this.makeFontDescriptor(descriptor, subtype);
        PDFFontNonBase14 font = null;
        font = subtype == 0 ? (PDFFontNonBase14)PDFFont.createFont(++this.objectcount, fontname, subtype, basefont, "Identity-H") : (PDFFontNonBase14)PDFFont.createFont(++this.objectcount, fontname, subtype, basefont, encoding);
        this.objects.add(font);
        font.setDescriptor(pdfdesc);
        if (subtype == 0) {
            CIDFont cidMetrics = metrics instanceof LazyFont ? (CIDFont)((LazyFont)metrics).getRealFont() : (CIDFont)metrics;
            PDFCIDSystemInfo sysInfo = new PDFCIDSystemInfo(cidMetrics.getRegistry(), cidMetrics.getOrdering(), cidMetrics.getSupplement());
            PDFCIDFont cidFont = new PDFCIDFont(++this.objectcount, basefont, cidMetrics.getCidType(), cidMetrics.getDefaultWidth(), cidMetrics.getWidths(), sysInfo, (PDFCIDFontDescriptor)pdfdesc);
            this.objects.add(cidFont);
            ((PDFFontType0)font).setDescendantFonts(cidFont);
        } else {
            font.setWidthMetrics(metrics.getFirstChar(), metrics.getLastChar(), this.makeArray(metrics.getWidths(1)));
        }
        return font;
    }

    public PDFFontDescriptor makeFontDescriptor(FontDescriptor desc, byte subtype) {
        PDFStream stream;
        PDFFontDescriptor font = null;
        font = subtype == 0 ? new PDFCIDFontDescriptor(++this.objectcount, desc.fontName(), desc.getFontBBox(), desc.getCapHeight(), desc.getFlags(), desc.getItalicAngle(), desc.getStemV(), null) : new PDFFontDescriptor(++this.objectcount, desc.fontName(), desc.getAscender(), desc.getDescender(), desc.getCapHeight(), desc.getFlags(), new PDFRectangle(desc.getFontBBox()), desc.getStemV(), desc.getItalicAngle());
        this.objects.add(font);
        if (desc.isEmbeddable() && (stream = desc.getFontFile(this.objectcount + 1)) != null) {
            ++this.objectcount;
            font.setFontFile(desc.getSubType(), stream);
            this.objects.add(stream);
        }
        return font;
    }

    public PDFArray makeArray(int[] values) {
        PDFArray array = new PDFArray(++this.objectcount, values);
        this.objects.add(array);
        return array;
    }

    public int addImage(FopImage img) {
        String url = img.getURL();
        PDFXObject xObject = (PDFXObject)this.xObjectsMap.get(url);
        if (xObject != null) {
            return xObject.getXNumber();
        }
        xObject = new PDFXObject(++this.objectcount, ++this.xObjectCount, img, this);
        this.objects.add(xObject);
        this.xObjects.add(xObject);
        this.xObjectsMap.put(url, xObject);
        return this.xObjectCount;
    }

    public PDFPage makePage(PDFResources resources, PDFStream contents, int pagewidth, int pageheight, Page currentPage) {
        int i;
        PDFPage page = new PDFPage(++this.objectcount, resources, contents, pagewidth, pageheight);
        if (this.pendingLinks != null) {
            i = 0;
            while (i < this.pendingLinks.size()) {
                PendingLink pl = (PendingLink)this.pendingLinks.get(i);
                PDFGoTo gt = new PDFGoTo(++this.objectcount, page.referencePDF());
                gt.setDestination(pl.dest);
                this.addTrailerObject(gt);
                PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
                pl.link.setAction(internalLink);
                ++i;
            }
            this.pendingLinks = null;
        }
        if (currentPage != null) {
            i = 0;
            while (i < currentPage.getIDList().size()) {
                String id = currentPage.getIDList().get(i).toString();
                this.idReferences.setInternalGoToPageReference(id, page.referencePDF());
                ++i;
            }
        }
        this.objects.add(page);
        this.root.addPage(page);
        return page;
    }

    public PDFLink makeLink(Rectangle rect, String destination, int linkType) {
        PDFLink link = new PDFLink(++this.objectcount, rect);
        this.objects.add(link);
        if (linkType == 1) {
            if (destination.endsWith(".pdf")) {
                PDFFileSpec fileSpec = new PDFFileSpec(++this.objectcount, destination);
                this.objects.add(fileSpec);
                PDFGoToRemote action = new PDFGoToRemote(++this.objectcount, fileSpec);
                this.objects.add(action);
                link.setAction(action);
            } else {
                int index = destination.indexOf(".pdf#page=");
                if (index > 0) {
                    String file = destination.substring(0, index + 4);
                    int page = Integer.parseInt(destination.substring(index + 10));
                    PDFFileSpec fileSpec = new PDFFileSpec(++this.objectcount, file);
                    this.objects.add(fileSpec);
                    PDFGoToRemote action = new PDFGoToRemote(++this.objectcount, fileSpec, page);
                    this.objects.add(action);
                    link.setAction(action);
                } else {
                    index = destination.indexOf(".pdf#dest=");
                    if (index > 0) {
                        String file = destination.substring(0, index + 4);
                        String dest = destination.substring(index + 10);
                        PDFFileSpec fileSpec = new PDFFileSpec(++this.objectcount, file);
                        this.objects.add(fileSpec);
                        PDFGoToRemote action = new PDFGoToRemote(++this.objectcount, fileSpec, dest);
                        this.objects.add(action);
                        link.setAction(action);
                    } else {
                        PDFUri uri = new PDFUri(destination);
                        link.setAction(uri);
                    }
                }
            }
        } else {
            String goToReference = this.getGoToReference(destination);
            PDFInternalLink internalLink = new PDFInternalLink(goToReference);
            link.setAction(internalLink);
        }
        return link;
    }

    private String getGoToReference(String destination) {
        String goToReference;
        if (this.idReferences.doesIDExist(destination)) {
            if (this.idReferences.doesGoToReferenceExist(destination)) {
                goToReference = this.idReferences.getInternalLinkGoToReference(destination);
            } else {
                goToReference = this.idReferences.createInternalLinkGoTo(destination, ++this.objectcount);
                this.addTrailerObject(this.idReferences.getPDFGoTo(destination));
            }
        } else {
            this.idReferences.createUnvalidatedID(destination);
            this.idReferences.addToIdValidationList(destination);
            goToReference = this.idReferences.createInternalLinkGoTo(destination, ++this.objectcount);
            this.addTrailerObject(this.idReferences.getPDFGoTo(destination));
        }
        return goToReference;
    }

    public void addTrailerObject(PDFObject object) {
        this.trailerObjects.add(object);
    }

    public PDFLink makeLinkCurrentPage(Rectangle rect, String dest) {
        PDFLink link = new PDFLink(++this.objectcount, rect);
        this.objects.add(link);
        PendingLink pl = new PendingLink();
        pl.link = link;
        pl.dest = dest;
        if (this.pendingLinks == null) {
            this.pendingLinks = new ArrayList();
        }
        this.pendingLinks.add(pl);
        return link;
    }

    public PDFLink makeLink(Rectangle rect, String page, String dest) {
        PDFLink link = new PDFLink(++this.objectcount, rect);
        this.objects.add(link);
        PDFGoTo gt = new PDFGoTo(++this.objectcount, page);
        gt.setDestination(dest);
        this.addTrailerObject(gt);
        PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
        link.setAction(internalLink);
        return link;
    }

    private void prepareLocations() {
        while (this.location.size() < this.objectcount) {
            this.location.add(locationPlaceholder);
        }
    }

    public PDFStream makeStream() {
        PDFStream obj = new PDFStream(++this.objectcount);
        obj.addDefaultFilters();
        if (this.encryption != null) {
            obj.addFilter(this.encryption.makeFilter(obj.number, obj.generation));
        }
        this.objects.add(obj);
        return obj;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList obj = new PDFAnnotList(++this.objectcount);
        this.objects.add(obj);
        return obj;
    }

    public PDFOutline getOutlineRoot() {
        if (this.outlineRoot != null) {
            return this.outlineRoot;
        }
        this.outlineRoot = new PDFOutline(++this.objectcount, null, null);
        this.addTrailerObject(this.outlineRoot);
        this.root.setRootOutline(this.outlineRoot);
        return this.outlineRoot;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String destination) {
        String goToRef = this.getGoToReference(destination);
        PDFOutline obj = new PDFOutline(++this.objectcount, label, goToRef);
        if (parent != null) {
            parent.addOutline(obj);
        }
        this.objects.add(obj);
        return obj;
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public void output(OutputStream stream) throws IOException {
        this.prepareLocations();
        int i = 0;
        while (i < this.objects.size()) {
            PDFObject object = (PDFObject)this.objects.get(i);
            this.location.set(object.getNumber() - 1, new Integer(this.position));
            this.position += object.output(stream);
            ++i;
        }
        this.objects.clear();
    }

    public void outputHeader(OutputStream stream) throws IOException {
        byte[] pdf;
        this.position = 0;
        try {
            pdf = ("%PDF-" + pdfVersion + "\n").getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ue) {
            pdf = ("%PDF-" + pdfVersion + "\n").getBytes();
        }
        stream.write(pdf);
        this.position += pdf.length;
        byte[] bin = new byte[]{37, -86, -85, -84, -83, 10};
        stream.write(bin);
        this.position += bin.length;
        this.resources.setXObjects(this.xObjects);
    }

    public void outputTrailer(OutputStream stream) throws IOException {
        byte[] trailer;
        this.output(stream);
        int i = 0;
        while (i < this.trailerObjects.size()) {
            PDFObject o = (PDFObject)this.trailerObjects.get(i);
            this.location.set(o.getNumber() - 1, new Integer(this.position));
            this.position += o.output(stream);
            ++i;
        }
        this.position += this.outputXref(stream);
        String encryptEntry = "";
        if (this.encryption != null) {
            encryptEntry = "/Encrypt " + this.encryption.number + " " + this.encryption.generation + " R\n" + "/ID[<" + this.encryption.getFileID(1) + "><" + this.encryption.getFileID(2) + ">]\n";
        }
        String pdf = "trailer\n<<\n/Size " + (this.objectcount + 1) + "\n" + "/Root " + this.root.number + " " + this.root.generation + " R\n" + "/Info " + this.info.number + " " + this.info.generation + " R\n" + encryptEntry + ">>\n" + "startxref\n" + this.xref + "\n" + "%%EOF\n";
        try {
            trailer = pdf.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ue) {
            trailer = pdf.getBytes();
        }
        stream.write(trailer);
    }

    private int outputXref(OutputStream stream) throws IOException {
        byte[] pdfBytes;
        this.xref = this.position;
        StringBuffer pdf = new StringBuffer("xref\n0 " + (this.objectcount + 1) + "\n0000000000 65535 f \n");
        int i = 0;
        while (i < this.location.size()) {
            String x = this.location.get(i).toString();
            String padding = "0000000000";
            String loc = padding.substring(x.length()) + x;
            pdf = pdf.append(loc + " 00000 n \n");
            ++i;
        }
        try {
            pdfBytes = pdf.toString().getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ue) {
            pdfBytes = pdf.toString().getBytes();
        }
        stream.write(pdfBytes);
        return pdfBytes.length;
    }

    public void setIDReferences(IDReferences idReferences) {
        this.idReferences = idReferences;
    }

    public void addDestination(String destinationName, String internalDest) {
        if (!this.idReferences.doesIDExist(internalDest)) {
            this.idReferences.addToUnvalidatedIdList(internalDest);
        }
        PDFDestination obj = new PDFDestination(this.idReferences, destinationName, internalDest);
        this.root.getDestinations().add(obj);
    }

    class PendingLink {
        PDFLink link;
        String dest;

        PendingLink() {
        }
    }
}

