/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Profile;
import com.hp.hpl.deli.Workspace;
import java.util.Date;

class CachedProfile {
    private Profile theProfile;
    private Date dateAccquired;
    private String profileResource;

    CachedProfile() {
    }

    protected boolean set(String _profileResource) throws Exception {
        this.profileResource = _profileResource;
        this.theProfile = new Profile(this.profileResource);
        Workspace.printDebug("CachedProfile: Putting profile " + this.profileResource + " in cache");
        this.dateAccquired = new Date();
        return true;
    }

    protected Profile get() throws Exception {
        Date currentTime = new Date();
        long diffTime = currentTime.getTime() - this.dateAccquired.getTime();
        if (Workspace.getInstance().refreshStaleProfiles && diffTime >= Workspace.getInstance().maxCachedProfileLifetime) {
            Profile keepOldProfile = this.theProfile;
            Workspace.printDebug("CachedProfile: Updating profile");
            if (!this.set(this.profileResource)) {
                Workspace.printDebug("CachedProfile: Profile update failed");
                this.theProfile = keepOldProfile;
                this.dateAccquired = currentTime;
            }
        }
        return this.theProfile;
    }
}

