/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SelectorImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;

class ExtendedStatement
extends StatementImpl {
    public ExtendedStatement(Statement s, Model m) throws Exception {
        super(s.getSubject(), s.getPredicate(), s.getObject(), m);
    }

    protected NodeIterator getContainerIterator() throws Exception {
        NodeIterator i = null;
        if (this.getContainer("Seq").hasNext()) {
            i = this.getModel().getSeq((Resource)this.getObject()).iterator();
        } else if (this.getContainer("Bag").hasNext()) {
            i = this.getModel().getBag((Resource)this.getObject()).iterator();
        }
        return i;
    }

    protected String determineCollectionType() throws Exception {
        String collectionType = "Simple";
        if (!(this.getObject() instanceof Literal)) {
            StmtIterator iterSeq = this.getContainer("Seq");
            collectionType = iterSeq.hasNext() ? "Seq" : collectionType;
            StmtIterator iterBag = this.getContainer("Bag");
            collectionType = iterBag.hasNext() ? "Bag" : collectionType;
        }
        return collectionType;
    }

    protected StmtIterator getContainer(String container) throws Exception {
        StmtIterator iter = this.getModel().listStatements((Selector)new SelectorImpl((Resource)this.getObject(), this.getModel().createProperty(Workspace.getInstance().rdfUri + "type"), (RDFNode)this.getModel().createResource(Workspace.getInstance().rdfUri + container)));
        return iter;
    }
}

