/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.DeliUtil;
import com.hp.hpl.deli.Workspace;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

class ProcessHttpRequest {
    protected Vector referenceVector;
    protected Vector diffVector;

    ProcessHttpRequest(HttpServletRequest request) {
        HashMap<Integer, String> profileDiffMap = new HashMap<Integer, String>();
        HashMap<Integer, String> profileDiffDigestMap = new HashMap<Integer, String>();
        this.referenceVector = new Vector();
        this.diffVector = new Vector();
        String httpexNumericalNamespace = null;
        int maxNumberProfileDiffs = 0;
        Workspace.printDebug("ProcessHttpRequest: Starting to process HTTP request");
        try {
            if (Workspace.getInstance().preferLocalOverRemoteProfiles && this.supportLocalProfiles(request)) {
                Workspace.printDebug("Using local profiles");
                this.supportLocalProfiles(request);
            } else {
                Enumeration profileDiffEnum;
                String profileDiffDigest;
                Enumeration profileEnum;
                Enumeration debugHeaders;
                if (Workspace.getInstance().debugRequestHeaders && (debugHeaders = request.getHeaderNames()) != null) {
                    while (debugHeaders.hasMoreElements()) {
                        StringBuffer header = new StringBuffer();
                        String currentName = (String)debugHeaders.nextElement();
                        header.append(currentName + ": ");
                        Enumeration debugHeaderValues = request.getHeaders(currentName);
                        while (debugHeaderValues.hasMoreElements()) {
                            header.append(debugHeaderValues.nextElement() + " ");
                        }
                        Workspace.printDebug(header.toString());
                    }
                }
                Enumeration enumeration = profileEnum = (profileEnum = request.getHeaders("x-wap-profile")) == null || !profileEnum.hasMoreElements() ? (profileEnum = request.getHeaders("profile")) : profileEnum;
                if (profileEnum == null || !profileEnum.hasMoreElements()) {
                    httpexNumericalNamespace = this.getNumericalNamespace(request.getHeader("opt"));
                    String string = httpexNumericalNamespace = httpexNumericalNamespace == null ? this.getNumericalNamespace(request.getHeader("man")) : httpexNumericalNamespace;
                    if (httpexNumericalNamespace != null) {
                        Workspace.printDebug("Found HTTP-ex namespace: " + httpexNumericalNamespace);
                        profileEnum = request.getHeaders(httpexNumericalNamespace + "-profile");
                    }
                }
                if (profileEnum != null) {
                    while (profileEnum.hasMoreElements()) {
                        String value = (String)profileEnum.nextElement();
                        StringTokenizer str = new StringTokenizer(value, "\",");
                        while (str.hasMoreTokens()) {
                            String token = str.nextToken();
                            if (token.startsWith("http")) {
                                this.referenceVector.add(token);
                                Workspace.printDebug("Found profile reference: " + token);
                                continue;
                            }
                            if (token.indexOf(45) <= 0) continue;
                            int profileDiffNumber = Integer.parseInt(token.substring(0, token.indexOf(45)));
                            if (profileDiffNumber > maxNumberProfileDiffs) {
                                maxNumberProfileDiffs = profileDiffNumber;
                            }
                            profileDiffDigest = token.substring(token.indexOf(45) + 1, token.length());
                            Workspace.printDebug("Found profile-diff-digest: " + profileDiffDigest);
                            profileDiffDigestMap.put(new Integer(profileDiffNumber), profileDiffDigest);
                        }
                    }
                }
                profileDiffEnum = (profileDiffEnum = request.getHeaders("x-wap-profile-diff")) == null || !profileDiffEnum.hasMoreElements() ? request.getHeaders("profile-diff") : profileDiffEnum;
                Enumeration enumeration2 = profileDiffEnum = profileDiffEnum == null || !profileDiffEnum.hasMoreElements() ? request.getHeaders(httpexNumericalNamespace + "-profile-diff") : profileDiffEnum;
                if (profileDiffEnum == null || !profileDiffEnum.hasMoreElements()) {
                    boolean foundProfileDiff = true;
                    int profileDiffNumber = 1;
                    while (foundProfileDiff) {
                        String profileDiffHeader = httpexNumericalNamespace + "-profile-diff-" + profileDiffNumber;
                        profileDiffEnum = request.getHeaders(profileDiffHeader);
                        if (profileDiffEnum == null || !profileDiffEnum.hasMoreElements()) {
                            foundProfileDiff = false;
                            continue;
                        }
                        while (profileDiffEnum.hasMoreElements()) {
                            String value = (String)profileDiffEnum.nextElement();
                            String profileDiff = value.trim();
                            Workspace.printDebug("Found profile diff: " + profileDiff);
                            if (profileDiff.charAt(0) == '\"') {
                                profileDiffMap.put(new Integer(profileDiffNumber), profileDiff.substring(1, profileDiff.length() - 1));
                                continue;
                            }
                            profileDiffMap.put(new Integer(profileDiffNumber), profileDiff);
                        }
                        ++profileDiffNumber;
                    }
                }
                if (profileDiffEnum != null) {
                    while (profileDiffEnum.hasMoreElements()) {
                        String value = (String)profileDiffEnum.nextElement();
                        int profileDiffNumber = Integer.parseInt(value.substring(0, value.indexOf(59)));
                        String profileDiff = value.substring(value.indexOf(59) + 1, value.length());
                        profileDiff.trim();
                        if (profileDiff.charAt(0) == '\"') {
                            profileDiffMap.put(new Integer(profileDiffNumber), profileDiff.substring(1, profileDiff.length() - 1));
                            continue;
                        }
                        profileDiffMap.put(new Integer(profileDiffNumber), profileDiff);
                    }
                }
                if (profileDiffDigestMap.size() != profileDiffMap.size()) {
                    Workspace.printDebug("ProcessHttpRequest: ");
                    Workspace.printDebug("The number of profile-diff-digests and profile-diffs do not match");
                }
                for (int i = 0; i < profileDiffMap.size(); ++i) {
                    Integer r = new Integer(i + 1);
                    String profileDiff = (String)profileDiffMap.get(r);
                    if (Workspace.getInstance().profileDiffDigestVerification && profileDiffDigestMap.size() == profileDiffMap.size()) {
                        String calculatedProfileDiffDigest;
                        profileDiffDigest = (String)profileDiffDigestMap.get(r);
                        if (!profileDiffDigest.equals(calculatedProfileDiffDigest = DeliUtil.calculateProfileDiffDigest(profileDiff, Workspace.getInstance().normaliseWhitespaceInProfileDiff))) {
                            Workspace.printDebug("ProcessHttpRequest|ValidateProfileDiff: ");
                            Workspace.printDebug("ProfileDiffDigest and ProfileDiff do not match");
                            Workspace.printDebug("\tProfileDiffDigest:   " + profileDiffDigest);
                            Workspace.printDebug("\tCalculatedDiffDigest:" + calculatedProfileDiffDigest);
                            continue;
                        }
                        this.diffVector.add(profileDiff);
                        continue;
                    }
                    this.diffVector.add(profileDiff);
                }
                if (this.referenceVector.size() + this.diffVector.size() == 0) {
                    Workspace.printDebug("ProcessHttpRequest: No headers found");
                    this.supportLocalProfiles(request);
                }
                if (Workspace.getInstance().useLocalProfilesIfNoCCPP) {
                    this.supportLocalProfiles(request);
                }
            }
        }
        catch (Exception e) {
            Workspace.printDebug("ProcessHttpRequest: Could not process HTTP request");
            Workspace.printDebug(e.toString());
        }
    }

    private boolean supportLocalProfiles(HttpServletRequest request) throws Exception {
        if (Workspace.getInstance().useLocalProfilesIfNoCCPP) {
            String userAgent = request.getHeader("user-agent");
            if (userAgent != null) {
                String profileReference = Workspace.getInstance().localProfiles.getReference(userAgent);
                if (profileReference != null) {
                    this.referenceVector.add(profileReference);
                    Workspace.printDebug("Useragent " + userAgent + "matches local profile " + profileReference);
                    return true;
                }
                Workspace.printDebug("Unable to find useragent " + userAgent + " in local profile database");
            }
            return false;
        }
        Workspace.printDebug("ProcessHttpRequest: Local profile support disabled");
        return false;
    }

    private String getNumericalNamespace(String httpex) {
        String numericalNamespace = null;
        if (httpex != null && httpex.indexOf("ns=") > 0) {
            numericalNamespace = httpex.substring(httpex.indexOf("ns=") + 3, httpex.length());
        }
        return numericalNamespace;
    }
}

