/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.JenaProcessProfile;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import java.io.InputStream;
import java.util.Date;

public class UAProfValidatorImpl
implements RDFErrorHandler {
    int validProfiles = 0;
    int invalidProfiles = 0;
    int unreachableProfiles = 0;
    int invalidRDF = 0;
    boolean currentProfileValidRDF;
    boolean profileValidFlag = false;
    boolean truststamp = false;
    private JenaReader myARPReader = new JenaReader();

    UAProfValidatorImpl() {
        this.myARPReader.setErrorHandler((RDFErrorHandler)this);
        this.myARPReader.setProperty("WARN_RESOLVING_URI_AGAINST_EMPTY_BASE", (Object)"EM_IGNORE");
    }

    void setTruststamp(boolean _truststamp) {
        this.truststamp = _truststamp;
    }

    boolean process(String profile) {
        if (!this.truststamp) {
            System.out.println("PROFILE:      " + profile);
        }
        this.profileValidFlag = true;
        this.currentProfileValidRDF = true;
        boolean unreachable = false;
        JenaProcessProfile deliProfile = new JenaProcessProfile();
        deliProfile.jenaProfile = ModelFactory.createDefaultModel();
        try {
            InputStream in = Workspace.getInstance().getResource(profile);
            this.myARPReader.read(deliProfile.jenaProfile, in, "");
        }
        catch (RDFException e) {
            System.out.println("Could not parse profile " + profile);
            this.profileValidFlag = false;
            ++this.invalidRDF;
        }
        catch (Exception e) {
            System.out.println("Could not load profile " + profile);
            this.profileValidFlag = false;
            ++this.unreachableProfiles;
            System.out.println("PROFILE IS UNREACHABLE");
            unreachable = true;
        }
        if (!unreachable) {
            if (this.truststamp) {
                Date today = new Date();
                System.out.println("OMA BAC-UAPROF " + Workspace.deliVersionNumber + " validated - " + today);
                System.out.println();
            }
            try {
                deliProfile.processModel(true);
                this.profileValidFlag = deliProfile.validFlag;
            }
            catch (RDFException e) {
                System.out.println(e.toString());
                this.profileValidFlag = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                this.profileValidFlag = false;
                e.printStackTrace();
            }
            if (this.profileValidFlag) {
                System.out.println("PROFILE IS VALID");
                ++this.validProfiles;
            } else {
                System.out.println("PROFILE IS NOT VALID");
                ++this.invalidProfiles;
            }
        }
        System.out.println();
        return this.profileValidFlag;
    }

    void results() {
        if (!this.truststamp) {
            System.out.println("Processing statistics:");
            System.out.println(this.validProfiles + " valid profiles");
            System.out.println(this.invalidProfiles + " invalid profiles");
            System.out.println(this.unreachableProfiles + " unreachable profiles");
            System.out.println(this.invalidRDF + " profiles which were invalid RDF/XML");
        }
    }

    public void warning(Exception e) {
        System.out.println("RDF parser warning:" + e.getMessage());
    }

    public void error(Exception e) {
        System.out.println("RDF parser error:" + e.getMessage());
        if (this.currentProfileValidRDF) {
            ++this.invalidRDF;
            this.currentProfileValidRDF = false;
        }
        this.profileValidFlag = false;
    }

    public void fatalError(Exception e) {
        this.error(e);
    }
}

