/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.VocabularyConfig;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;

class Vocabulary
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap namespaceLookup;
    private HashMap attributeProperties;
    public TypeMapper tm;
    protected HashMap datatypesLookup;

    protected Vocabulary(String configFile) throws ParserConfigurationException {
        VocabularyConfig config = new VocabularyConfig(configFile);
        this.namespaceLookup = config.namespaceLookup;
        this.attributeProperties = config.attributeProperties;
        this.tm = config.tm;
        this.datatypesLookup = config.datatypesLookup;
    }

    protected Resource getAttributeProperty(Resource attributeQName, String paramName) {
        Vector v;
        Iterator i;
        Resource aliasAttributeQName = this.getRealQName(attributeQName);
        if (this.attributeProperties.containsKey(aliasAttributeQName) && (i = (v = (Vector)this.attributeProperties.get(aliasAttributeQName)).iterator()).hasNext()) {
            HashMap currentProperties = (HashMap)i.next();
            return this.getRealQName((Resource)currentProperties.get(paramName));
        }
        return null;
    }

    public boolean usesRDFDatatyping(String prfUri) {
        return this.datatypesLookup.containsValue(prfUri);
    }

    private Resource getRealQName(Resource theUri) {
        Resource aliasQName = null;
        try {
            if (theUri != null) {
                String theUristring = theUri.toString();
                String realUri = this.getRealNamespace(theUristring);
                if (realUri == null) {
                    System.out.println("Fatal error: cannot find " + theUristring);
                    Exception e = new Exception();
                    throw e;
                }
                aliasQName = ResourceFactory.createResource((String)realUri);
            }
        }
        catch (Exception use) {
            Workspace.printDebug("Exception in Vocabulary");
            Workspace.printDebug(use.toString());
            use.printStackTrace();
        }
        return aliasQName;
    }

    protected Vector getAttPropertiesWithAttName(String name) {
        if (name.lastIndexOf("#") > 0) {
            Resource aliasQName = null;
            try {
                String namespace = this.getRealNamespace(name);
                if (namespace != null) {
                    aliasQName = ResourceFactory.createResource((String)this.getRealNamespace(name));
                }
            }
            catch (Exception use) {
                Workspace.printDebug(use.toString());
                use.printStackTrace();
            }
            if (aliasQName != null) {
                return this.getAttPropertiesWithAttName(aliasQName);
            }
            return null;
        }
        Vector v = new Vector();
        Set keys = this.attributeProperties.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Resource qn = (Resource)i.next();
            if (!qn.getLocalName().equals(name)) continue;
            Vector props = (Vector)this.attributeProperties.get(qn);
            v.addAll(props);
        }
        return v;
    }

    protected Vector getAttPropertiesWithAttName(Resource qualifiedAttributeName) {
        return (Vector)this.attributeProperties.get(qualifiedAttributeName);
    }

    protected HashMap getAttribute(Resource attributeQName) {
        Resource aliasAttributeQName = this.getRealQName(attributeQName);
        if (this.attributeProperties.get(aliasAttributeQName) != null) {
            Vector v = (Vector)this.attributeProperties.get(aliasAttributeQName);
            return (HashMap)v.firstElement();
        }
        return null;
    }

    protected void addAttributeToVocabulary(String qualifiedAttribute, String currentComponent, String collectionType) {
        qualifiedAttribute = this.getRealNamespace(qualifiedAttribute);
        Resource temp = ResourceFactory.createResource((String)qualifiedAttribute);
        String theURI = temp.getNameSpace();
        try {
            if (theURI == null) {
                theURI = this.getRealNamespace(currentComponent);
            }
            if (theURI == null) {
                System.out.println("Fatal error: cannot create new attribute when namespace is null");
                Exception e = new Exception();
                throw e;
            }
            currentComponent = currentComponent == null ? theURI + "Unknown" : this.getRealNamespace(currentComponent);
            collectionType = collectionType == null ? "Simple" : collectionType;
            HashMap<String, Resource> properties = new HashMap<String, Resource>();
            properties.put("ccppAttribute", ResourceFactory.createResource((String)qualifiedAttribute));
            properties.put("ccppComponent", this.getRealQName(ResourceFactory.createResource((String)currentComponent)));
            properties.put("ccppType", this.getRealQName(ResourceFactory.createResource((String)(theURI + "Literal"))));
            properties.put("ccppResolution", this.getRealQName(ResourceFactory.createResource((String)(theURI + "Override"))));
            properties.put("ccppCollectionType", this.getRealQName(ResourceFactory.createResource((String)(theURI + collectionType))));
            Vector<HashMap<String, Resource>> v = new Vector<HashMap<String, Resource>>();
            v.add(properties);
            this.attributeProperties.put(properties.get("ccppAttribute"), v);
        }
        catch (Exception use) {
            Workspace.printDebug(use.toString());
            use.printStackTrace();
        }
    }

    protected String getRealNamespace(String alias) {
        if (alias == null) {
            return null;
        }
        String fragment = null;
        String aliasNamespace = null;
        Resource temp = ResourceFactory.createResource((String)alias);
        fragment = temp.getLocalName();
        aliasNamespace = temp.getNameSpace();
        if (aliasNamespace != null) {
            String string = aliasNamespace = aliasNamespace.endsWith("#") ? aliasNamespace : aliasNamespace + "#";
            if (this.namespaceLookup.containsKey(aliasNamespace)) {
                String namespace = (String)this.namespaceLookup.get(aliasNamespace);
                if (fragment != null) {
                    return namespace + fragment;
                }
                return namespace;
            }
        }
        return alias;
    }
}

