/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class VocabularyConfig {
    protected HashMap namespaceLookup;
    protected HashMap attributeProperties;
    String currentCcppUri = null;
    private Vector schemas = new Vector();
    private Vector schemaURIs = new Vector();
    private Vector vocabularies = new Vector();
    protected HashMap datatypesLookup;
    TypeMapper tm = null;
    private List datatypesDef;

    VocabularyConfig(String configFile) throws ParserConfigurationException {
        this.namespaceLookup = new HashMap();
        this.datatypesLookup = new HashMap();
        try {
            InputSource inputSource = Workspace.getInstance().getInputSource(configFile);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            this.parseConfigFile(parser.parse(inputSource));
        }
        catch (Exception e) {
            Workspace.printDebug("DELI Failed to load namespace/vocabulary configuration file from: " + configFile);
            Workspace.printDebug("Exception: " + e);
            e.printStackTrace();
        }
        this.attributeProperties = new HashMap();
        Iterator schema = this.schemas.iterator();
        Iterator schemaURI = this.schemaURIs.iterator();
        Iterator vocabulary = this.vocabularies.iterator();
        if (!vocabulary.hasNext() && !schema.hasNext()) {
            Workspace.printDebug("Vocabulary: No vocabularies or schemas defined.");
        } else {
            while (vocabulary.hasNext()) {
                String vocabularyName = vocabulary.next().toString();
                Workspace.printDebug("Vocabulary: Processing XML vocabulary file: " + vocabularyName);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = dbf.newDocumentBuilder();
                try {
                    InputSource inputSource = Workspace.getInstance().getInputSource(vocabularyName);
                    this.xmlVocabularyTraverse(parser.parse(inputSource));
                }
                catch (Exception e) {
                    Workspace.printDebug("Vocabulary: Cannot load vocabulary configuration file from " + vocabularyName);
                    Workspace.printDebug(e.toString());
                    e.printStackTrace();
                }
            }
            while (schema.hasNext()) {
                String schemaName = schema.next().toString();
                String namespace = schemaURI.next().toString();
                Workspace.printDebug("Vocabulary: Processing UAProf schema vocabulary file: " + schemaName);
                try {
                    InputStream in = Workspace.getInstance().getResource(schemaName);
                    this.schemaProcess(in, namespace);
                }
                catch (Exception e) {
                    Workspace.printDebug("Vocabulary: Cannot load vocabulary schema from " + schemaName);
                    Workspace.printDebug(e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    void parseConfigFile(Node root) throws Exception {
        NodeList nl = root.getChildNodes();
        this.tm = TypeMapper.getInstance();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("namespaceDeclaration")) {
                NodeList namespaces = n.getChildNodes();
                for (int j = 0; j < namespaces.getLength(); ++j) {
                    Node ns = namespaces.item(j);
                    String URI2 = null;
                    if (!ns.getNodeName().equals("namespace")) continue;
                    String datatypeFile = null;
                    String datatypeUri = null;
                    NodeList values = ns.getChildNodes();
                    for (int k = 0; k < values.getLength(); ++k) {
                        Node value = values.item(k);
                        if (value.getNodeName().equals("uri")) {
                            URI2 = value.getFirstChild().getNodeValue();
                            this.namespaceLookup.put(URI2, URI2);
                            continue;
                        }
                        if (value.getNodeName().equals("aliasUri")) {
                            String aliasUri = value.getFirstChild().getNodeValue();
                            this.namespaceLookup.put(aliasUri, URI2);
                            continue;
                        }
                        if (value.getNodeName().equals("schemaVocabularyFile")) {
                            this.schemas.add(value.getFirstChild().getNodeValue());
                            this.schemaURIs.add(URI2);
                            continue;
                        }
                        if (value.getNodeName().equals("vocabularyFile")) {
                            this.vocabularies.add(value.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (value.getNodeName().equals("datatypeUri")) {
                            datatypeUri = value.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!value.getNodeName().equals("datatypeFile")) continue;
                        datatypeFile = value.getFirstChild().getNodeValue();
                    }
                    if (datatypeFile == null) continue;
                    this.datatypesDef = XSDDatatype.loadUserDefined(datatypeUri, (Reader)new FileReader(Workspace.getPath() + datatypeFile), null, (TypeMapper)this.tm);
                    Workspace.printDebug("VocabularyConfig: Defined types are: ");
                    Iterator it = this.datatypesDef.iterator();
                    while (it.hasNext()) {
                        Workspace.printDebug(" - " + it.next());
                    }
                    this.datatypesLookup.put(this.datatypesDef, URI2);
                }
                continue;
            }
            this.parseConfigFile(n);
        }
    }

    void xmlVocabularyTraverse(Node n) throws Exception {
        if (n.getNodeName().equals("attribute") && n.hasChildNodes()) {
            HashMap<String, Resource> properties = new HashMap<String, Resource>();
            NodeList list = n.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node a = list.item(i);
                if (a.getNodeName().equals("name")) {
                    properties.put("ccppAttribute", ResourceFactory.createResource((String)(this.currentCcppUri + a.getFirstChild().getNodeValue())));
                    continue;
                }
                if (a.getNodeName().equals("component")) {
                    properties.put("ccppComponent", ResourceFactory.createResource((String)(this.currentCcppUri + new String(a.getFirstChild().getNodeValue()))));
                    continue;
                }
                if (a.getNodeName().equals("attributeType")) {
                    properties.put("ccppType", ResourceFactory.createResource((String)(this.currentCcppUri + new String(a.getFirstChild().getNodeValue()))));
                    continue;
                }
                if (a.getNodeName().equals("resolution")) {
                    properties.put("ccppResolution", ResourceFactory.createResource((String)(this.currentCcppUri + new String(a.getFirstChild().getNodeValue()))));
                    continue;
                }
                if (!a.getNodeName().equals("collectionType")) continue;
                properties.put("ccppCollectionType", ResourceFactory.createResource((String)(this.currentCcppUri + new String(a.getFirstChild().getNodeValue()))));
            }
            this.addAttributePropertiesToVocabulary(properties);
        } else if (n.getNodeName().equals("ccppUri")) {
            String t = n.getFirstChild().getNodeValue();
            if (t != null) {
                if (t.charAt(t.length() - 1) != '#') {
                    t = t + '#';
                }
                this.currentCcppUri = t;
            }
        } else if (n.hasChildNodes()) {
            this.xmlVocabularyTraverse(n.getFirstChild());
        }
        Node next = n.getNextSibling();
        if (next != null) {
            this.xmlVocabularyTraverse(next);
        }
    }

    private void schemaProcess(InputStream in, String prfUri) throws Exception {
        String attributeName = null;
        String componentName = null;
        String collectionTypeName = null;
        String commentString = null;
        Model vocabularySchema = ModelFactory.createDefaultModel();
        vocabularySchema.read(in, prfUri);
        ResIterator attributeList = null;
        Property domainProperty = null;
        Property rangeProperty = null;
        Property resolutionRuleProperty = null;
        Iterator i = Workspace.getInstance().rdfsUri.iterator();
        while (i.hasNext()) {
            String theRdfsUri = (String)i.next();
            domainProperty = vocabularySchema.createProperty(theRdfsUri + "domain");
            rangeProperty = vocabularySchema.createProperty(theRdfsUri + "range");
            attributeList = vocabularySchema.listSubjectsWithProperty(domainProperty);
            if (this.datatypesLookup.containsValue(prfUri)) {
                resolutionRuleProperty = vocabularySchema.createProperty(prfUri + "ResolutionRule");
                Iterator datatypesDefIterator = this.datatypesDef.iterator();
                while (datatypesDefIterator.hasNext()) {
                    vocabularySchema.createTypedLiteral(datatypesDefIterator.next());
                }
            }
            while (attributeList.hasNext()) {
                HashMap<String, Resource> properties = new HashMap<String, Resource>();
                Resource attribute = (Resource)attributeList.next();
                attributeName = attribute.getLocalName();
                if (attributeName.equals("Defaults") || attributeName.equals("ResolutionRule")) continue;
                Iterator rdfsIterator = null;
                rdfsIterator = Workspace.getInstance().rdfsUri.iterator();
                Vector<Object> componentListVector = new Vector<Object>();
                while (rdfsIterator.hasNext()) {
                    NodeIterator componentList = vocabularySchema.listObjectsOfProperty(attribute, vocabularySchema.createProperty((String)rdfsIterator.next() + "domain"));
                    while (componentList.hasNext()) {
                        componentListVector.add(componentList.next());
                    }
                }
                Iterator fullComponentList = componentListVector.iterator();
                while (fullComponentList.hasNext()) {
                    Resource component = (Resource)fullComponentList.next();
                    componentName = component.getURI();
                }
                collectionTypeName = "Simple";
                String attributeType = "Any";
                boolean ccppTypeFound = false;
                String resolutionRule = "Override";
                NodeIterator rangeList = vocabularySchema.listObjectsOfProperty(attribute, rangeProperty);
                while (rangeList.hasNext()) {
                    Resource rangeEntry = (Resource)rangeList.next();
                    if (rangeEntry.toString().endsWith("Bag") || rangeEntry.toString().endsWith("Seq")) {
                        collectionTypeName = rangeEntry.getLocalName();
                    }
                    if (!rangeEntry.toString().endsWith("Boolean") && !rangeEntry.toString().endsWith("Dimension") && !rangeEntry.toString().endsWith("Number") && !rangeEntry.toString().endsWith("Literal")) continue;
                    properties.put("ccppType", ResourceFactory.createResource((String)rangeEntry.toString()));
                    ccppTypeFound = true;
                }
                if (this.datatypesLookup.containsValue(prfUri)) {
                    NodeIterator resolutionRuleList = vocabularySchema.listObjectsOfProperty(attribute, resolutionRuleProperty);
                    if (resolutionRuleList.hasNext()) {
                        Literal resolution = (Literal)resolutionRuleList.next();
                        resolutionRule = resolution.getValue().toString();
                    }
                } else {
                    rdfsIterator = Workspace.getInstance().rdfsUri.iterator();
                    Vector<Object> commentListVector = new Vector<Object>();
                    while (rdfsIterator.hasNext()) {
                        NodeIterator commentList = vocabularySchema.listObjectsOfProperty(attribute, vocabularySchema.createProperty((String)rdfsIterator.next() + "comment"));
                        while (commentList.hasNext()) {
                            commentListVector.add(commentList.next());
                        }
                    }
                    Iterator fullCommentList = commentListVector.iterator();
                    while (fullCommentList.hasNext()) {
                        RDFNode comment = (RDFNode)fullCommentList.next();
                        commentString = comment.toString();
                    }
                    if (commentString.indexOf("(bag)") > 0) {
                        if (!collectionTypeName.equals("Bag")) {
                            Workspace.printDebug("Vocabulary inconsistency warning: " + attributeName + " only declares it is a Bag in the comments field ");
                        }
                        collectionTypeName = "Bag";
                    } else if (commentString.indexOf("(sequence)") > 0) {
                        if (!collectionTypeName.equals("Seq")) {
                            Workspace.printDebug("Vocabulary inconsistency warning: " + attributeName + " only declares it is a Seq in the comments field ");
                        }
                        collectionTypeName = "Seq";
                    }
                    StringTokenizer str = new StringTokenizer(commentString, " \t");
                    while (str.hasMoreTokens()) {
                        String current = str.nextToken();
                        if (current.equals("Type:")) {
                            attributeType = str.nextToken().trim();
                            if (!(attributeType.equals("Boolean") || attributeType.equals("Literal") || attributeType.equals("Number") || attributeType.equals("Dimension"))) {
                                System.out.println("FATAL ERROR LOADING VOCABULARY: " + attributeName + " does not have a valid type " + attributeType);
                            }
                            properties.put("ccppType", ResourceFactory.createResource((String)(prfUri + attributeType)));
                            ccppTypeFound = true;
                        }
                        if (!current.equals("Resolution:")) continue;
                        resolutionRule = str.nextToken().trim();
                    }
                }
                if (!ccppTypeFound) {
                    properties.put("ccppType", ResourceFactory.createResource((String)(prfUri + attributeType)));
                }
                properties.put("ccppAttribute", ResourceFactory.createResource((String)(prfUri + attributeName)));
                properties.put("ccppComponent", ResourceFactory.createResource((String)componentName));
                properties.put("ccppResolution", ResourceFactory.createResource((String)(prfUri + resolutionRule)));
                properties.put("ccppCollectionType", ResourceFactory.createResource((String)(prfUri + collectionTypeName)));
                this.addAttributePropertiesToVocabulary(properties);
            }
        }
    }

    private void addAttributePropertiesToVocabulary(HashMap properties) {
        if (this.attributeProperties.containsKey(properties.get("ccppAttribute"))) {
            Iterator i = ((Vector)this.attributeProperties.get(properties.get("ccppAttribute"))).iterator();
            boolean found = false;
            while (i.hasNext()) {
                HashMap existingPropertySet = (HashMap)i.next();
                if ((Resource)existingPropertySet.get("ccppComponent") == null || (Resource)properties.get("ccppComponent") == null) {
                    if ((Resource)existingPropertySet.get("ccppComponent") != (Resource)properties.get("ccppComponent")) continue;
                    found = true;
                    continue;
                }
                if (!((Resource)existingPropertySet.get("ccppComponent")).equals(properties.get("ccppComponent"))) continue;
                found = true;
            }
            if (!found) {
                ((Vector)this.attributeProperties.get(properties.get("ccppAttribute"))).add(properties);
            }
        } else {
            Vector<HashMap> v = new Vector<HashMap>();
            v.add(properties);
            this.attributeProperties.put(properties.get("ccppAttribute"), v);
        }
    }
}

