/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.DatatypeExpression;
import com.hp.hpl.deli.LocalProfiles;
import com.hp.hpl.deli.ProfileCache;
import com.hp.hpl.deli.Vocabulary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Workspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String deliVersionNumber = "deli-x070105";
    private static Logger logger = Logger.getLogger((String)"com.hp.hpl.deli.Workspace");
    private static transient Workspace _instance = null;
    private static final long HOURINMILLISECONDS = 3600000L;
    protected static boolean useLog4j = true;
    protected static String path = null;
    protected HashMap datatypeExpressions;
    private transient ServletContext servletContext;
    protected Vocabulary vocabulary;
    protected transient ProfileCache profileCache;
    protected transient LocalProfiles localProfiles;
    protected long maxCachedProfileLifetime = 86400000L;
    protected int maxCacheSize = 100;
    protected boolean datatypeValidationOn = true;
    protected boolean refreshStaleProfiles = false;
    protected boolean processUndefinedAttributes = false;
    protected boolean normaliseWhitespaceInProfileDiff = false;
    protected boolean profileDiffDigestVerification = false;
    protected boolean useLocalProfilesIfNoCCPP = true;
    protected String localProfilesPath = null;
    protected String datatypeConfigFile = "config/uaprofValidatorConfig.xml";
    protected boolean processUnconfiguredNamespaces = true;
    protected boolean printDefaults = true;
    protected boolean debug = false;
    protected boolean debugRequestHeaders = false;
    protected boolean printProfileBeforeMerge = false;
    protected boolean cacheReferenceProfiles = true;
    protected String rdfUri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected Vector rdfsUri;
    protected String componentProperty = "component";
    protected boolean preferLocalOverRemoteProfiles = false;
    protected boolean enforceUAProfTwoDatatypes = false;

    public Workspace() {
        _instance = this;
        this.servletContext = null;
    }

    public static Workspace getInstance() {
        if (_instance == null) {
            _instance = new Workspace();
        }
        return _instance;
    }

    public static void setInstance(Workspace w) {
        _instance = w;
    }

    public void configure(ServletContext sc, String filename) throws ParserConfigurationException {
        this.servletContext = sc;
        String tempPath = System.getProperty("deliHome");
        if (tempPath != null) {
            path = tempPath;
            Workspace.printDebug("Using deliHome: " + path);
        }
        if (this.servletContext != null) {
            if (path == null) {
                try {
                    path = this.servletContext.getRealPath("/WEB-INF");
                    Workspace.printDebug("Using getRealPath: " + path);
                }
                catch (Exception e) {
                    System.out.println("Unable to use getRealPath to locate /WEB-INF");
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            }
            if (path == null) {
                try {
                    URL resUrl = this.servletContext.getResource("/WEB-INF");
                    if (resUrl != null) {
                        path = resUrl.toString();
                        Workspace.printDebug("Using getResource: " + path);
                    }
                }
                catch (MalformedURLException me) {
                    System.out.println("Unable to use getResource to locate /WEB-INF");
                    System.out.println(me.toString());
                    me.printStackTrace();
                }
            }
        } else {
            path = "";
        }
        if (path != null && path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        Workspace.printDebug("DELI is using path: " + path);
        class CreateWorkspace {
            String namespaceConfigFile = null;
            String localProfilesFile = null;
            private final /* synthetic */ String val$filename;

            CreateWorkspace(String val$filename) throws ParserConfigurationException {
                this.val$filename = val$filename;
                Workspace.this.rdfsUri = new Vector();
                Workspace.this.rdfsUri.add("http://www.w3.org/2000/01/rdf-schema#");
                Workspace.printDebug("Workspace: loading configuration file");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = dbf.newDocumentBuilder();
                try {
                    InputSource inputSource = Workspace.this.getInputSource(this.val$filename);
                    this.traverse(parser.parse(inputSource));
                }
                catch (Exception e) {
                    Workspace.printDebug("Workspace: Cannot load workspace configuration file from " + path + this.val$filename);
                    e.printStackTrace();
                }
                Workspace.printDebug("Workspace: loading vocabularies");
                Workspace.this.vocabulary = new Vocabulary(this.namespaceConfigFile);
                Workspace.printDebug("Workspace: Creating the local profiles database");
                Workspace.this.localProfiles = new LocalProfiles(this.localProfilesFile);
                try {
                    new DatatypeExpression(Workspace.this.datatypeConfigFile);
                }
                catch (Exception e) {
                    Workspace.printDebug("Failed to load validator datatypes from config/uaprofValidatorConfig.xml");
                    Workspace.printDebug("Using defaults");
                }
            }

            private void traverse(Node n) {
                Node next;
                new 1CreateWorkspace.UpdateProperties(n);
                if (n.hasChildNodes()) {
                    this.traverse(n.getFirstChild());
                }
                if ((next = n.getNextSibling()) != null) {
                    this.traverse(next);
                }
            }

            class 1CreateWorkspace.UpdateProperties {
                Node n;

                1CreateWorkspace.UpdateProperties(Node _n) {
                    this.n = _n;
                    ((CreateWorkspace)this).Workspace.this.debug = this.set("debug", ((CreateWorkspace)this).Workspace.this.debug);
                    ((CreateWorkspace)this).Workspace.this.profileDiffDigestVerification = this.set("profileDiffDigestVerification", ((CreateWorkspace)this).Workspace.this.profileDiffDigestVerification);
                    ((CreateWorkspace)this).Workspace.this.preferLocalOverRemoteProfiles = this.set("preferLocalOverRemoteProfiles", ((CreateWorkspace)this).Workspace.this.preferLocalOverRemoteProfiles);
                    ((CreateWorkspace)this).Workspace.this.debugRequestHeaders = this.set("debugRequestHeaders", ((CreateWorkspace)this).Workspace.this.debugRequestHeaders);
                    ((CreateWorkspace)this).Workspace.this.refreshStaleProfiles = this.set("refreshStaleProfiles", ((CreateWorkspace)this).Workspace.this.refreshStaleProfiles);
                    ((CreateWorkspace)this).Workspace.this.useLocalProfilesIfNoCCPP = this.set("useLocalProfilesIfNoCCPP", ((CreateWorkspace)this).Workspace.this.useLocalProfilesIfNoCCPP);
                    ((CreateWorkspace)this).Workspace.this.processUndefinedAttributes = this.set("processUndefinedAttributes", ((CreateWorkspace)this).Workspace.this.processUndefinedAttributes);
                    ((CreateWorkspace)this).Workspace.this.normaliseWhitespaceInProfileDiff = this.set("normaliseWhitespaceInProfileDiff", ((CreateWorkspace)this).Workspace.this.normaliseWhitespaceInProfileDiff);
                    ((CreateWorkspace)this).Workspace.this.processUnconfiguredNamespaces = this.set("processUnconfiguredNamespaces", ((CreateWorkspace)this).Workspace.this.processUnconfiguredNamespaces);
                    ((CreateWorkspace)this).Workspace.this.cacheReferenceProfiles = this.set("cacheReferenceProfiles", ((CreateWorkspace)this).Workspace.this.cacheReferenceProfiles);
                    ((CreateWorkspace)this).Workspace.this.printDefaults = this.set("printDefaults", ((CreateWorkspace)this).Workspace.this.printDefaults);
                    ((CreateWorkspace)this).Workspace.this.printProfileBeforeMerge = this.set("printProfileBeforeMerge", ((CreateWorkspace)this).Workspace.this.printProfileBeforeMerge);
                    useLog4j = this.set("useLog4j", useLog4j);
                    ((CreateWorkspace)this).Workspace.this.datatypeValidationOn = this.set("datatypeValidationOn", ((CreateWorkspace)this).Workspace.this.datatypeValidationOn);
                    namespaceConfigFile = this.set("namespaceConfigFile", namespaceConfigFile);
                    localProfilesFile = this.set("localProfilesFile", localProfilesFile);
                    ((CreateWorkspace)this).Workspace.this.localProfilesPath = this.set("localProfilesPath", ((CreateWorkspace)this).Workspace.this.localProfilesPath);
                    ((CreateWorkspace)this).Workspace.this.datatypeConfigFile = this.set("datatypeConfigFile", ((CreateWorkspace)this).Workspace.this.datatypeConfigFile);
                    ((CreateWorkspace)this).Workspace.this.componentProperty = this.set("componentProperty", ((CreateWorkspace)this).Workspace.this.componentProperty);
                    ((CreateWorkspace)this).Workspace.this.enforceUAProfTwoDatatypes = this.set("enforceUAProfTwoDatatypes", ((CreateWorkspace)this).Workspace.this.enforceUAProfTwoDatatypes);
                    ((CreateWorkspace)this).Workspace.this.rdfUri = this.set("rdfUri", ((CreateWorkspace)this).Workspace.this.rdfUri);
                    String nodename = this.n.getNodeName();
                    if (nodename.equals("rdfsUri")) {
                        ((CreateWorkspace)this).Workspace.this.rdfsUri.add(Workspace.this.setUriProperty(this.n));
                        Workspace.printDebug("Adding rdfsUri: " + Workspace.this.setUriProperty(this.n));
                    } else if (nodename.equals("maxCachedProfileLifetime")) {
                        ((CreateWorkspace)this).Workspace.this.maxCachedProfileLifetime = Long.parseLong(this.n.getFirstChild().getNodeValue()) * 3600000L;
                        Workspace.printDebug("Setting maxCachedProfileLifetime: " + this.n.getFirstChild().getNodeValue());
                    } else if (nodename.equals("maxCacheSize")) {
                        ((CreateWorkspace)this).Workspace.this.maxCacheSize = Integer.parseInt(this.n.getFirstChild().getNodeValue());
                        Workspace.printDebug("Setting maxCacheSize: " + this.n.getFirstChild().getNodeValue());
                    }
                }

                private boolean set(String name, boolean current) {
                    if (this.n.getNodeName().equals(name)) {
                        Workspace.printDebug("Setting " + name + ": " + this.n.getFirstChild().getNodeValue());
                        return this.n.getFirstChild().getNodeValue().toLowerCase().equals("true");
                    }
                    return current;
                }

                private String set(String name, String current) {
                    if (this.n.getNodeName().equals(name)) {
                        Workspace.printDebug("Setting " + name + ": " + this.n.getFirstChild().getNodeValue());
                        return this.n.getFirstChild().getNodeValue();
                    }
                    return current;
                }
            }
        }
        new CreateWorkspace(filename);
        Workspace.printDebug("Workspace: Creating the profile cache");
        this.profileCache = new ProfileCache();
        Workspace.printDebug("Workspace: Finished creating workspace");
    }

    protected static void printDebug(String output) {
        if (Workspace._instance.debug && useLog4j && logger.isDebugEnabled()) {
            logger.log((Priority)Level.DEBUG, (Object)output);
        }
    }

    protected static void printWarning(String output) {
        logger.log((Priority)Level.WARN, (Object)output);
    }

    protected static void printInfo(String output) {
        logger.log((Priority)Level.INFO, (Object)output);
    }

    private String setUriProperty(Node n) {
        String t = n.getFirstChild().getNodeValue();
        if (t != null) {
            if (t.charAt(t.length() - 1) != '#') {
                t = t + '#';
            }
            return t;
        }
        return null;
    }

    protected InputSource getInputSource(String name) throws Exception {
        InputStream in = this.getResource(name);
        InputStreamReader resource = new InputStreamReader(in);
        InputSource inputSource = new InputSource(resource);
        return inputSource;
    }

    public static String getPath() {
        return path;
    }

    protected InputStream getResource(String name) throws Exception {
        try {
            InputStream in;
            Workspace.printDebug("Getting resource: " + path + name);
            File file = new File(path + name);
            if (name.startsWith("http") || name.startsWith("file") || name.startsWith("jndi")) {
                in = new URL(name).openStream();
            } else if (file.exists()) {
                in = new FileInputStream(path + name);
            } else if (this.servletContext != null) {
                URL url = this.servletContext.getResource(path + name);
                in = url.openStream();
            } else {
                in = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return in;
        }
        catch (FileNotFoundException fnfe) {
            Workspace.printDebug("Could not load file: " + name);
            System.out.println(fnfe.toString());
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            Workspace.printDebug("Cannot retrieve resource: " + name);
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return null;
    }
}

