/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Service;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;

public final class Session {
    private static final Class[] PARAM_TYPES = new Class[]{class$javax$mail$Session == null ? (class$javax$mail$Session = Session.class$("javax.mail.Session")) : class$javax$mail$Session, class$javax$mail$URLName == null ? (class$javax$mail$URLName = Session.class$("javax.mail.URLName")) : class$javax$mail$URLName};
    private static final Map addressMap = new HashMap();
    private static Session DEFAULT_SESSION;
    private Map passwordAuthentications = new HashMap();
    private final Properties properties;
    private final Authenticator authenticator;
    private boolean debug;
    private PrintStream debugOut = System.out;
    private static final WeakHashMap providersByClassLoader;
    static /* synthetic */ Class class$javax$mail$Session;
    static /* synthetic */ Class class$javax$mail$URLName;

    private Session(Properties properties, Authenticator authenticator) {
        this.properties = properties;
        this.authenticator = authenticator;
        this.debug = Boolean.valueOf(properties.getProperty("mail.debug"));
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        return new Session(new Properties(properties), authenticator);
    }

    public static Session getInstance(Properties properties) {
        return Session.getInstance(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties) {
        return Session.getDefaultInstance(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (DEFAULT_SESSION == null) {
            DEFAULT_SESSION = Session.getInstance(properties, authenticator);
        } else if (authenticator != Session.DEFAULT_SESSION.authenticator && (authenticator == null || Session.DEFAULT_SESSION.authenticator == null || authenticator.getClass().getClassLoader() != Session.DEFAULT_SESSION.authenticator.getClass().getClassLoader())) {
            throw new SecurityException();
        }
        return DEFAULT_SESSION;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebugOut(PrintStream out) {
        this.debugOut = out == null ? System.out : out;
    }

    public PrintStream getDebugOut() {
        return this.debugOut;
    }

    public Provider[] getProviders() {
        ProviderInfo info = Session.getProviderInfo();
        return info.all.toArray(new Provider[info.all.size()]);
    }

    public Provider getProvider(String protocol) throws NoSuchProviderException {
        ProviderInfo info = Session.getProviderInfo();
        String providerName = this.properties.getProperty("mail." + protocol + ".class");
        Provider provider = providerName != null ? (Provider)info.byClassName.get(providerName) : (Provider)info.byProtocol.get(protocol);
        if (provider == null) {
            throw new NoSuchProviderException("Unable to locate provider for protocol: " + protocol);
        }
        return provider;
    }

    public void setProvider(Provider provider) throws NoSuchProviderException {
        ProviderInfo info = Session.getProviderInfo();
        info.byProtocol.put(provider.getProtocol(), provider);
    }

    public Store getStore() throws NoSuchProviderException {
        String protocol = this.properties.getProperty("mail.store.protocol");
        if (protocol == null) {
            throw new NoSuchProviderException("mail.store.protocol property is not set");
        }
        return this.getStore(protocol);
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        Provider provider = this.getProvider(protocol);
        return this.getStore(provider);
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        return (Store)this.getService(this.getProvider(url.getProtocol()), url);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        if (Provider.Type.STORE != provider.getType()) {
            throw new NoSuchProviderException("Not a Store Provider: " + provider);
        }
        return (Store)this.getService(provider, null);
    }

    public Folder getFolder(URLName name) throws MessagingException {
        Store store = this.getStore(name);
        return store.getFolder(name);
    }

    public Transport getTransport() throws NoSuchProviderException {
        String protocol = this.properties.getProperty("mail.transport.protocol");
        if (protocol == null) {
            throw new NoSuchProviderException("mail.transport.protocol property is not set");
        }
        return this.getTransport(protocol);
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        Provider provider = this.getProvider(protocol);
        return this.getTransport(provider);
    }

    public Transport getTransport(URLName name) throws NoSuchProviderException {
        return (Transport)this.getService(this.getProvider(name.getProtocol()), name);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String type = address.getType();
        return this.getTransport((String)addressMap.get(type));
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return (Transport)this.getService(provider, null);
    }

    public void setPasswordAuthentication(URLName name, PasswordAuthentication authenticator) {
        if (authenticator == null) {
            this.passwordAuthentications.remove(name);
        } else {
            this.passwordAuthentications.put(name, authenticator);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName name) {
        return (PasswordAuthentication)this.passwordAuthentications.get(name);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress host, int port, String protocol, String prompt, String defaultUserName) {
        if (this.authenticator == null) {
            return null;
        }
        return this.authenticator.authenticate(host, port, protocol, prompt, defaultUserName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) {
        return this.getProperties().getProperty(property);
    }

    private Service getService(Provider provider, URLName name) throws NoSuchProviderException {
        try {
            ClassLoader cl = Session.getClassLoader();
            Class<?> clazz = cl.loadClass(provider.getClassName());
            Constructor<?> ctr = clazz.getConstructor(PARAM_TYPES);
            return (Service)ctr.newInstance(this, name);
        }
        catch (ClassNotFoundException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Unable to load class for provider: " + provider).initCause(e);
        }
        catch (NoSuchMethodException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Provider class does not have a constructor(Session, URLName): " + provider).initCause(e);
        }
        catch (InstantiationException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Unable to instantiate provider class: " + provider).initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Unable to instantiate provider class: " + provider).initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Exception from constructor of provider class: " + provider).initCause(e.getCause());
        }
    }

    private static ProviderInfo getProviderInfo() {
        ClassLoader cl = Session.getClassLoader();
        ProviderInfo info = (ProviderInfo)providersByClassLoader.get(cl);
        if (info == null) {
            info = Session.loadProviders(cl);
        }
        return info;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$javax$mail$Session == null ? (class$javax$mail$Session = Session.class$("javax.mail.Session")) : class$javax$mail$Session).getClassLoader();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProviderInfo loadProviders(ClassLoader cl) {
        InputStream is;
        URL url;
        Enumeration<URL> e;
        ProviderInfo info = new ProviderInfo();
        try {
            File file = new File(System.getProperty("java.home"), "lib/javamail.providers");
            FileInputStream is2 = new FileInputStream(file);
            try {
                Session.loadProviders(info, is2);
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        catch (SecurityException e2) {
        }
        catch (IOException e3) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.providers");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    Session.loadProviders(info, is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e4) {
        }
        catch (IOException e5) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.default.providers");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    Session.loadProviders(info, is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e6) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    private static void loadProviders(ProviderInfo info, InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, ";");
            String protocol = null;
            Provider.Type type = null;
            String className = null;
            String vendor = null;
            String version = null;
            while (tok.hasMoreTokens()) {
                String property = tok.nextToken();
                int index = property.indexOf(61);
                if (index == -1) continue;
                String key = property.substring(0, index).trim();
                String value = property.substring(index + 1).trim();
                if (protocol == null && "protocol".equals(key)) {
                    protocol = value;
                    continue;
                }
                if (type == null && "type".equals(key)) {
                    if ("store".equals(value)) {
                        type = Provider.Type.STORE;
                        continue;
                    }
                    if (!"transport".equals(value)) continue;
                    type = Provider.Type.TRANSPORT;
                    continue;
                }
                if (className == null && "class".equals(key)) {
                    className = value;
                    continue;
                }
                if ("vendor".equals(key)) {
                    vendor = value;
                    continue;
                }
                if (!"version".equals(key)) continue;
                version = value;
            }
            if (protocol == null || type == null || className == null) continue;
            Provider provider = new Provider(protocol, className, type, vendor, version);
            if (!info.byClassName.containsKey(className)) {
                info.byClassName.put(className, provider);
            }
            if (!info.byProtocol.containsKey(protocol)) {
                info.byProtocol.put(protocol, provider);
            }
            info.all.add(provider);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        providersByClassLoader = new WeakHashMap();
        addressMap.put("rfc822", "smtp");
    }

    private static class ProviderInfo {
        private final Map byClassName = new HashMap();
        private final Map byProtocol = new HashMap();
        private final List all = new ArrayList();

        private ProviderInfo() {
        }
    }
}

