/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;

public class MimeMultipart
extends Multipart {
    protected DataSource ds;
    protected boolean parsed;
    private transient ContentType type;
    private static byte[] dash = new byte[]{45, 45};
    private static byte[] crlf = new byte[]{13, 10};
    private static int part;
    static /* synthetic */ Class class$javax$mail$internet$MimeMultipart;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        this.type = new ContentType("multipart", subtype, null);
        this.type.setParameter("boundary", MimeMultipart.getBoundary());
        this.contentType = this.type.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        this.ds = dataSource;
        if (dataSource instanceof MultipartDataSource) {
            super.setMultipartDataSource((MultipartDataSource)dataSource);
            this.parsed = true;
        } else {
            this.type = new ContentType(this.ds.getContentType());
            this.contentType = this.type.toString();
            this.parsed = false;
        }
    }

    public void setSubType(String subtype) throws MessagingException {
        this.type.setSubType(subtype);
        this.contentType = this.type.toString();
    }

    public int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int part) throws MessagingException {
        this.parse();
        return super.getBodyPart(part);
    }

    public BodyPart getBodyPart(String cid) throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            if (!cid.equals(bodyPart.getContentID())) continue;
            return bodyPart;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            bodyPart.updateHeaders();
        }
    }

    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.parse();
        String boundary = this.type.getParameter("boundary");
        byte[] bytes = boundary.getBytes();
        for (int i = 0; i < this.parts.size(); ++i) {
            BodyPart bodyPart = (BodyPart)this.parts.get(i);
            out.write(dash);
            out.write(bytes);
            out.write(crlf);
            bodyPart.writeTo(out);
            out.write(crlf);
        }
        out.write(dash);
        out.write(bytes);
        out.write(dash);
        out.write(crlf);
        out.flush();
    }

    protected void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream in) throws MessagingException {
        return new InternetHeaders(in);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] data) throws MessagingException {
        return new MimeBodyPart(headers, data);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream in) throws MessagingException {
        return new MimeBodyPart(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getBoundary() {
        int i;
        Class clazz = class$javax$mail$internet$MimeMultipart == null ? (class$javax$mail$internet$MimeMultipart = MimeMultipart.class$("javax.mail.internet.MimeMultipart")) : class$javax$mail$internet$MimeMultipart;
        synchronized (clazz) {
            i = part++;
        }
        StringBuffer buf = new StringBuffer(64);
        buf.append("----=_Part_").append(i).append('.').append(System.currentTimeMillis());
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

