/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyManagerImpl
implements HierarchyManager {
    private static Logger log = LoggerFactory.getLogger((Class)HierarchyManagerImpl.class);
    private static final QName EMPTY_NAME = new QName("", "");
    protected final NodeId rootNodeId;
    protected final ItemStateManager provider;
    protected final NamespaceResolver nsResolver;

    public HierarchyManagerImpl(NodeId rootNodeId, ItemStateManager provider, NamespaceResolver nsResolver) {
        this.rootNodeId = rootNodeId;
        this.provider = provider;
        this.nsResolver = nsResolver;
    }

    public NodeId getRootNodeId() {
        return this.rootNodeId;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public String safeGetJCRPath(Path path) {
        try {
            return path.toJCRPath(this.nsResolver);
        }
        catch (NoPrefixDeclaredException npde) {
            log.error("failed to convert " + path.toString() + " to JCR path.");
            return path.toString();
        }
    }

    public String safeGetJCRPath(ItemId id) {
        try {
            return this.safeGetJCRPath(this.getPath(id));
        }
        catch (RepositoryException re) {
            log.error(id + ": failed to determine path to");
            return id.toString();
        }
    }

    protected ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        return this.provider.getItemState(id);
    }

    protected boolean hasItemState(ItemId id) {
        return this.provider.hasItemState(id);
    }

    protected NodeId getParentId(ItemState state) {
        return state.getParentId();
    }

    protected NodeState.ChildNodeEntry getChildNodeEntry(NodeState parent, NodeId id) {
        return parent.getChildNodeEntry(id);
    }

    protected NodeState.ChildNodeEntry getChildNodeEntry(NodeState parent, QName name, int index) {
        return parent.getChildNodeEntry(name, index);
    }

    protected ItemId resolvePath(Path path, ItemId id, int next) throws RepositoryException {
        try {
            return this.resolvePath(path, this.getItemState(id), next);
        }
        catch (NoSuchItemStateException e) {
            String msg = "failed to retrieve state of intermediary node";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        catch (ItemStateException e) {
            String msg = "failed to retrieve state of intermediary node";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ItemId resolvePath(Path path, ItemState state, int next) throws PathNotFoundException, ItemStateException {
        void var9_10;
        ItemId childId;
        NodeState parentState;
        Path.PathElement[] elements = path.getElements();
        if (elements.length == next) {
            return state.getId();
        }
        Path.PathElement elem = elements[next];
        QName name = elem.getName();
        int index = elem.getIndex();
        if (index == 0) {
            index = 1;
        }
        if ((parentState = (NodeState)state).hasChildNodeEntry(name, index)) {
            NodeState.ChildNodeEntry nodeEntry = this.getChildNodeEntry(parentState, name, index);
            childId = nodeEntry.getId();
        } else if (parentState.hasPropertyName(name)) {
            if (index > 1) {
                throw new PathNotFoundException(this.safeGetJCRPath(path));
            }
            if (next < elements.length - 1) {
                throw new PathNotFoundException(this.safeGetJCRPath(path));
            }
            childId = new PropertyId(parentState.getNodeId(), name);
        } else {
            throw new PathNotFoundException(this.safeGetJCRPath(path));
        }
        return this.resolvePath(path, this.getItemState((ItemId)var9_10), next + 1);
    }

    protected void buildPath(Path.PathBuilder builder, ItemState state) throws ItemStateException, RepositoryException {
        if (state.getId().equals(this.rootNodeId)) {
            builder.addRoot();
            return;
        }
        NodeId parentId = this.getParentId(state);
        if (parentId == null) {
            String msg = "failed to build path of " + state.getId() + ": orphaned item";
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        NodeState parent = (NodeState)this.getItemState(parentId);
        this.buildPath(builder, parent);
        if (state.isNode()) {
            NodeState nodeState = (NodeState)state;
            NodeId id = nodeState.getNodeId();
            NodeState.ChildNodeEntry entry = this.getChildNodeEntry(parent, id);
            if (entry == null) {
                String msg = "failed to build path of " + state.getId() + ": " + parent.getNodeId() + " has no child entry for " + id;
                log.debug(msg);
                throw new ItemNotFoundException(msg);
            }
            if (entry.getIndex() == 1) {
                builder.addLast(entry.getName());
            } else {
                builder.addLast(entry.getName(), entry.getIndex());
            }
        } else {
            PropertyState propState = (PropertyState)state;
            QName name = propState.getName();
            builder.addLast(name);
        }
    }

    public ItemId resolvePath(Path path) throws PathNotFoundException, RepositoryException {
        if (path.denotesRoot()) {
            return this.rootNodeId;
        }
        if (!path.isCanonical()) {
            String msg = "path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        return this.resolvePath(path, this.rootNodeId, 1);
    }

    public Path getPath(ItemId id) throws ItemNotFoundException, RepositoryException {
        if (id.equals(this.rootNodeId)) {
            return Path.ROOT;
        }
        Path.PathBuilder builder = new Path.PathBuilder();
        try {
            this.buildPath(builder, this.getItemState(id));
            return builder.getPath();
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        catch (MalformedPathException mpe) {
            String msg = "failed to build path of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
    }

    public QName getName(ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (itemId.denotesNode()) {
            NodeState parentState;
            NodeId nodeId = (NodeId)itemId;
            try {
                NodeState nodeState = (NodeState)this.getItemState(nodeId);
                NodeId parentId = this.getParentId(nodeState);
                if (parentId == null) {
                    return EMPTY_NAME;
                }
                parentState = (NodeState)this.getItemState(parentId);
            }
            catch (NoSuchItemStateException nsis) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new ItemNotFoundException(nodeId.toString());
            }
            catch (ItemStateException ise) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
            NodeState.ChildNodeEntry entry = this.getChildNodeEntry(parentState, nodeId);
            if (entry == null) {
                String msg = "failed to resolve name of " + nodeId;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            return entry.getName();
        }
        return ((PropertyId)itemId).getName();
    }

    public int getDepth(ItemId id) throws ItemNotFoundException, RepositoryException {
        if (id.equals(this.rootNodeId)) {
            return 0;
        }
        try {
            ItemState state = this.getItemState(id);
            NodeId parentId = this.getParentId(state);
            int depth = 0;
            while (parentId != null) {
                ++depth;
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return depth;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine depth of " + id;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine depth of " + id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    public int getRelativeDepth(NodeId ancestorId, ItemId descendantId) throws ItemNotFoundException, RepositoryException {
        if (ancestorId.equals(descendantId)) {
            return 0;
        }
        int depth = 1;
        try {
            ItemState state = this.getItemState(descendantId);
            NodeId parentId = this.getParentId(state);
            while (parentId != null) {
                if (parentId.equals(ancestorId)) {
                    return depth;
                }
                ++depth;
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return -1;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine depth of " + descendantId + " relative to " + ancestorId;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine depth of " + descendantId + " relative to " + ancestorId;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    public boolean isAncestor(NodeId nodeId, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (nodeId.equals(itemId)) {
            return false;
        }
        try {
            ItemState state = this.getItemState(itemId);
            NodeId parentId = this.getParentId(state);
            while (parentId != null) {
                if (parentId.equals(nodeId)) {
                    return true;
                }
                state = this.getItemState(parentId);
                parentId = this.getParentId(state);
            }
            return false;
        }
        catch (NoSuchItemStateException nsise) {
            String msg = "failed to determine degree of relationship of " + nodeId + " and " + itemId;
            log.debug(msg);
            throw new ItemNotFoundException(msg, (Throwable)nsise);
        }
        catch (ItemStateException ise) {
            String msg = "failed to determine degree of relationship of " + nodeId + " and " + itemId;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }
}

