/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;

public class PathMap {
    private final Element root = new Element(Path.ROOT.getNameElement());

    public Element map(Path path, boolean exact) {
        Path.PathElement[] elements = path.getElements();
        Element current = this.root;
        for (int i = 1; i < elements.length; ++i) {
            Element next = current.getChild(elements[i]);
            if (next == null) {
                if (!exact) break;
                return null;
            }
            current = next;
        }
        return current;
    }

    public Element put(Path path, Object obj) {
        Element element = this.put(path);
        element.obj = obj;
        return element;
    }

    public void put(Path path, Element element) {
        Path.PathElement[] elements = path.getElements();
        Element current = this.root;
        for (int i = 1; i < elements.length - 1; ++i) {
            Element next = current.getChild(elements[i]);
            if (next == null) {
                next = current.createChild(elements[i]);
            }
            current = next;
        }
        current.put(path.getNameElement(), element);
    }

    public Element put(Path path) {
        Path.PathElement[] elements = path.getElements();
        Element current = this.root;
        for (int i = 1; i < elements.length; ++i) {
            Element next = current.getChild(elements[i]);
            if (next == null) {
                next = current.createChild(elements[i]);
            }
            current = next;
        }
        return current;
    }

    public void traverse(ElementVisitor visitor, boolean includeEmpty) {
        this.root.traverse(visitor, includeEmpty);
    }

    public static interface ElementVisitor {
        public void elementVisited(Element var1);
    }

    public static class Element {
        private Element parent;
        private Map children;
        private int childrenCount;
        private Object obj;
        private QName name;
        private int index;

        private Element(Path.PathElement nameIndex) {
            this.name = nameIndex.getName();
            this.index = nameIndex.getIndex();
        }

        private Element createChild(Path.PathElement nameIndex) {
            Element element = new Element(nameIndex);
            this.put(nameIndex, element);
            return element;
        }

        public void insert(Path.PathElement nameIndex) {
            ArrayList list;
            int index = Element.getOneBasedIndex(nameIndex) - 1;
            if (this.children != null && (list = (ArrayList)this.children.get(nameIndex.getName())) != null && list.size() > index) {
                for (int i = index; i < list.size(); ++i) {
                    Element element = (Element)list.get(i);
                    if (element == null) continue;
                    element.index = element.getNormalizedIndex() + 1;
                }
                list.add(index, null);
            }
        }

        private Element getChild(Path.PathElement nameIndex) {
            ArrayList list;
            int index = Element.getOneBasedIndex(nameIndex) - 1;
            Element element = null;
            if (this.children != null && (list = (ArrayList)this.children.get(nameIndex.getName())) != null && list.size() > index) {
                element = (Element)list.get(index);
            }
            return element;
        }

        public void put(Path.PathElement nameIndex, Element element) {
            ArrayList<Element> list;
            int index = Element.getOneBasedIndex(nameIndex) - 1;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((list = (ArrayList<Element>)this.children.get(nameIndex.getName())) == null) {
                list = new ArrayList<Element>();
                this.children.put(nameIndex.getName(), list);
            }
            while (list.size() < index) {
                list.add(null);
            }
            if (list.size() == index) {
                list.add(element);
            } else {
                list.set(index, element);
            }
            element.parent = this;
            element.name = nameIndex.getName();
            element.index = nameIndex.getIndex();
            ++this.childrenCount;
        }

        public Element remove(Path.PathElement nameIndex) {
            return this.remove(nameIndex, true);
        }

        private Element remove(Path.PathElement nameIndex, boolean shift) {
            int index = Element.getOneBasedIndex(nameIndex) - 1;
            if (this.children == null) {
                return null;
            }
            ArrayList list = (ArrayList)this.children.get(nameIndex.getName());
            if (list == null || list.size() <= index) {
                return null;
            }
            Element element = list.set(index, null);
            if (shift) {
                for (int i = index + 1; i < list.size(); ++i) {
                    Element sibling = (Element)list.get(i);
                    if (sibling == null) continue;
                    --sibling.index;
                }
                list.remove(index);
            }
            if (element != null) {
                element.parent = null;
                --this.childrenCount;
            }
            if (this.childrenCount == 0 && this.obj == null && this.parent != null) {
                this.parent.remove(this.getPathElement(), shift);
            }
            return element;
        }

        public void remove() {
            if (this.parent != null) {
                this.parent.remove(this.getPathElement());
            }
        }

        public void removeAll() {
            this.children = null;
            this.childrenCount = 0;
            if (this.obj == null && this.parent != null) {
                this.parent.remove(this.getPathElement(), false);
            }
        }

        public Object get() {
            return this.obj;
        }

        public void set(Object obj) {
            this.obj = obj;
            if (obj == null && this.childrenCount == 0 && this.parent != null) {
                this.parent.remove(this.getPathElement(), false);
            }
        }

        public QName getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public int getNormalizedIndex() {
            if (this.index == 0) {
                return 1;
            }
            return this.index;
        }

        public Path.PathElement getPathElement() {
            return Path.create(this.name, this.index).getNameElement();
        }

        public Path getPath() throws MalformedPathException {
            if (this.parent == null) {
                return Path.ROOT;
            }
            Path.PathBuilder builder = new Path.PathBuilder();
            this.getPath(builder);
            return builder.getPath();
        }

        private void getPath(Path.PathBuilder builder) {
            if (this.parent == null) {
                builder.addRoot();
                return;
            }
            this.parent.getPath(builder);
            if (this.index == 0 || this.index == 1) {
                builder.addLast(this.name);
            } else {
                builder.addLast(this.name, this.index);
            }
        }

        public boolean hasPath(Path path) {
            return this.hasPath(path.getElements(), path.getLength());
        }

        private boolean hasPath(Path.PathElement[] elements, int len) {
            if (this.getPathElement().equals(elements[len - 1])) {
                if (this.parent != null) {
                    return this.parent.hasPath(elements, len - 1);
                }
                return true;
            }
            return false;
        }

        private static int getOneBasedIndex(Path.PathElement nameIndex) {
            int index = nameIndex.getIndex();
            if (index == 0) {
                return 1;
            }
            return index;
        }

        public void traverse(ElementVisitor visitor, boolean includeEmpty) {
            if (this.children != null) {
                Iterator iter = this.children.values().iterator();
                while (iter.hasNext()) {
                    ArrayList list = (ArrayList)iter.next();
                    for (int i = 0; i < list.size(); ++i) {
                        Element element = (Element)list.get(i);
                        if (element == null) continue;
                        element.traverse(visitor, includeEmpty);
                    }
                }
            }
            if (includeEmpty || this.obj != null) {
                visitor.elementVisited(this);
            }
        }

        public int getDepth() {
            if (this.parent != null) {
                return this.parent.getDepth() + 1;
            }
            return 0;
        }

        public boolean isAncestorOf(Element other) {
            Element parent = other.parent;
            while (parent != null) {
                if (parent == this) {
                    return true;
                }
                parent = parent.parent;
            }
            return false;
        }

        public Element getParent() {
            return this.parent;
        }

        public int getChildrenCount() {
            return this.childrenCount;
        }

        public Iterator getChildren() {
            ArrayList<Element> result = new ArrayList<Element>();
            if (this.children != null) {
                Iterator iter = this.children.values().iterator();
                while (iter.hasNext()) {
                    ArrayList list = (ArrayList)iter.next();
                    for (int i = 0; i < list.size(); ++i) {
                        Element element = (Element)list.get(i);
                        if (element == null) continue;
                        result.add(element);
                    }
                }
            }
            return result.iterator();
        }
    }
}

