/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class TestRepository {
    private static final String CONF_RESOURCE = "test-repository.xml";
    private static final String HOME_PROPERTY = "org.apache.jackrabbit.test.repository.home";
    private static final String HOME_DEFAULT = "jackrabbit-test-repository";
    private static Repository instance = null;

    public static synchronized Repository getInstance() throws RepositoryException {
        try {
            if (instance == null) {
                InputStream xml = TestRepository.class.getResourceAsStream(CONF_RESOURCE);
                String home = System.getProperty(HOME_PROPERTY, HOME_DEFAULT);
                RepositoryConfig config = RepositoryConfig.create(xml, home);
                instance = new TransientRepository(config);
            }
            return instance;
        }
        catch (ConfigurationException e) {
            throw new RepositoryException("Error in test repository configuration", (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new RepositoryException("Error in test repository initialization", (Throwable)e);
        }
    }

    public static synchronized void setInstance(Repository repository) {
        instance = repository;
    }

    private TestRepository() {
    }
}

