/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.XAItemManager;
import org.apache.jackrabbit.core.XASession;
import org.apache.jackrabbit.core.XAWorkspace;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.XALockManager;
import org.apache.jackrabbit.core.security.AuthContext;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.version.XAVersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XASessionImpl
extends SessionImpl
implements XASession,
XAResource {
    private static final Logger log = LoggerFactory.getLogger((Class)XASessionImpl.class);
    private static final Map txGlobal = Collections.synchronizedMap(new HashMap());
    private static final int DEFAULT_TX_TIMEOUT = 5;
    private TransactionContext tx;
    private int txTimeout;
    private InternalXAResource[] txResources;
    private LockManager lockMgr;

    protected XASessionImpl(RepositoryImpl rep, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(rep, loginContext, wspConfig);
        this.init();
    }

    protected XASessionImpl(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        super(rep, subject, wspConfig);
        this.init();
    }

    private void init() throws RepositoryException {
        XAItemStateManager stateMgr = (XAItemStateManager)this.wsp.getItemStateManager();
        XALockManager lockMgr = (XALockManager)this.getLockManager();
        XAVersionManager versionMgr = (XAVersionManager)this.getVersionManager();
        this.txResources = new InternalXAResource[]{((XAWorkspace)this.wsp).getXAResourceBegin(), stateMgr, lockMgr, versionMgr, ((XAWorkspace)this.wsp).getXAResourceEnd()};
        stateMgr.setVirtualProvider(versionMgr);
    }

    protected WorkspaceImpl createWorkspaceInstance(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        return new XAWorkspace(wspConfig, stateMgr, rep, session);
    }

    protected VersionManager createVersionManager(RepositoryImpl rep) throws RepositoryException {
        VersionManagerImpl vMgr = (VersionManagerImpl)rep.getVersionManager();
        return new XAVersionManager(vMgr, rep.getNodeTypeRegistry(), this);
    }

    protected ItemManager createItemManager(SessionItemStateManager itemStateMgr, HierarchyManager hierMgr) {
        return new XAItemManager(itemStateMgr, hierMgr, this, this.ntMgr.getRootNodeDefinition(), this.rep.getRootNodeId());
    }

    public LockManager getLockManager() throws RepositoryException {
        if (this.lockMgr == null) {
            LockManagerImpl lockMgr = (LockManagerImpl)this.wsp.getLockManager();
            this.lockMgr = new XALockManager(this, lockMgr);
        }
        return this.lockMgr;
    }

    public XAResource getXAResource() {
        return this;
    }

    public int getTransactionTimeout() {
        return this.txTimeout == 0 ? 5 : this.txTimeout;
    }

    public boolean setTransactionTimeout(int seconds) {
        this.txTimeout = seconds;
        return true;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XASessionImpl) {
            XASessionImpl xases = (XASessionImpl)xares;
            return XASessionImpl.stringsEqual(this.userId, xases.userId);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void start(Xid xid, int flags) throws XAException {
        void var3_3;
        TransactionContext tx;
        if (this.isAssociated()) {
            log.error("Resource already associated with a transaction.");
            throw new XAException(-6);
        }
        if (flags == 0) {
            tx = (TransactionContext)txGlobal.get(xid);
            if (tx != null) {
                throw new XAException(-8);
            }
            tx = this.createTransaction(xid);
        } else if (flags == 0x200000) {
            tx = (TransactionContext)txGlobal.get(xid);
            if (tx == null) {
                throw new XAException(-4);
            }
        } else if (flags == 0x8000000) {
            tx = (TransactionContext)txGlobal.get(xid);
            if (tx == null) {
                throw new XAException(-4);
            }
        } else {
            throw new XAException(-5);
        }
        this.associate((TransactionContext)var3_3);
    }

    private TransactionContext createTransaction(Xid xid) {
        TransactionContext tx = new TransactionContext(this.txResources, this.getTransactionTimeout());
        txGlobal.put(xid, tx);
        return tx;
    }

    public void end(Xid xid, int flags) throws XAException {
        if (!this.isAssociated()) {
            log.error("Resource not associated with a transaction.");
            throw new XAException(-6);
        }
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new XAException(-5);
        }
        this.associate(null);
    }

    public int prepare(Xid xid) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        tx.prepare();
        return 0;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        if (onePhase) {
            tx.prepare();
        }
        tx.commit();
        txGlobal.remove(xid);
    }

    public void rollback(Xid xid) throws XAException {
        TransactionContext tx = (TransactionContext)txGlobal.get(xid);
        if (tx == null) {
            throw new XAException(-4);
        }
        tx.rollback();
        txGlobal.remove(xid);
    }

    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    public void forget(Xid xid) throws XAException {
    }

    public synchronized void associate(TransactionContext tx) {
        this.tx = tx;
        for (int i = 0; i < this.txResources.length; ++i) {
            InternalXAResource txResource = this.txResources[i];
            txResource.associate(tx);
        }
    }

    private boolean isAssociated() {
        return this.tx != null;
    }

    private static boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

