/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.NoSuchWorkspaceException;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.XAItemStateManager;

public class XAWorkspace
extends WorkspaceImpl {
    protected XAWorkspace(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        super(wspConfig, stateMgr, rep, session);
    }

    protected LocalItemStateManager createItemStateManager(SharedItemStateManager shared) {
        return new XAItemStateManager(shared, this);
    }

    protected InternalXAResource getXAResourceBegin() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) throws TransactionException {
                try {
                    XAWorkspace.this.rep.getWorkspaceInfo(XAWorkspace.this.wspConfig.getName()).lockAcquire();
                }
                catch (NoSuchWorkspaceException e) {
                    throw new TransactionException("Error while preparing for transaction", e);
                }
            }

            public void commit(TransactionContext tx) {
            }

            public void rollback(TransactionContext tx) {
            }

            public void afterOperation(TransactionContext tx) {
            }
        };
    }

    protected InternalXAResource getXAResourceEnd() {
        return new InternalXAResource(){

            public void associate(TransactionContext tx) {
            }

            public void beforeOperation(TransactionContext tx) {
            }

            public void prepare(TransactionContext tx) {
            }

            public void commit(TransactionContext tx) throws TransactionException {
                try {
                    XAWorkspace.this.rep.getWorkspaceInfo(XAWorkspace.this.wspConfig.getName()).lockRelease();
                }
                catch (NoSuchWorkspaceException e) {
                    throw new TransactionException("Error while commit transaction", e);
                }
            }

            public void rollback(TransactionContext tx) throws TransactionException {
                try {
                    XAWorkspace.this.rep.getWorkspaceInfo(XAWorkspace.this.wspConfig.getName()).lockRelease();
                }
                catch (NoSuchWorkspaceException e) {
                    throw new TransactionException("Error while rollback transaction", e);
                }
            }

            public void afterOperation(TransactionContext tx) {
            }
        };
    }
}

