/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationEntityResolver;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.FileSystemConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.util.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationParser {
    public static final String REPOSITORY_HOME_VARIABLE = "rep.home";
    public static final String WORKSPACE_HOME_VARIABLE = "wsp.home";
    public static final String WORKSPACE_NAME_VARIABLE = "wsp.name";
    public static final String SECURITY_ELEMENT = "Security";
    public static final String ACCESS_MANAGER_ELEMENT = "AccessManager";
    public static final String LOGIN_MODULE_ELEMENT = "LoginModule";
    public static final String WORKSPACES_ELEMENT = "Workspaces";
    public static final String WORKSPACE_ELEMENT = "Workspace";
    public static final String VERSIONING_ELEMENT = "Versioning";
    public static final String FILE_SYSTEM_ELEMENT = "FileSystem";
    public static final String PERSISTENCE_MANAGER_ELEMENT = "PersistenceManager";
    public static final String SEARCH_INDEX_ELEMENT = "SearchIndex";
    public static final String PARAM_ELEMENT = "param";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String ROOT_PATH_ATTRIBUTE = "rootPath";
    public static final String CONFIG_ROOT_PATH_ATTRIBUTE = "configRootPath";
    public static final String MAX_IDLE_TIME_ATTRIBUTE = "maxIdleTime";
    public static final String DEFAULT_WORKSPACE_ATTRIBUTE = "defaultWorkspace";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String DEFAULT_QUERY_HANDLER = "org.apache.jackrabbit.core.query.lucene.SearchIndex";
    private final Properties variables;

    public ConfigurationParser(Properties variables) {
        this.variables = variables;
    }

    public Properties getVariables() {
        return this.variables;
    }

    public RepositoryConfig parseRepositoryConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        String home = this.variables.getProperty(REPOSITORY_HOME_VARIABLE);
        FileSystemConfig fsc = new FileSystemConfig(this.parseBeanConfig(root, FILE_SYSTEM_ELEMENT));
        Element security = this.getElement(root, SECURITY_ELEMENT);
        String appName = this.getAttribute(security, APP_NAME_ATTRIBUTE);
        AccessManagerConfig amc = new AccessManagerConfig(this.parseBeanConfig(security, ACCESS_MANAGER_ELEMENT));
        Element loginModule = this.getElement(security, LOGIN_MODULE_ELEMENT, false);
        LoginModuleConfig lmc = null;
        if (loginModule != null) {
            lmc = new LoginModuleConfig(this.parseBeanConfig(security, LOGIN_MODULE_ELEMENT));
        }
        Element workspaces = this.getElement(root, WORKSPACES_ELEMENT);
        String workspaceDirectory = this.replaceVariables(this.getAttribute(workspaces, ROOT_PATH_ATTRIBUTE));
        String workspaceConfigDirectory = this.getAttribute(workspaces, CONFIG_ROOT_PATH_ATTRIBUTE, null);
        String defaultWorkspace = this.replaceVariables(this.getAttribute(workspaces, DEFAULT_WORKSPACE_ATTRIBUTE));
        int maxIdleTime = Integer.parseInt(this.getAttribute(workspaces, MAX_IDLE_TIME_ATTRIBUTE, "0"));
        Element template = this.getElement(root, WORKSPACE_ELEMENT);
        VersioningConfig vc = this.parseVersioningConfig(root);
        SearchConfig sc = this.parseSearchConfig(root);
        return new RepositoryConfig(home, appName, amc, lmc, fsc, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, maxIdleTime, template, vc, sc, this);
    }

    public WorkspaceConfig parseWorkspaceConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        String home = this.variables.getProperty(WORKSPACE_HOME_VARIABLE);
        String name = this.getAttribute(root, NAME_ATTRIBUTE, new File(home).getName());
        Properties tmpVariables = (Properties)this.variables.clone();
        tmpVariables.put(WORKSPACE_NAME_VARIABLE, name);
        ConfigurationParser tmpParser = this.createSubParser(tmpVariables);
        FileSystemConfig fsc = new FileSystemConfig(tmpParser.parseBeanConfig(root, FILE_SYSTEM_ELEMENT));
        PersistenceManagerConfig pmc = tmpParser.parsePersistenceManagerConfig(root);
        SearchConfig sc = tmpParser.parseSearchConfig(root);
        return new WorkspaceConfig(home, name, fsc, pmc, sc);
    }

    protected SearchConfig parseSearchConfig(Element parent) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !SEARCH_INDEX_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String className = this.getAttribute(element, CLASS_ATTRIBUTE, DEFAULT_QUERY_HANDLER);
            Properties parameters = this.parseParameters(element);
            FileSystemConfig fsc = null;
            if (this.getElement(element, FILE_SYSTEM_ELEMENT, false) != null) {
                fsc = new FileSystemConfig(this.parseBeanConfig(element, FILE_SYSTEM_ELEMENT));
            }
            return new SearchConfig(className, parameters, fsc);
        }
        return null;
    }

    protected VersioningConfig parseVersioningConfig(Element parent) throws ConfigurationException {
        Element element = this.getElement(parent, VERSIONING_ELEMENT);
        String home = this.replaceVariables(this.getAttribute(element, ROOT_PATH_ATTRIBUTE));
        FileSystemConfig fsc = new FileSystemConfig(this.parseBeanConfig(element, FILE_SYSTEM_ELEMENT));
        PersistenceManagerConfig pmc = this.parsePersistenceManagerConfig(element);
        return new VersioningConfig(home, fsc, pmc);
    }

    protected PersistenceManagerConfig parsePersistenceManagerConfig(Element parent) throws ConfigurationException {
        return new PersistenceManagerConfig(this.parseBeanConfig(parent, PERSISTENCE_MANAGER_ELEMENT));
    }

    protected BeanConfig parseBeanConfig(Element parent, String name) throws ConfigurationException {
        Element element = this.getElement(parent, name);
        String className = this.getAttribute(element, CLASS_ATTRIBUTE);
        Properties properties = this.parseParameters(element);
        return new BeanConfig(className, properties);
    }

    protected Properties parseParameters(Element element) throws ConfigurationException {
        Properties parameters = new Properties();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !PARAM_ELEMENT.equals(child.getNodeName())) continue;
            Element parameter = (Element)child;
            Attr name = parameter.getAttributeNode(NAME_ATTRIBUTE);
            if (name == null) {
                throw new ConfigurationException("Parameter name not set");
            }
            Attr value = parameter.getAttributeNode(VALUE_ATTRIBUTE);
            if (value == null) {
                throw new ConfigurationException("Parameter value not set");
            }
            parameters.put(name.getValue(), this.replaceVariables(value.getValue()));
        }
        return parameters;
    }

    protected String replaceVariables(String value) throws ConfigurationException {
        try {
            return Text.replaceVariables(this.variables, value, false);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    protected Element parseXML(InputSource xml) throws ConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ConfigurationEntityResolver());
            Document document = builder.parse(xml);
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Configuration file syntax error.", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration file could not be read.", e);
        }
    }

    protected Element getElement(Element parent, String name) throws ConfigurationException {
        return this.getElement(parent, name, true);
    }

    protected Element getElement(Element parent, String name, boolean required) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        if (required) {
            throw new ConfigurationException("Configuration element " + name + " not found in " + parent.getNodeName() + ".");
        }
        return null;
    }

    protected String getAttribute(Element element, String name) throws ConfigurationException {
        Attr attribute = element.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new ConfigurationException("Configuration attribute " + name + " not found in " + element.getNodeName() + ".");
    }

    protected String getAttribute(Element element, String name, String def) {
        Attr attribute = element.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return def;
    }

    protected ConfigurationParser createSubParser(Properties variables) {
        Properties props = new Properties(this.variables);
        props.putAll((Map<?, ?>)variables);
        return new ConfigurationParser(props);
    }
}

