/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;

public class FileSystemConfig
extends BeanConfig {
    private FileSystem fs = null;

    public FileSystemConfig(BeanConfig config) {
        super(config);
    }

    public void init() throws ConfigurationException, IllegalStateException {
        if (this.fs == null) {
            try {
                this.fs = (FileSystem)this.newInstance();
                this.fs.init();
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Invalid file system implementation class " + this.getClassName() + ".", e);
            }
            catch (FileSystemException e) {
                throw new ConfigurationException("File system initialization failure.", e);
            }
        } else {
            throw new IllegalStateException("File system has already been initialized.");
        }
    }

    public void dispose() {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        } else {
            throw new IllegalStateException("File system has not been initialized.");
        }
        this.fs = null;
    }

    public FileSystem getFileSystem() throws IllegalStateException {
        if (this.fs != null) {
            return this.fs;
        }
        throw new IllegalStateException("File system has not been initialized.");
    }
}

