/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.sql.DriverManager;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2FileSystem
extends DbFileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)DB2FileSystem.class);

    public DB2FileSystem() {
        this.schema = "db2";
        this.driver = "com.ibm.db2.jcc.DB2Driver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.user, this.password);
            this.con.setAutoCommit(true);
            this.prepareSchemaObjectPrefix();
            this.checkSchema();
            this.insertFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)");
            this.insertFolderStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, 0)");
            this.updateDataStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null");
            this.updateLastModifiedStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null");
            this.selectExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?");
            this.selectFileExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.selectFolderExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is null");
            this.selectFileNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null");
            this.selectFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is null");
            this.selectFileAndFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?");
            this.selectChildCountStmt = this.con.prepareStatement("select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  ");
            this.selectDataStmt = this.con.prepareStatement("select FSENTRY_DATA from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.selectLastModifiedStmt = this.con.prepareStatement("select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?");
            this.selectLengthStmt = this.con.prepareStatement("select FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.deleteFileStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.deleteFolderStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ");
            this.copyFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select cast(? as varchar(745)), cast(? as varchar(255)), FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.copyFilesStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select cast(? as varchar(745)), FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null");
            this.verifyRoodExists();
            this.initialized = true;
        }
        catch (Exception e) {
            String msg = "failed to initialize file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }
}

