/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbFileSystem
implements FileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)DbFileSystem.class);
    protected static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    protected boolean initialized = false;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String schema = "default";
    protected String schemaObjectPrefix = "";
    protected static final int INITIAL_BUFFER_SIZE = 8192;
    protected Connection con;
    protected PreparedStatement selectExistStmt;
    protected PreparedStatement selectFileExistStmt;
    protected PreparedStatement selectFolderExistStmt;
    protected PreparedStatement selectChildCountStmt;
    protected PreparedStatement selectDataStmt;
    protected PreparedStatement selectLastModifiedStmt;
    protected PreparedStatement selectLengthStmt;
    protected PreparedStatement selectFileNamesStmt;
    protected PreparedStatement selectFolderNamesStmt;
    protected PreparedStatement selectFileAndFolderNamesStmt;
    protected PreparedStatement deleteFileStmt;
    protected PreparedStatement deleteFolderStmt;
    protected PreparedStatement insertFileStmt;
    protected PreparedStatement insertFolderStmt;
    protected PreparedStatement updateDataStmt;
    protected PreparedStatement updateLastModifiedStmt;
    protected PreparedStatement copyFileStmt;
    protected PreparedStatement copyFilesStmt;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DbFileSystem) {
            DbFileSystem other = (DbFileSystem)obj;
            if ((this.driver != null ? this.driver.equals(other.driver) : other.driver == null) && (this.url != null ? this.url.equals(other.url) : other.url == null) && (this.user != null ? this.user.equals(other.user) : other.user == null) && (this.password != null ? this.password.equals(other.password) : other.password == null) && (this.schema != null ? this.schema.equals(other.schema) : other.schema == null) && (this.schemaObjectPrefix != null ? this.schemaObjectPrefix.equals(other.schemaObjectPrefix) : other.schemaObjectPrefix == null)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.user, this.password);
            this.con.setAutoCommit(true);
            this.prepareSchemaObjectPrefix();
            this.checkSchema();
            this.insertFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)");
            this.insertFolderStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, 0)");
            this.updateDataStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null");
            this.updateLastModifiedStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is not null");
            this.selectExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?");
            this.selectFileExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.selectFolderExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is null");
            this.selectFileNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null");
            this.selectFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is null");
            this.selectFileAndFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?");
            this.selectChildCountStmt = this.con.prepareStatement("select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  ");
            this.selectDataStmt = this.con.prepareStatement("select FSENTRY_DATA from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.selectLastModifiedStmt = this.con.prepareStatement("select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?");
            this.selectLengthStmt = this.con.prepareStatement("select FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.deleteFileStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.deleteFolderStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ");
            this.copyFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, ?, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
            this.copyFilesStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_DATA is not null");
            this.verifyRoodExists();
            this.initialized = true;
        }
        catch (Exception e) {
            String msg = "failed to initialize file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    public void close() throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.closeStatement(this.insertFileStmt);
            this.closeStatement(this.insertFolderStmt);
            this.closeStatement(this.updateDataStmt);
            this.closeStatement(this.updateLastModifiedStmt);
            this.closeStatement(this.selectExistStmt);
            this.closeStatement(this.selectFileExistStmt);
            this.closeStatement(this.selectFolderExistStmt);
            this.closeStatement(this.selectFileNamesStmt);
            this.closeStatement(this.selectFolderNamesStmt);
            this.closeStatement(this.selectFileAndFolderNamesStmt);
            this.closeStatement(this.selectChildCountStmt);
            this.closeStatement(this.selectDataStmt);
            this.closeStatement(this.selectLastModifiedStmt);
            this.closeStatement(this.selectLengthStmt);
            this.closeStatement(this.deleteFolderStmt);
            this.closeStatement(this.deleteFileStmt);
            this.closeStatement(this.copyFileStmt);
            this.closeStatement(this.copyFilesStmt);
            this.con.close();
        }
        catch (SQLException e) {
            String msg = "error closing file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
        finally {
            this.initialized = false;
        }
    }

    public void createFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (this.exists(folderPath)) {
            throw new FileSystemException("file system entry already exists: " + folderPath);
        }
        this.createDeepFolder(folderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String filePath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        int count = 0;
        PreparedStatement preparedStatement = stmt = this.deleteFileStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                count = stmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "failed to delete file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFolder(String folderPath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (folderPath.equals("/")) {
            throw new FileSystemException("cannot delete root");
        }
        String parentDir = FileSystemPathUtil.getParentDir(folderPath);
        String name = FileSystemPathUtil.getName(folderPath);
        int count = 0;
        PreparedStatement preparedStatement = stmt = this.deleteFolderStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.setString(3, folderPath);
                stmt.setString(4, folderPath + "/" + "%");
                count = stmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "failed to delete folder: " + folderPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
    }

    public boolean exists(String path) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        PreparedStatement preparedStatement = stmt = this.selectExistStmt;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs = null;
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.execute();
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of file system entry: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean isFile(String path) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        PreparedStatement preparedStatement = stmt = this.selectFileExistStmt;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs = null;
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.execute();
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of file: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean isFolder(String path) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        PreparedStatement preparedStatement = stmt = this.selectFolderExistStmt;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs = null;
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.execute();
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of folder: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public long lastModified(String path) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        PreparedStatement preparedStatement = stmt = this.selectLastModifiedStmt;
        synchronized (preparedStatement) {
            long l;
            ResultSet rs = null;
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.execute();
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new FileSystemException("no such file system entry: " + path);
                }
                l = rs.getLong(1);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine lastModified of file system entry: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return l;
        }
    }

    public long length(String filePath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        PreparedStatement preparedStatement = stmt = this.selectLengthStmt;
        synchronized (preparedStatement) {
            long l;
            ResultSet rs = null;
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.execute();
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                l = rs.getLong(1);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine length of file: " + filePath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(String path) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        if (!this.exists(path)) {
            throw new FileSystemException("no such file system entry: " + path);
        }
        PreparedStatement preparedStatement = stmt = this.selectChildCountStmt;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs;
            block10: {
                rs = null;
                stmt.setString(1, path);
                stmt.execute();
                rs = stmt.getResultSet();
                if (rs.next()) break block10;
                boolean bl2 = false;
                this.closeResultSet(rs);
                this.resetStatement(stmt);
                return bl2;
            }
            try {
                int count = rs.getInt(1);
                if (FileSystemPathUtil.denotesRoot(path)) {
                    --count;
                }
                bl = count > 0;
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine child count of file system entry: " + path;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public String[] list(String folderPath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        PreparedStatement preparedStatement = stmt = this.selectFileAndFolderNamesStmt;
        synchronized (preparedStatement) {
            String[] name;
            ResultSet rs = null;
            try {
                stmt.setString(1, folderPath);
                stmt.execute();
                rs = stmt.getResultSet();
                ArrayList<String[]> names = new ArrayList<String[]>();
                while (rs.next()) {
                    name = rs.getString(1);
                    if (name.length() == 0 && FileSystemPathUtil.denotesRoot(folderPath)) continue;
                    names.add(name);
                }
                name = names.toArray(new String[names.size()]);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list child entries of folder: " + folderPath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return name;
        }
    }

    public String[] listFiles(String folderPath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        PreparedStatement preparedStatement = stmt = this.selectFileNamesStmt;
        synchronized (preparedStatement) {
            String[] stringArray;
            ResultSet rs = null;
            try {
                stmt.setString(1, folderPath);
                stmt.execute();
                rs = stmt.getResultSet();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                stringArray = names.toArray(new String[names.size()]);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list file entries of folder: " + folderPath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return stringArray;
        }
    }

    public String[] listFolders(String folderPath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        PreparedStatement preparedStatement = stmt = this.selectFolderNamesStmt;
        synchronized (preparedStatement) {
            String[] name;
            ResultSet rs = null;
            try {
                stmt.setString(1, folderPath);
                stmt.execute();
                rs = stmt.getResultSet();
                ArrayList<String[]> names = new ArrayList<String[]>();
                while (rs.next()) {
                    name = rs.getString(1);
                    if (name.length() == 0 && FileSystemPathUtil.denotesRoot(folderPath)) continue;
                    names.add(name);
                }
                name = names.toArray(new String[names.size()]);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list folder entries of folder: " + folderPath;
                    log.error(msg, (Throwable)e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(String filePath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        int count = 0;
        PreparedStatement preparedStatement = stmt = this.updateLastModifiedStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setLong(1, System.currentTimeMillis());
                stmt.setString(2, parentDir);
                stmt.setString(3, name);
                count = stmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "failed to touch file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + filePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream(String filePath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        PreparedStatement preparedStatement = stmt = this.selectDataStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.execute();
                final ResultSet rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                InputStream in = rs.getBinaryStream(1);
                FilterInputStream filterInputStream = new FilterInputStream(in){

                    public void close() throws IOException {
                        super.close();
                        DbFileSystem.this.closeResultSet(rs);
                    }
                };
                return filterInputStream;
            }
            catch (SQLException e) {
                String msg = "failed to retrieve data of file: " + filePath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
    }

    public OutputStream getOutputStream(final String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            return new FilterOutputStream(new FileOutputStream(tmpFile)){
                File f;
                {
                    super(x0);
                    this.f = tmpFile;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void close() throws IOException {
                    block13: {
                        super.close();
                        PreparedStatement stmt = null;
                        InputStream in = null;
                        try {
                            try {
                                if (DbFileSystem.this.isFile(filePath)) {
                                    PreparedStatement preparedStatement = stmt = DbFileSystem.this.updateDataStmt;
                                    synchronized (preparedStatement) {
                                        long length = this.f.length();
                                        in = new FileInputStream(this.f);
                                        stmt.setBinaryStream(1, in, (int)length);
                                        stmt.setLong(2, System.currentTimeMillis());
                                        stmt.setLong(3, length);
                                        stmt.setString(4, parentDir);
                                        stmt.setString(5, name);
                                        stmt.executeUpdate();
                                    }
                                } else {
                                    stmt = DbFileSystem.this.insertFileStmt;
                                    stmt.setString(1, parentDir);
                                    stmt.setString(2, name);
                                    long length = this.f.length();
                                    in = new FileInputStream(this.f);
                                    stmt.setBinaryStream(3, in, (int)length);
                                    stmt.setLong(4, System.currentTimeMillis());
                                    stmt.setLong(5, length);
                                    stmt.executeUpdate();
                                }
                            }
                            catch (Exception e) {
                                throw new IOException(e.getMessage());
                            }
                            Object var8_7 = null;
                            if (stmt != null) {
                                DbFileSystem.this.resetStatement(stmt);
                            }
                            if (in == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (stmt != null) {
                                DbFileSystem.this.resetStatement(stmt);
                            }
                            if (in != null) {
                                in.close();
                            }
                            this.f.delete();
                            this.f = null;
                            throw throwable;
                        }
                        in.close();
                    }
                    this.f.delete();
                    this.f = null;
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output strean to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessOutputStream getRandomAccessOutputStream(final String filePath) throws FileSystemException, UnsupportedOperationException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            if (this.isFile(filePath)) {
                InputStream in = this.getInputStream(filePath);
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    int read;
                    byte[] ba = new byte[8192];
                    while ((read = in.read(ba, 0, ba.length)) != -1) {
                        ((OutputStream)out).write(ba, 0, read);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                    in.close();
                }
            }
            return new RandomAccessOutputStream(){
                File f;
                RandomAccessFile raf;
                {
                    this.f = tmpFile;
                    this.raf = new RandomAccessFile(this.f, "rw");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void close() throws IOException {
                    block13: {
                        this.raf.close();
                        PreparedStatement stmt = null;
                        InputStream in = null;
                        try {
                            try {
                                if (DbFileSystem.this.isFile(filePath)) {
                                    PreparedStatement preparedStatement = stmt = DbFileSystem.this.updateDataStmt;
                                    synchronized (preparedStatement) {
                                        long length = this.f.length();
                                        in = new FileInputStream(this.f);
                                        stmt.setBinaryStream(1, in, (int)length);
                                        stmt.setLong(2, System.currentTimeMillis());
                                        stmt.setLong(3, length);
                                        stmt.setString(4, parentDir);
                                        stmt.setString(5, name);
                                        stmt.executeUpdate();
                                    }
                                } else {
                                    stmt = DbFileSystem.this.insertFileStmt;
                                    stmt.setString(1, parentDir);
                                    stmt.setString(2, name);
                                    long length = this.f.length();
                                    in = new FileInputStream(this.f);
                                    stmt.setBinaryStream(3, in, (int)length);
                                    stmt.setLong(4, System.currentTimeMillis());
                                    stmt.setLong(5, length);
                                    stmt.executeUpdate();
                                }
                            }
                            catch (Exception e) {
                                throw new IOException(e.getMessage());
                            }
                            Object var8_7 = null;
                            if (stmt != null) {
                                DbFileSystem.this.resetStatement(stmt);
                            }
                            if (in == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (stmt != null) {
                                DbFileSystem.this.resetStatement(stmt);
                            }
                            if (in != null) {
                                in.close();
                            }
                            this.f.delete();
                            this.f = null;
                            this.raf = null;
                            throw throwable;
                        }
                        in.close();
                    }
                    this.f.delete();
                    this.f = null;
                    this.raf = null;
                }

                public void seek(long position) throws IOException {
                    this.raf.seek(position);
                }

                public void write(int b) throws IOException {
                    this.raf.write(b);
                }

                public void flush() {
                }

                public void write(byte[] b) throws IOException {
                    this.raf.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.raf.write(b, off, len);
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output strean to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    public void copy(String srcPath, String destPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(srcPath);
        FileSystemPathUtil.checkFormat(destPath);
        if (this.isFolder(srcPath)) {
            this.copyDeepFolder(srcPath, destPath);
        } else {
            this.copyFile(srcPath, destPath);
        }
    }

    public void move(String srcPath, String destPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(srcPath);
        FileSystemPathUtil.checkFormat(destPath);
        this.copy(srcPath, destPath);
        if (this.isFile(srcPath)) {
            this.deleteFile(srcPath);
        } else {
            this.deleteFolder(srcPath);
        }
    }

    protected void prepareSchemaObjectPrefix() throws Exception {
        DatabaseMetaData metaData = this.con.getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append("_x");
                String hex = Integer.toHexString(c);
                escaped.append("0000".toCharArray(), 0, 4 - hex.length());
                escaped.append(hex);
                escaped.append("_");
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws Exception {
        boolean schemaExists;
        DatabaseMetaData metaData = this.con.getMetaData();
        String tableName = this.schemaObjectPrefix + "FSENTRY";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        ResultSet rs = metaData.getTables(null, null, tableName, null);
        try {
            schemaExists = rs.next();
        }
        finally {
            rs.close();
        }
        if (!schemaExists) {
            InputStream in = this.getClass().getResourceAsStream(this.schema + ".ddl");
            if (in == null) {
                String msg = "Configuration error: unknown schema '" + this.schema + "'";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.con.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    sql = Text.replace(sql, SCHEMA_OBJECT_PREFIX_VARIABLE, this.schemaObjectPrefix);
                    stmt.executeUpdate(sql);
                    sql = reader.readLine();
                }
            }
            finally {
                this.closeStream(in);
                this.closeStatement(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyRoodExists() throws Exception {
        PreparedStatement stmt;
        PreparedStatement preparedStatement = stmt = this.selectFolderExistStmt;
        synchronized (preparedStatement) {
            ResultSet rs;
            block7: {
                rs = null;
                try {
                    stmt.setString(1, "/");
                    stmt.setString(2, "");
                    stmt.execute();
                    rs = stmt.getResultSet();
                    if (!rs.next()) break block7;
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                }
                catch (SQLException e) {
                    try {
                        String msg = "failed to check existence of file system root entry";
                        log.error(msg, (Throwable)e);
                        throw new FileSystemException(msg, e);
                    }
                    catch (Throwable throwable) {
                        this.closeResultSet(rs);
                        this.resetStatement(stmt);
                        throw throwable;
                    }
                }
                return;
            }
            this.closeResultSet(rs);
            this.resetStatement(stmt);
        }
        this.createDeepFolder("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDeepFolder(String folderPath) throws FileSystemException {
        PreparedStatement stmt;
        String parentDir = FileSystemPathUtil.getParentDir(folderPath);
        String name = FileSystemPathUtil.getName(folderPath);
        if (!FileSystemPathUtil.denotesRoot(folderPath) && !this.exists(parentDir)) {
            this.createDeepFolder(parentDir);
        }
        PreparedStatement preparedStatement = stmt = this.insertFolderStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setString(1, parentDir);
                stmt.setString(2, name);
                stmt.setLong(3, System.currentTimeMillis());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "failed to create folder entry: " + folderPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDeepFolder(String srcPath, String destPath) throws FileSystemException {
        PreparedStatement stmt;
        if (!this.exists(destPath)) {
            this.createDeepFolder(destPath);
        }
        String[] names = this.listFolders(srcPath);
        for (int i = 0; i < names.length; ++i) {
            String src = FileSystemPathUtil.denotesRoot(srcPath) ? srcPath + names[i] : srcPath + "/" + names[i];
            String dest = FileSystemPathUtil.denotesRoot(destPath) ? destPath + names[i] : destPath + "/" + names[i];
            this.copyDeepFolder(src, dest);
        }
        PreparedStatement preparedStatement = stmt = this.copyFilesStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setString(1, destPath);
                stmt.setString(2, srcPath);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "failed to copy file entries from " + srcPath + " to " + destPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String srcPath, String destPath) throws FileSystemException {
        PreparedStatement stmt;
        String srcParentDir = FileSystemPathUtil.getParentDir(srcPath);
        String srcName = FileSystemPathUtil.getName(srcPath);
        String destParentDir = FileSystemPathUtil.getParentDir(destPath);
        String destName = FileSystemPathUtil.getName(destPath);
        if (!this.exists(destParentDir)) {
            this.createDeepFolder(destParentDir);
        }
        if (this.isFile(destPath)) {
            this.deleteFile(destPath);
        }
        int count = 0;
        PreparedStatement preparedStatement = stmt = this.copyFileStmt;
        synchronized (preparedStatement) {
            try {
                stmt.setString(1, destParentDir);
                stmt.setString(2, destName);
                stmt.setString(3, srcParentDir);
                stmt.setString(4, srcName);
                count = stmt.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "failed to copy file from " + srcPath + " to " + destPath;
                log.error(msg, (Throwable)e);
                throw new FileSystemException(msg, e);
            }
            finally {
                this.resetStatement(stmt);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + srcPath);
        }
    }

    protected void resetStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.clearParameters();
                stmt.clearWarnings();
            }
            catch (SQLException se) {
                log.error("failed resetting PreparedStatement", (Throwable)se);
            }
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.error("failed closing ResultSet", (Throwable)se);
            }
        }
    }

    protected void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.error("failed closing Statement", (Throwable)se);
            }
        }
    }
}

