/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyFileSystem
extends DbFileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)DerbyFileSystem.class);

    public DerbyFileSystem() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public void close() throws FileSystemException {
        String url;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            url = this.con.getMetaData().getURL();
        }
        catch (SQLException e) {
            String msg = "error closing file system";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
        int pos = url.lastIndexOf(59);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        url = url + ";shutdown=true";
        super.close();
        try {
            DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            log.info(e.getMessage());
        }
    }
}

