/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.name.QName;

class EffectiveNodeTypeCache
implements Cloneable,
Dumpable {
    final TreeSet sortedKeys = new TreeSet();
    final HashMap aggregates = new HashMap();

    EffectiveNodeTypeCache() {
    }

    void put(EffectiveNodeType ent) {
        int weight = ent.getAllNodeTypes().length;
        WeightedKey k = new WeightedKey(ent.getMergedNodeTypes(), weight);
        this.aggregates.put(k, ent);
        this.sortedKeys.add(k);
    }

    boolean contains(QName[] ntNames) {
        return this.aggregates.containsKey(new WeightedKey(ntNames));
    }

    boolean contains(WeightedKey key) {
        return this.aggregates.containsKey(key);
    }

    EffectiveNodeType get(QName[] ntNames) {
        return (EffectiveNodeType)this.aggregates.get(new WeightedKey(ntNames));
    }

    EffectiveNodeType get(WeightedKey key) {
        return (EffectiveNodeType)this.aggregates.get(key);
    }

    EffectiveNodeType remove(QName[] ntNames) {
        return this.remove(new WeightedKey(ntNames));
    }

    EffectiveNodeType remove(WeightedKey key) {
        EffectiveNodeType removed = (EffectiveNodeType)this.aggregates.remove(key);
        if (removed != null) {
            Iterator iter = this.sortedKeys.iterator();
            while (iter.hasNext()) {
                WeightedKey k = (WeightedKey)iter.next();
                if (!key.equals(k)) continue;
                this.sortedKeys.remove(k);
                break;
            }
        }
        return removed;
    }

    Iterator keyIterator() {
        return this.sortedKeys.iterator();
    }

    Set keySet() {
        return Collections.unmodifiableSet(this.sortedKeys);
    }

    public Object clone() {
        EffectiveNodeTypeCache clone = new EffectiveNodeTypeCache();
        clone.sortedKeys.addAll(this.sortedKeys);
        clone.aggregates.putAll(this.aggregates);
        return clone;
    }

    public void dump(PrintStream ps) {
        ps.println("EffectiveNodeTypeCache (" + this + ")");
        ps.println();
        ps.println("EffectiveNodeTypes in cache:");
        ps.println();
        Iterator iter = this.sortedKeys.iterator();
        while (iter.hasNext()) {
            WeightedKey k = (WeightedKey)iter.next();
            ps.println(k);
        }
    }

    static class WeightedKey
    implements Comparable {
        private final QName[] names;
        private final int weight;

        WeightedKey(QName[] ntNames) {
            this(ntNames, ntNames.length);
        }

        WeightedKey(QName[] ntNames, int weight) {
            this.weight = weight;
            this.names = new QName[ntNames.length];
            System.arraycopy(ntNames, 0, this.names, 0, this.names.length);
            Arrays.sort(this.names);
        }

        WeightedKey(Collection ntNames) {
            this(ntNames, ntNames.size());
        }

        WeightedKey(Collection ntNames, int weight) {
            this(ntNames.toArray(new QName[ntNames.size()]), weight);
        }

        int getWeight() {
            return this.weight;
        }

        QName[] getNames() {
            return this.names;
        }

        boolean contains(WeightedKey otherKey) {
            HashSet<QName> tmp = new HashSet<QName>(Arrays.asList(this.names));
            for (int i = 0; i < otherKey.names.length; ++i) {
                if (tmp.contains(otherKey.names[i])) continue;
                return false;
            }
            return true;
        }

        WeightedKey subtract(WeightedKey otherKey) {
            HashSet<QName> tmp = new HashSet<QName>(Arrays.asList(this.names));
            tmp.removeAll(Arrays.asList(otherKey.names));
            return new WeightedKey(tmp);
        }

        public int compareTo(Object o) {
            WeightedKey other = (WeightedKey)o;
            if (this.weight > other.weight) {
                return -1;
            }
            if (this.weight < other.weight) {
                return 1;
            }
            int len1 = this.names.length;
            int len2 = other.names.length;
            int len = Math.min(len1, len2);
            for (int i = 0; i < len; ++i) {
                QName name1 = this.names[i];
                QName name2 = other.names[i];
                int result = name1.compareTo(name2);
                if (result == 0) continue;
                return result;
            }
            return len1 - len2;
        }

        public int hashCode() {
            int h = 17;
            for (int i = 0; i < this.names.length; ++i) {
                h *= 37;
                h += this.names[i].hashCode();
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeightedKey) {
                WeightedKey other = (WeightedKey)obj;
                return Arrays.equals(this.names, other.names);
            }
            return false;
        }

        public String toString() {
            return Arrays.asList(this.names).toString() + " (" + this.weight + ")";
        }
    }
}

