/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;

class NameConstraint
extends ValueConstraint {
    final QName name;

    NameConstraint(String definition, NamespaceResolver nsResolver) throws InvalidConstraintException {
        super(definition);
        try {
            QName.checkFormat(definition);
            this.name = QName.fromJCRName(definition, nsResolver);
        }
        catch (IllegalNameException ine) {
            String msg = "invalid name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, ine);
        }
        catch (UnknownPrefixException upe) {
            String msg = "invalid name specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, upe);
        }
    }

    public String getDefinition(NamespaceResolver nsResolver) {
        try {
            return this.name.toJCRName(nsResolver);
        }
        catch (NoPrefixDeclaredException npde) {
            return this.definition;
        }
    }

    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 7: {
                QName n = (QName)value.internalValue();
                if (!this.name.equals(n)) {
                    throw new ConstraintViolationException(n + " does not satisfy the constraint '" + this.definition + "'");
                }
                return;
            }
        }
        String msg = "NAME constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

