/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.Serializable;
import java.util.TreeSet;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.name.QName;

public class NodeDefId
implements Serializable {
    static final long serialVersionUID = 7020286139887664713L;
    private final int id;

    NodeDefId(NodeDef def) {
        if (def == null) {
            throw new IllegalArgumentException("NodeDef argument can not be null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(def.getDeclaringNodeType().toString());
        sb.append('/');
        if (def.definesResidual()) {
            sb.append('*');
        } else {
            sb.append(def.getName().toString());
        }
        sb.append('/');
        TreeSet<QName> set = new TreeSet<QName>();
        QName[] names = def.getRequiredPrimaryTypes();
        for (int i = 0; i < names.length; ++i) {
            set.add(names[i]);
        }
        sb.append(set.toString());
        this.id = sb.toString().hashCode();
    }

    private NodeDefId(int id) {
        this.id = id;
    }

    public static NodeDefId valueOf(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("invalid NodeDefId literal");
        }
        return new NodeDefId(Integer.parseInt(s));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeDefId) {
            NodeDefId other = (NodeDefId)obj;
            return this.id == other.id;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int hashCode() {
        return this.id;
    }
}

