/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.util.DOMWalker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;

public class NodeTypeReader {
    private final DOMWalker walker;
    private final Properties namespaces;
    private final NamespaceResolver resolver;

    public static NodeTypeDef[] read(InputStream xml) throws IOException, InvalidNodeTypeDefException {
        try {
            NodeTypeReader reader = new NodeTypeReader(xml);
            return reader.getNodeTypeDefs();
        }
        catch (IllegalNameException e) {
            throw new InvalidNodeTypeDefException("Invalid namespace reference in a node type definition", e);
        }
        catch (UnknownPrefixException e) {
            throw new InvalidNodeTypeDefException("Invalid namespace reference in a node type definition", e);
        }
    }

    public NodeTypeReader(InputStream xml) throws IOException {
        this.walker = new DOMWalker(xml);
        this.namespaces = this.walker.getNamespaces();
        this.resolver = new AdditionalNamespaceResolver(this.namespaces);
    }

    public Properties getNamespaces() {
        return this.namespaces;
    }

    public NodeTypeDef[] getNodeTypeDefs() throws InvalidNodeTypeDefException, IllegalNameException, UnknownPrefixException {
        Vector<NodeTypeDef> defs = new Vector<NodeTypeDef>();
        while (this.walker.iterateElements("nodeType")) {
            defs.add(this.getNodeTypeDef());
        }
        return defs.toArray(new NodeTypeDef[defs.size()]);
    }

    private NodeTypeDef getNodeTypeDef() throws InvalidNodeTypeDefException, IllegalNameException, UnknownPrefixException {
        NodeTypeDef type = new NodeTypeDef();
        type.setName(QName.fromJCRName(this.walker.getAttribute("name"), this.resolver));
        type.setMixin(Boolean.valueOf(this.walker.getAttribute("isMixin")));
        type.setOrderableChildNodes(Boolean.valueOf(this.walker.getAttribute("hasOrderableChildNodes")));
        String primaryItemName = this.walker.getAttribute("primaryItemName");
        if (primaryItemName != null && primaryItemName.length() > 0) {
            type.setPrimaryItemName(QName.fromJCRName(primaryItemName, this.resolver));
        }
        if (this.walker.enterElement("supertypes")) {
            Vector<QName> supertypes = new Vector<QName>();
            while (this.walker.iterateElements("supertype")) {
                supertypes.add(QName.fromJCRName(this.walker.getContent(), this.resolver));
            }
            type.setSupertypes(supertypes.toArray(new QName[supertypes.size()]));
            this.walker.leaveElement();
        }
        Vector<PropDefImpl> properties = new Vector<PropDefImpl>();
        while (this.walker.iterateElements("propertyDefinition")) {
            PropDefImpl def = this.getPropDef();
            def.setDeclaringNodeType(type.getName());
            properties.add(def);
        }
        type.setPropertyDefs(properties.toArray(new PropDef[properties.size()]));
        Vector<NodeDefImpl> nodes = new Vector<NodeDefImpl>();
        while (this.walker.iterateElements("childNodeDefinition")) {
            NodeDefImpl def = this.getChildNodeDef();
            def.setDeclaringNodeType(type.getName());
            nodes.add(def);
        }
        type.setChildNodeDefs(nodes.toArray(new NodeDef[nodes.size()]));
        return type;
    }

    private PropDefImpl getPropDef() throws InvalidNodeTypeDefException, IllegalNameException, UnknownPrefixException {
        int type;
        PropDefImpl def = new PropDefImpl();
        String name = this.walker.getAttribute("name");
        if (name.equals("*")) {
            def.setName(ItemDef.ANY_NAME);
        } else {
            def.setName(QName.fromJCRName(name, this.resolver));
        }
        def.setAutoCreated(Boolean.valueOf(this.walker.getAttribute("autoCreated")));
        def.setMandatory(Boolean.valueOf(this.walker.getAttribute("mandatory")));
        def.setProtected(Boolean.valueOf(this.walker.getAttribute("protected")));
        def.setOnParentVersion(OnParentVersionAction.valueFromName((String)this.walker.getAttribute("onParentVersion")));
        def.setMultiple(Boolean.valueOf(this.walker.getAttribute("multiple")));
        def.setRequiredType(PropertyType.valueFromName((String)this.walker.getAttribute("requiredType")));
        if (this.walker.enterElement("valueConstraints")) {
            Vector<ValueConstraint> constraints = new Vector<ValueConstraint>();
            type = def.getRequiredType();
            while (this.walker.iterateElements("valueConstraint")) {
                String constraint = this.walker.getContent();
                try {
                    constraints.add(ValueConstraint.create(type, constraint.trim(), this.resolver));
                }
                catch (InvalidConstraintException e) {
                    throw new InvalidNodeTypeDefException("Invalid value constraint " + constraint, e);
                }
            }
            def.setValueConstraints(constraints.toArray(new ValueConstraint[constraints.size()]));
            this.walker.leaveElement();
        }
        if (this.walker.enterElement("defaultValues")) {
            Vector<InternalValue> values = new Vector<InternalValue>();
            type = def.getRequiredType();
            if (type == 0) {
                type = 1;
            }
            while (this.walker.iterateElements("defaultValue")) {
                String value = this.walker.getContent();
                try {
                    values.add(InternalValue.create(value, type, this.resolver));
                }
                catch (RepositoryException e) {
                    throw new InvalidNodeTypeDefException("Unable to create default value: " + value, e);
                }
            }
            def.setDefaultValues(values.toArray(new InternalValue[values.size()]));
            this.walker.leaveElement();
        }
        return def;
    }

    private NodeDefImpl getChildNodeDef() throws IllegalNameException, UnknownPrefixException {
        NodeDefImpl def = new NodeDefImpl();
        String name = this.walker.getAttribute("name");
        if (name.equals("*")) {
            def.setName(ItemDef.ANY_NAME);
        } else {
            def.setName(QName.fromJCRName(name, this.resolver));
        }
        def.setAutoCreated(Boolean.valueOf(this.walker.getAttribute("autoCreated")));
        def.setMandatory(Boolean.valueOf(this.walker.getAttribute("mandatory")));
        def.setProtected(Boolean.valueOf(this.walker.getAttribute("protected")));
        def.setOnParentVersion(OnParentVersionAction.valueFromName((String)this.walker.getAttribute("onParentVersion")));
        def.setAllowsSameNameSiblings(Boolean.valueOf(this.walker.getAttribute("sameNameSiblings")));
        String type = this.walker.getAttribute("defaultPrimaryType");
        if (type != null && type.length() > 0) {
            def.setDefaultPrimaryType(QName.fromJCRName(type, this.resolver));
        }
        if (this.walker.enterElement("requiredPrimaryTypes")) {
            Vector<QName> types = new Vector<QName>();
            while (this.walker.iterateElements("requiredPrimaryType")) {
                types.add(QName.fromJCRName(this.walker.getContent(), this.resolver));
            }
            def.setRequiredPrimaryTypes(types.toArray(new QName[types.size()]));
            this.walker.leaveElement();
        }
        return def;
    }
}

