/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.util.DOMBuilder;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;

public final class NodeTypeWriter {
    private final DOMBuilder builder = new DOMBuilder("nodeTypes");
    private final NamespaceResolver resolver;

    public static void write(OutputStream xml, NodeTypeDef[] types, NamespaceRegistry registry) throws IOException, RepositoryException {
        try {
            NodeTypeWriter writer = new NodeTypeWriter(registry);
            for (int i = 0; i < types.length; ++i) {
                writer.addNodeTypeDef(types[i]);
            }
            writer.write(xml);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoPrefixDeclaredException e) {
            throw new RepositoryException("Invalid namespace reference in a node type definition", (Throwable)e);
        }
    }

    private NodeTypeWriter(NamespaceRegistry registry) throws ParserConfigurationException, RepositoryException {
        String[] prefixes = registry.getPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            if ("".equals(prefixes[i])) continue;
            String uri = registry.getURI(prefixes[i]);
            this.builder.setAttribute("xmlns:" + prefixes[i], uri);
        }
        this.resolver = new AdditionalNamespaceResolver(registry);
    }

    private void addNodeTypeDef(NodeTypeDef def) throws RepositoryException, NoPrefixDeclaredException {
        this.builder.startElement("nodeType");
        this.builder.setAttribute("name", def.getName().toJCRName(this.resolver));
        this.builder.setAttribute("isMixin", def.isMixin());
        this.builder.setAttribute("hasOrderableChildNodes", def.hasOrderableChildNodes());
        QName item = def.getPrimaryItemName();
        if (item != null) {
            this.builder.setAttribute("primaryItemName", item.toJCRName(this.resolver));
        } else {
            this.builder.setAttribute("primaryItemName", "");
        }
        QName[] supertypes = def.getSupertypes();
        if (supertypes != null && supertypes.length > 0) {
            this.builder.startElement("supertypes");
            for (int i = 0; i < supertypes.length; ++i) {
                this.builder.addContentElement("supertype", supertypes[i].toJCRName(this.resolver));
            }
            this.builder.endElement();
        }
        PropDef[] properties = def.getPropertyDefs();
        for (int i = 0; i < properties.length; ++i) {
            this.addPropDef(properties[i]);
        }
        NodeDef[] nodes = def.getChildNodeDefs();
        for (int i = 0; i < nodes.length; ++i) {
            this.addChildNodeDef(nodes[i]);
        }
        this.builder.endElement();
    }

    private void addPropDef(PropDef def) throws RepositoryException, NoPrefixDeclaredException {
        InternalValue[] defaults;
        this.builder.startElement("propertyDefinition");
        this.builder.setAttribute("name", def.getName().toJCRName(this.resolver));
        this.builder.setAttribute("autoCreated", def.isAutoCreated());
        this.builder.setAttribute("mandatory", def.isMandatory());
        this.builder.setAttribute("protected", def.isProtected());
        this.builder.setAttribute("onParentVersion", OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()));
        this.builder.setAttribute("multiple", def.isMultiple());
        this.builder.setAttribute("requiredType", PropertyType.nameFromValue((int)def.getRequiredType()));
        ValueConstraint[] constraints = def.getValueConstraints();
        if (constraints != null && constraints.length > 0) {
            this.builder.startElement("valueConstraints");
            for (int i = 0; i < constraints.length; ++i) {
                this.builder.addContentElement("valueConstraint", constraints[i].getDefinition(this.resolver));
            }
            this.builder.endElement();
        }
        if ((defaults = def.getDefaultValues()) != null && defaults.length > 0) {
            this.builder.startElement("defaultValues");
            for (int i = 0; i < defaults.length; ++i) {
                this.builder.addContentElement("defaultValue", defaults[i].toJCRValue(this.resolver).getString());
            }
            this.builder.endElement();
        }
        this.builder.endElement();
    }

    private void addChildNodeDef(NodeDef def) throws NoPrefixDeclaredException {
        this.builder.startElement("childNodeDefinition");
        this.builder.setAttribute("name", def.getName().toJCRName(this.resolver));
        this.builder.setAttribute("autoCreated", def.isAutoCreated());
        this.builder.setAttribute("mandatory", def.isMandatory());
        this.builder.setAttribute("protected", def.isProtected());
        this.builder.setAttribute("onParentVersion", OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()));
        this.builder.setAttribute("sameNameSiblings", def.allowsSameNameSiblings());
        QName type = def.getDefaultPrimaryType();
        if (type != null) {
            this.builder.setAttribute("defaultPrimaryType", type.toJCRName(this.resolver));
        } else {
            this.builder.setAttribute("defaultPrimaryType", "");
        }
        QName[] requiredTypes = def.getRequiredPrimaryTypes();
        this.builder.startElement("requiredPrimaryTypes");
        for (int i = 0; i < requiredTypes.length; ++i) {
            this.builder.addContentElement("requiredPrimaryType", requiredTypes[i].toJCRName(this.resolver));
        }
        this.builder.endElement();
        this.builder.endElement();
    }

    private void write(OutputStream xml) throws IOException {
        this.builder.write(xml);
    }
}

