/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventImpl
implements Event {
    private static final Logger log = LoggerFactory.getLogger((Class)EventImpl.class);
    private final SessionImpl session;
    private final EventState eventState;
    private String stringValue;

    EventImpl(SessionImpl session, EventState eventState) {
        this.session = session;
        this.eventState = eventState;
    }

    public int getType() {
        return this.eventState.getType();
    }

    public String getPath() throws RepositoryException {
        try {
            Path p = this.eventState.getChildRelPath().getIndex() > 0 ? Path.create(this.eventState.getParentPath(), this.eventState.getChildRelPath().getName(), this.eventState.getChildRelPath().getIndex(), false) : Path.create(this.eventState.getParentPath(), this.eventState.getChildRelPath().getName(), false);
            return p.toJCRPath(this.session.getNamespaceResolver());
        }
        catch (MalformedPathException e) {
            String msg = "internal error: malformed path for event";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        catch (NoPrefixDeclaredException e) {
            String msg = "internal error: encountered unregistered namespace in path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public String getUserID() {
        return this.eventState.getUserId();
    }

    public NodeId getParentId() {
        return this.eventState.getParentId();
    }

    public NodeId getChildId() {
        return this.eventState.getChildId();
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Event: Path: ");
            try {
                sb.append(this.getPath());
            }
            catch (RepositoryException e) {
                log.error("Exception retrieving path: " + (Object)((Object)e));
                sb.append("[Error retrieving path]");
            }
            sb.append(", ").append(EventState.valueOf(this.getType())).append(": ");
            sb.append(", UserId: ").append(this.getUserID());
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        return this.eventState.hashCode() ^ this.session.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventImpl) {
            EventImpl other = (EventImpl)obj;
            return this.eventState.equals(other.eventState) && this.session.equals(other.session);
        }
        return false;
    }
}

