/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.DispatchAction;
import org.apache.jackrabbit.core.observation.EventConsumer;
import org.apache.jackrabbit.core.observation.EventDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObservationManagerFactory
extends EventDispatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((Class)ObservationManagerFactory.class);
    private static final DispatchAction DISPOSE_MARKER = new DispatchAction(null, null);
    private Set activeConsumers = new HashSet();
    private Set synchronousConsumers = new HashSet();
    private Set readOnlyConsumers;
    private Set synchronousReadOnlyConsumers;
    private Object consumerChange = new Object();
    private Buffer eventQueue = BufferUtils.blockingBuffer((Buffer)new UnboundedFifoBuffer());
    private Thread notificationThread = new Thread((Runnable)this, "ObservationManager");

    public ObservationManagerFactory() {
        this.notificationThread.setDaemon(true);
        this.notificationThread.start();
    }

    public void dispose() {
        this.eventQueue.add((Object)DISPOSE_MARKER);
        try {
            this.notificationThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info("Notification of EventListeners stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getAsynchronousConsumers() {
        Object object = this.consumerChange;
        synchronized (object) {
            if (this.readOnlyConsumers == null) {
                this.readOnlyConsumers = Collections.unmodifiableSet(new HashSet(this.activeConsumers));
            }
            return this.readOnlyConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getSynchronousConsumers() {
        Object object = this.consumerChange;
        synchronized (object) {
            if (this.synchronousReadOnlyConsumers == null) {
                this.synchronousReadOnlyConsumers = Collections.unmodifiableSet(new HashSet(this.synchronousConsumers));
            }
            return this.synchronousReadOnlyConsumers;
        }
    }

    public ObservationManagerImpl createObservationManager(SessionImpl session, ItemManager itemMgr) {
        return new ObservationManagerImpl(this, session, itemMgr);
    }

    public void run() {
        DispatchAction action;
        while ((action = (DispatchAction)this.eventQueue.remove()) != DISPOSE_MARKER) {
            log.debug("got EventStateCollection");
            log.debug("event delivery to " + action.getEventConsumers().size() + " consumers started...");
            Iterator it = action.getEventConsumers().iterator();
            while (it.hasNext()) {
                EventConsumer c = (EventConsumer)it.next();
                try {
                    c.consumeEvents(action.getEventStates());
                }
                catch (Throwable t) {
                    log.warn("EventConsumer threw exception: " + t.toString());
                    log.debug("Stacktrace: ", t);
                }
            }
            log.debug("event delivery finished.");
        }
    }

    void prepareEvents(EventStateCollection events) {
        HashSet consumers = new HashSet();
        consumers.addAll(this.getSynchronousConsumers());
        consumers.addAll(this.getAsynchronousConsumers());
        Iterator it = consumers.iterator();
        while (it.hasNext()) {
            EventConsumer c = (EventConsumer)it.next();
            c.prepareEvents(events);
        }
    }

    void prepareDeleted(EventStateCollection events, ChangeLog changes) {
        HashSet consumers = new HashSet();
        consumers.addAll(this.getSynchronousConsumers());
        consumers.addAll(this.getAsynchronousConsumers());
        Iterator it = consumers.iterator();
        while (it.hasNext()) {
            EventConsumer c = (EventConsumer)it.next();
            c.prepareDeleted(events, changes.deletedStates());
        }
    }

    void dispatchEvents(EventStateCollection events) {
        Set synchronous = this.getSynchronousConsumers();
        if (log.isDebugEnabled()) {
            log.debug("notifying " + synchronous.size() + " synchronous listeners.");
        }
        Iterator it = synchronous.iterator();
        while (it.hasNext()) {
            EventConsumer c = (EventConsumer)it.next();
            try {
                c.consumeEvents(events);
            }
            catch (Throwable t) {
                log.error("Synchronous EventConsumer threw exception.", t);
            }
        }
        this.eventQueue.add((Object)new DispatchAction(events, this.getAsynchronousConsumers()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(EventConsumer consumer) {
        Object object = this.consumerChange;
        synchronized (object) {
            if (consumer.getEventListener() instanceof SynchronousEventListener) {
                this.synchronousConsumers.remove(consumer);
                this.synchronousConsumers.add(consumer);
                this.synchronousReadOnlyConsumers = null;
            } else {
                this.activeConsumers.remove(consumer);
                this.activeConsumers.add(consumer);
                this.readOnlyConsumers = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(EventConsumer consumer) {
        Object object = this.consumerChange;
        synchronized (object) {
            if (consumer.getEventListener() instanceof SynchronousEventListener) {
                this.synchronousConsumers.remove(consumer);
                this.synchronousReadOnlyConsumers = null;
            } else {
                this.activeConsumers.remove(consumer);
                this.readOnlyConsumers = null;
            }
        }
    }
}

