/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.state.ItemStateManager;

public class QueryHandlerContext {
    private final FileSystem fs;
    private final ItemStateManager stateMgr;
    private final NodeTypeRegistry ntRegistry;
    private NodeId rootId;
    private final PropertyTypeRegistry propRegistry;
    private final QueryHandler parentHandler;
    private final NodeId excludedNodeId;

    public QueryHandlerContext(FileSystem fs, ItemStateManager stateMgr, NodeId rootId, NodeTypeRegistry ntRegistry, QueryHandler parentHandler, NodeId excludedNodeId) {
        this.fs = fs;
        this.stateMgr = stateMgr;
        this.rootId = rootId;
        this.ntRegistry = ntRegistry;
        this.propRegistry = new PropertyTypeRegistry(ntRegistry);
        this.parentHandler = parentHandler;
        this.excludedNodeId = excludedNodeId;
        ntRegistry.addListener(this.propRegistry);
    }

    public ItemStateManager getItemStateManager() {
        return this.stateMgr;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public NodeId getRootId() {
        return this.rootId;
    }

    public PropertyTypeRegistry getPropertyTypeRegistry() {
        return this.propRegistry;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntRegistry;
    }

    public QueryHandler getParentHandler() {
        return this.parentHandler;
    }

    public NodeId getExcludedNodeId() {
        return this.excludedNodeId;
    }

    public void destroy() {
        this.ntRegistry.removeListener(this.propRegistry);
    }
}

