/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;

public class QueryImpl
extends AbstractQueryImpl {
    protected SessionImpl session;
    protected String statement;
    protected String language;
    protected ExecutableQuery query;
    protected Node node;
    protected QueryHandler handler;
    private boolean initialized = false;

    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, String statement, String language) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.statement = statement;
        this.language = language;
        this.handler = handler;
        this.query = handler.createExecutableQuery(session, itemMgr, statement, language);
        this.initialized = true;
    }

    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.node = node;
        this.handler = handler;
        try {
            if (!node.isNodeType(QName.NT_QUERY.toJCRName(session.getNamespaceResolver()))) {
                throw new InvalidQueryException("node is not of type nt:query");
            }
            this.statement = node.getProperty(QName.JCR_STATEMENT.toJCRName(session.getNamespaceResolver())).getString();
            this.language = node.getProperty(QName.JCR_LANGUAGE.toJCRName(session.getNamespaceResolver())).getString();
            this.query = handler.createExecutableQuery(session, itemMgr, this.statement, this.language);
        }
        catch (NoPrefixDeclaredException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        this.initialized = true;
    }

    public QueryResult execute() throws RepositoryException {
        this.checkInitialized();
        return this.query.execute();
    }

    public String getStatement() {
        this.checkInitialized();
        return this.statement;
    }

    public String getLanguage() {
        this.checkInitialized();
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (this.node == null) {
            throw new ItemNotFoundException("not a persistent query");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        try {
            NamespaceResolver resolver = this.session.getNamespaceResolver();
            Path p = Path.create(absPath, resolver, true);
            if (!p.isAbsolute()) {
                throw new RepositoryException(absPath + " is not an absolute path");
            }
            String relPath = p.toJCRPath(resolver).substring(1);
            Node queryNode = this.session.getRootNode().addNode(relPath, QName.NT_QUERY.toJCRName(resolver));
            queryNode.setProperty(QName.JCR_LANGUAGE.toJCRName(resolver), this.language);
            queryNode.setProperty(QName.JCR_STATEMENT.toJCRName(resolver), this.statement);
            this.node = queryNode;
            return this.node;
        }
        catch (MalformedPathException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoPrefixDeclaredException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

