/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.Arrays;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DerefQueryNode;
import org.apache.jackrabbit.core.query.ExactQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.name.QName;

public class QueryTreeDump
implements QueryNodeVisitor {
    private int indent;
    private static char[] PADDING = new char[255];
    private static final char PADDING_CHAR = ' ';

    private QueryTreeDump(QueryNode node, StringBuffer buffer) {
        node.accept(this, buffer);
    }

    public static void dump(QueryNode node, StringBuffer buffer) {
        new QueryTreeDump(node, buffer);
    }

    public Object visit(QueryRootNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append("+ Root node");
        buffer.append("\n");
        QName[] select = node.getSelectProperties();
        buffer.append("+ Select properties: ");
        if (select.length == 0) {
            buffer.append("*");
        } else {
            String comma = "";
            for (int i = 0; i < select.length; ++i) {
                buffer.append(comma);
                buffer.append(select[i].toString());
                comma = ", ";
            }
        }
        buffer.append("\n");
        this.traverse(new QueryNode[]{node.getLocationNode()}, buffer);
        OrderQueryNode order = node.getOrderNode();
        if (order != null) {
            this.traverse(new QueryNode[]{order}, buffer);
        }
        return buffer;
    }

    public Object visit(OrQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ OrQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(AndQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ AndQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(NotQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ NotQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(ExactQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ ExactQueryNode: ");
        buffer.append(" Prop=").append(node.getPropertyName());
        buffer.append(" Value=").append(node.getValue());
        buffer.append("\n");
        return buffer;
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ NodeTypeQueryNode: ");
        buffer.append(" Prop=").append(node.getPropertyName());
        buffer.append(" Value=").append(node.getValue());
        buffer.append("\n");
        return buffer;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ TextsearchQueryNode: ");
        buffer.append(" Query=").append(node.getQuery());
        buffer.append("\n");
        return buffer;
    }

    public Object visit(PathQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ PathQueryNode");
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ LocationStepQueryNode: ");
        buffer.append(" NodeTest=");
        if (node.getNameTest() == null) {
            buffer.append("*");
        } else {
            buffer.append(node.getNameTest());
        }
        buffer.append(" Descendants=").append(node.getIncludeDescendants());
        buffer.append(" Index=");
        if (node.getIndex() == -2147483647) {
            buffer.append("NONE");
        } else if (node.getIndex() == Integer.MIN_VALUE) {
            buffer.append("last()");
        } else {
            buffer.append(node.getIndex());
        }
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    public Object visit(RelationQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ RelationQueryNode: Op: ");
        if (node.getOperation() == 24) {
            buffer.append("BETWEEN");
        } else if (node.getOperation() == 12) {
            buffer.append("= ");
        } else if (node.getOperation() == 11) {
            buffer.append("eq");
        } else if (node.getOperation() == 19) {
            buffer.append("ge");
        } else if (node.getOperation() == 17) {
            buffer.append("gt");
        } else if (node.getOperation() == 25) {
            buffer.append("IN");
        } else if (node.getOperation() == 21) {
            buffer.append("le");
        } else if (node.getOperation() == 23) {
            buffer.append("LIKE");
        } else if (node.getOperation() == 15) {
            buffer.append("lt");
        } else if (node.getOperation() == 14) {
            buffer.append("<>");
        } else if (node.getOperation() == 13) {
            buffer.append("ne");
        } else if (node.getOperation() == 27) {
            buffer.append("NOT NULL");
        } else if (node.getOperation() == 26) {
            buffer.append("IS NULL");
        }
        buffer.append(" Prop=" + node.getProperty());
        if (node.getValueType() == 4) {
            buffer.append(" Type=DATE Value=").append(node.getDateValue());
        } else if (node.getValueType() == 2) {
            buffer.append(" Type=DOUBLE Value=").append(node.getDoubleValue());
        } else if (node.getValueType() == 1) {
            buffer.append(" Type=LONG Value=").append(node.getLongValue());
        } else if (node.getValueType() == 6) {
            buffer.append(" Type=POS Value=").append(node.getPositionValue());
        } else if (node.getValueType() == 3) {
            buffer.append(" Type=STRING Value=").append(node.getStringValue());
        } else if (node.getValueType() == 5) {
            buffer.append(" Type=TIMESTAMP Value=").append(node.getDateValue());
        }
        buffer.append("\n");
        return buffer;
    }

    public Object visit(OrderQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ OrderQueryNode");
        buffer.append("\n");
        OrderQueryNode.OrderSpec[] specs = node.getOrderSpecs();
        for (int i = 0; i < specs.length; ++i) {
            buffer.append(PADDING, 0, this.indent);
            buffer.append("  ").append(specs[i].getProperty());
            buffer.append(" asc=").append(specs[i].isAscending());
            buffer.append("\n");
        }
        return buffer;
    }

    public Object visit(DerefQueryNode node, Object data) {
        StringBuffer buffer = (StringBuffer)data;
        buffer.append(PADDING, 0, this.indent);
        buffer.append("+ DerefQueryNode: ");
        buffer.append(" NodeTest=");
        if (node.getNameTest() == null) {
            buffer.append("*");
        } else {
            buffer.append(node.getNameTest());
        }
        buffer.append(" Descendants=").append(node.getIncludeDescendants());
        buffer.append(" Index=");
        if (node.getIndex() == -2147483647) {
            buffer.append("NONE");
        } else if (node.getIndex() == Integer.MIN_VALUE) {
            buffer.append("last()");
        } else {
            buffer.append(node.getIndex());
        }
        buffer.append("\n");
        this.traverse(node.getOperands(), buffer);
        return buffer;
    }

    private void traverse(QueryNode[] node, StringBuffer buffer) {
        this.indent += 2;
        if (this.indent > PADDING.length) {
            char[] tmp = new char[this.indent * 2];
            Arrays.fill(tmp, ' ');
            PADDING = tmp;
        }
        for (int i = 0; i < node.length; ++i) {
            node[i].accept(this, buffer);
        }
        this.indent -= 2;
    }

    static {
        Arrays.fill(PADDING, ' ');
    }
}

