/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.SingleTermDocs;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public final class CachingMultiReader
extends MultiReader
implements HierarchyResolver {
    private ReadOnlyIndexReader[] subReaders;
    private final Map readersByBase = new IdentityHashMap();
    private final DocNumberCache cache;
    private int[] starts;
    private int refCount = 1;

    public CachingMultiReader(ReadOnlyIndexReader[] subReaders, DocNumberCache cache) throws IOException {
        super((IndexReader[])subReaders);
        this.cache = cache;
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        int maxDoc = 0;
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = maxDoc;
            maxDoc += subReaders[i].maxDoc();
            OffsetReader offsetReader = new OffsetReader(subReaders[i], this.starts[i]);
            this.readersByBase.put(subReaders[i].getBase().getBase(), offsetReader);
        }
        this.starts[subReaders.length] = maxDoc;
    }

    public final int getParent(int n) throws IOException {
        DocId id = this.getParentDocId(n);
        return id.getDocumentNumber((IndexReader)this);
    }

    public final DocId getParentDocId(int n) throws IOException {
        int i = this.readerIndex(n);
        DocId id = this.subReaders[i].getParent(n - this.starts[i]);
        return id.applyOffset(this.starts[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term.field() == FieldNames.UUID) {
            OffsetReader offsetReader;
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && (offsetReader = (OffsetReader)this.readersByBase.get((Object)e.reader)) != null && !offsetReader.reader.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc + offsetReader.offset);
            }
            for (int i = 0; i < this.subReaders.length; ++i) {
                TermDocs docs = this.subReaders[i].termDocs(term);
                try {
                    if (!docs.next()) continue;
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc() + this.starts[i]);
                    return singleTermDocs;
                }
                finally {
                    docs.close();
                }
            }
        }
        return super.termDocs(term);
    }

    synchronized void incrementRefCount() {
        ++this.refCount;
    }

    protected synchronized void doClose() throws IOException {
        if (--this.refCount == 0) {
            super.doClose();
        }
    }

    private final int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    private static final class OffsetReader {
        final ReadOnlyIndexReader reader;
        final int offset;

        OffsetReader(ReadOnlyIndexReader reader, int offset) {
            this.reader = reader;
            this.offset = offset;
        }
    }
}

