/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheckError;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsistencyCheck {
    private static final Logger log = LoggerFactory.getLogger((Class)ConsistencyCheck.class);
    private final ItemStateManager stateMgr;
    private final MultiIndex index;
    private Map documents;
    private final List errors = new ArrayList();

    private ConsistencyCheck(MultiIndex index, ItemStateManager mgr) {
        this.index = index;
        this.stateMgr = mgr;
    }

    static ConsistencyCheck run(MultiIndex index, ItemStateManager mgr) throws IOException {
        ConsistencyCheck check = new ConsistencyCheck(index, mgr);
        check.run();
        return check;
    }

    void repair(boolean ignoreFailure) throws IOException {
        if (this.errors.size() == 0) {
            log.info("No errors found.");
            return;
        }
        int notRepairable = 0;
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            ConsistencyCheckError error = (ConsistencyCheckError)it.next();
            try {
                if (error.repairable()) {
                    error.repair();
                    continue;
                }
                log.warn("Not repairable: " + error);
                ++notRepairable;
            }
            catch (Exception e2) {
                IOException e2;
                if (ignoreFailure) {
                    log.warn("Exception while reparing: " + e2);
                    continue;
                }
                if (!(e2 instanceof IOException)) {
                    e2 = new IOException(e2.getMessage());
                }
                throw (IOException)e2;
            }
        }
        log.info("Repaired " + (this.errors.size() - notRepairable) + " errors.");
        if (notRepairable > 0) {
            log.warn("" + notRepairable + " error(s) not repairable.");
        }
    }

    List getErrors() {
        return new ArrayList(this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException {
        String uuid;
        Document d;
        HashSet<String> multipleEntries = new HashSet<String>();
        this.documents = new HashMap();
        IndexReader reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (reader.isDeleted(i)) continue;
                d = reader.document(i);
                uuid = d.get(FieldNames.UUID);
                if (this.stateMgr.hasItemState(NodeId.valueOf(uuid))) {
                    Document old = this.documents.put(uuid, d);
                    if (old == null) continue;
                    multipleEntries.add(uuid);
                    continue;
                }
                this.errors.add(new NodeDeleted(uuid));
            }
        }
        finally {
            reader.close();
        }
        Iterator<Object> it = multipleEntries.iterator();
        while (it.hasNext()) {
            this.errors.add(new MultipleEntries((String)it.next()));
        }
        it = this.documents.values().iterator();
        while (it.hasNext()) {
            d = (Document)it.next();
            uuid = d.get(FieldNames.UUID);
            String parentUUID = d.get(FieldNames.PARENT);
            if (this.documents.containsKey(parentUUID) || parentUUID.length() == 0) continue;
            NodeId parentId = NodeId.valueOf(parentUUID);
            if (this.stateMgr.hasItemState(parentId)) {
                this.errors.add(new MissingAncestor(uuid, parentUUID));
                continue;
            }
            this.errors.add(new UnknownParent(uuid, parentUUID));
        }
    }

    private String getPath(NodeState node) {
        String uuid = node.getNodeId().toString();
        StringBuffer path = new StringBuffer();
        ArrayList<NodeState.ChildNodeEntry> elements = new ArrayList<NodeState.ChildNodeEntry>();
        try {
            while (node.getParentId() != null) {
                NodeId parentId = node.getParentId();
                NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
                NodeState.ChildNodeEntry entry = parent.getChildNodeEntry(node.getNodeId());
                elements.add(entry);
                node = parent;
            }
            for (int i = elements.size() - 1; i > -1; --i) {
                NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)elements.get(i);
                path.append('/').append(entry.getName().getLocalName());
                if (entry.getIndex() <= 1) continue;
                path.append('[').append(entry.getIndex()).append(']');
            }
            if (path.length() == 0) {
                path.append('/');
            }
            return path.toString();
        }
        catch (ItemStateException e) {
            return uuid;
        }
    }

    private class NodeDeleted
    extends ConsistencyCheckError {
        NodeDeleted(String uuid) {
            super("Node " + uuid + " does not longer exist.", uuid);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            log.info("Removing deleted node from index: " + this.uuid);
            ConsistencyCheck.this.index.removeDocument(new Term(FieldNames.UUID, this.uuid));
        }
    }

    private class MultipleEntries
    extends ConsistencyCheckError {
        MultipleEntries(String uuid) {
            super("Multiple entries found for node " + uuid, uuid);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            Term id = new Term(FieldNames.UUID, this.uuid);
            ConsistencyCheck.this.index.removeAllDocuments(id);
            try {
                NodeState node = (NodeState)ConsistencyCheck.this.stateMgr.getItemState(NodeId.valueOf(this.uuid));
                log.info("Re-indexing duplicate node occurrences in index: " + ConsistencyCheck.this.getPath(node));
                Document d = ConsistencyCheck.this.index.createDocument(node);
                ConsistencyCheck.this.index.addDocument(d);
                ConsistencyCheck.this.documents.put(node.getNodeId().toString(), d);
            }
            catch (ItemStateException e) {
                throw new IOException(e.toString());
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private class UnknownParent
    extends ConsistencyCheckError {
        private UnknownParent(String uuid, String parentUUID) {
            super("Node " + uuid + " has unknown parent: " + parentUUID, uuid);
        }

        public boolean repairable() {
            return false;
        }

        public void repair() throws IOException {
            log.warn("Unknown parent for " + this.uuid + " cannot be repaired");
        }
    }

    private class MissingAncestor
    extends ConsistencyCheckError {
        private final String parentUUID;

        private MissingAncestor(String uuid, String parentUUID) {
            super("Parent of " + uuid + " missing in index. Parent: " + parentUUID, uuid);
            this.parentUUID = parentUUID;
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            String pUUID = this.parentUUID;
            while (pUUID != null && !ConsistencyCheck.this.documents.containsKey(pUUID)) {
                try {
                    NodeState n = (NodeState)ConsistencyCheck.this.stateMgr.getItemState(NodeId.valueOf(pUUID));
                    log.info("Reparing missing node " + ConsistencyCheck.this.getPath(n));
                    Document d = ConsistencyCheck.this.index.createDocument(n);
                    ConsistencyCheck.this.index.addDocument(d);
                    ConsistencyCheck.this.documents.put(n.getNodeId().toString(), d);
                    pUUID = n.getParentId().toString();
                }
                catch (ItemStateException e) {
                    throw new IOException(e.toString());
                }
                catch (RepositoryException e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }
}

