/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Iterator;
import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateReferenceCache;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.name.QName;

public class LocalItemStateManager
implements UpdatableItemStateManager,
ItemStateListener {
    private final ItemStateReferenceCache cache;
    protected final SharedItemStateManager sharedStateMgr;
    protected final EventStateCollectionFactory factory;
    private boolean editMode;
    private final ChangeLog changeLog = new ChangeLog();

    public LocalItemStateManager(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory) {
        this.cache = new ItemStateReferenceCache();
        this.sharedStateMgr = sharedStateMgr;
        this.factory = factory;
    }

    protected NodeState getNodeState(NodeId id) throws NoSuchItemStateException, ItemStateException {
        NodeState state = (NodeState)this.sharedStateMgr.getItemState(id);
        state = new NodeState(state, state.getStatus(), false);
        this.cache.cache(state);
        state.addListener(this);
        return state;
    }

    protected PropertyState getPropertyState(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        PropertyState state = (PropertyState)this.sharedStateMgr.getItemState(id);
        state = new PropertyState(state, state.getStatus(), false);
        this.cache.cache(state);
        state.addListener(this);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.changeLog.get(id);
        if (state != null) {
            return state;
        }
        ItemStateReferenceCache itemStateReferenceCache = this.cache;
        synchronized (itemStateReferenceCache) {
            state = this.cache.retrieve(id);
            if (state == null) {
                state = id.denotesNode() ? this.getNodeState((NodeId)id) : this.getPropertyState((PropertyId)id);
            }
            return state;
        }
    }

    public boolean hasItemState(ItemId id) {
        try {
            ItemState state = this.changeLog.get(id);
            if (state != null) {
                return true;
            }
        }
        catch (NoSuchItemStateException e) {
            return false;
        }
        if (this.cache.isCached(id)) {
            return true;
        }
        return this.sharedStateMgr.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs = this.changeLog.get(id);
        if (refs != null) {
            return refs;
        }
        return this.sharedStateMgr.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        if (this.changeLog.get(id) != null) {
            return true;
        }
        return this.sharedStateMgr.hasNodeReferences(id);
    }

    public synchronized void edit() throws IllegalStateException {
        if (this.editMode) {
            throw new IllegalStateException("Already in edit mode");
        }
        this.changeLog.reset();
        this.editMode = true;
    }

    public boolean inEditMode() {
        return this.editMode;
    }

    public NodeState createNew(NodeId id, QName nodeTypeName, NodeId parentId) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        NodeState state = new NodeState(id, nodeTypeName, parentId, 4, false);
        this.changeLog.added(state);
        return state;
    }

    public PropertyState createNew(QName propName, NodeId parentId) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        PropertyState state = new PropertyState(new PropertyId(parentId, propName), 4, false);
        this.changeLog.added(state);
        return state;
    }

    public void store(ItemState state) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.changeLog.modified(state);
    }

    public void destroy(ItemState state) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.changeLog.deleted(state);
    }

    public void cancel() throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.changeLog.undo(this.sharedStateMgr);
        this.editMode = false;
    }

    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.update(this.changeLog);
        this.changeLog.reset();
        this.editMode = false;
    }

    protected void update(ChangeLog changeLog) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        this.sharedStateMgr.update(changeLog, this.factory);
        changeLog.persisted();
    }

    public void dispose() {
        Iterator iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            ItemState state = (ItemState)iter.next();
            state.removeListener(this);
            state.discard();
            state.onDisposed();
        }
        this.cache.evictAll();
    }

    public void stateCreated(ItemState created) {
    }

    public void stateModified(ItemState modified) {
    }

    public void stateDestroyed(ItemState destroyed) {
        destroyed.removeListener(this);
        this.cache.evict(destroyed.getId());
    }

    public void stateDiscarded(ItemState discarded) {
        discarded.removeListener(this);
        this.cache.evict(discarded.getId());
    }
}

