/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.ItemStateMap;
import org.apache.jackrabbit.core.state.ItemStateStore;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransientItemStateManager
implements ItemStateManager,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)TransientItemStateManager.class);
    private final ItemStateStore atticStore;
    private final ItemStateStore transientStore = new ItemStateMap();
    private AtticItemStateManager attic;

    TransientItemStateManager() {
        this.atticStore = new ItemStateMap();
    }

    public void dump(PrintStream ps) {
        ps.println("TransientItemStateManager (" + this + ")");
        ps.println();
        ps.print("[transient] ");
        if (this.transientStore instanceof Dumpable) {
            ((Dumpable)((Object)this.transientStore)).dump(ps);
        } else {
            ps.println(this.transientStore.toString());
        }
        ps.println();
        ps.print("[attic]     ");
        if (this.atticStore instanceof Dumpable) {
            ((Dumpable)((Object)this.atticStore)).dump(ps);
        } else {
            ps.println(this.atticStore.toString());
        }
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.transientStore.get(id);
        if (state != null) {
            return state;
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasItemState(ItemId id) {
        return this.transientStore.contains(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        throw new ItemStateException("getNodeReferences() not implemented");
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        return false;
    }

    boolean hasAnyItemStates() {
        return !this.transientStore.isEmpty();
    }

    boolean hasAnyItemStatesInAttic() {
        return !this.atticStore.isEmpty();
    }

    int getEntriesCount() {
        return this.transientStore.size();
    }

    int getEntriesInAtticCount() {
        return this.atticStore.size();
    }

    Iterator getEntries() {
        return this.transientStore.values().iterator();
    }

    Iterator getEntriesInAttic() {
        return this.atticStore.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeState createNodeState(NodeId id, QName nodeTypeName, NodeId parentId, int initialStatus) throws ItemStateException {
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(id, nodeTypeName, parentId, initialStatus, true);
            this.transientStore.put(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeState createNodeState(NodeState overlayedState, int initialStatus) throws ItemStateException {
        NodeId id = overlayedState.getNodeId();
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(overlayedState, initialStatus, true);
            this.transientStore.put(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyState createPropertyState(NodeId parentId, QName propName, int initialStatus) throws ItemStateException {
        PropertyId id = new PropertyId(parentId, propName);
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(id, initialStatus, true);
            this.transientStore.put(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyState createPropertyState(PropertyState overlayedState, int initialStatus) throws ItemStateException {
        PropertyId id = overlayedState.getPropertyId();
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(overlayedState, initialStatus, true);
            this.transientStore.put(state);
            return state;
        }
    }

    void disposeItemState(ItemState state) {
        state.discard();
        this.transientStore.remove(state.getId());
        state.onDisposed();
    }

    void moveItemStateToAttic(ItemState state) {
        this.transientStore.remove(state.getId());
        this.atticStore.put(state);
    }

    void disposeItemStateInAttic(ItemState state) {
        state.discard();
        this.atticStore.remove(state.getId());
        state.onDisposed();
    }

    void disposeAllItemStates() {
        ItemState state;
        ArrayList tmp = new ArrayList(this.transientStore.values());
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            this.disposeItemState(state);
        }
        tmp = new ArrayList(this.atticStore.values());
        iter = tmp.iterator();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            this.disposeItemStateInAttic(state);
        }
    }

    ItemStateManager getAttic() {
        if (this.attic == null) {
            this.attic = new AtticItemStateManager();
        }
        return this.attic;
    }

    private class AtticItemStateManager
    implements ItemStateManager {
        AtticItemStateManager() {
        }

        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = TransientItemStateManager.this.atticStore.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException(id.toString());
        }

        public boolean hasItemState(ItemId id) {
            return TransientItemStateManager.this.atticStore.contains(id);
        }

        public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
            throw new ItemStateException("getNodeReferences() not implemented");
        }

        public boolean hasNodeReferences(NodeReferencesId id) {
            return false;
        }
    }
}

