/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state.db;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.state.AbstractPersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PMContext;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.util.BLOBStore;
import org.apache.jackrabbit.core.state.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.state.util.Serializer;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDbPersistenceManager
extends AbstractPersistenceManager {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleDbPersistenceManager.class);
    protected static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    protected boolean initialized = false;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String schema = "default";
    protected String schemaObjectPrefix = "";
    protected boolean externalBLOBs = true;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected Connection con;
    protected PreparedStatement nodeStateInsert;
    protected PreparedStatement nodeStateUpdate;
    protected PreparedStatement nodeStateSelect;
    protected PreparedStatement nodeStateSelectExist;
    protected PreparedStatement nodeStateDelete;
    protected PreparedStatement propertyStateInsert;
    protected PreparedStatement propertyStateUpdate;
    protected PreparedStatement propertyStateSelect;
    protected PreparedStatement propertyStateSelectExist;
    protected PreparedStatement propertyStateDelete;
    protected PreparedStatement nodeReferenceInsert;
    protected PreparedStatement nodeReferenceUpdate;
    protected PreparedStatement nodeReferenceSelect;
    protected PreparedStatement nodeReferenceSelectExist;
    protected PreparedStatement nodeReferenceDelete;
    protected PreparedStatement blobInsert;
    protected PreparedStatement blobUpdate;
    protected PreparedStatement blobSelect;
    protected PreparedStatement blobSelectExist;
    protected PreparedStatement blobDelete;
    protected FileSystem blobFS;
    protected BLOBStore blobStore;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isExternalBLOBs() {
        return this.externalBLOBs;
    }

    public void setExternalBLOBs(boolean externalBLOBs) {
        this.externalBLOBs = externalBLOBs;
    }

    public void setExternalBLOBs(String externalBLOBs) {
        this.externalBLOBs = Boolean.valueOf(externalBLOBs);
    }

    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        Class.forName(this.driver);
        this.con = DriverManager.getConnection(this.url, this.user, this.password);
        this.con.setAutoCommit(false);
        this.prepareSchemaObjectPrefix();
        this.checkSchema();
        this.nodeStateInsert = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "NODE (NODE_DATA, NODE_ID) values (?, ?)");
        this.nodeStateUpdate = this.con.prepareStatement("update " + this.schemaObjectPrefix + "NODE set NODE_DATA = ? where NODE_ID = ?");
        this.nodeStateSelect = this.con.prepareStatement("select NODE_DATA from " + this.schemaObjectPrefix + "NODE where NODE_ID = ?");
        this.nodeStateSelectExist = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "NODE where NODE_ID = ?");
        this.nodeStateDelete = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "NODE where NODE_ID = ?");
        this.propertyStateInsert = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "PROP (PROP_DATA, PROP_ID) values (?, ?)");
        this.propertyStateUpdate = this.con.prepareStatement("update " + this.schemaObjectPrefix + "PROP set PROP_DATA = ? where PROP_ID = ?");
        this.propertyStateSelect = this.con.prepareStatement("select PROP_DATA from " + this.schemaObjectPrefix + "PROP where PROP_ID = ?");
        this.propertyStateSelectExist = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "PROP where PROP_ID = ?");
        this.propertyStateDelete = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "PROP where PROP_ID = ?");
        this.nodeReferenceInsert = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID) values (?, ?)");
        this.nodeReferenceUpdate = this.con.prepareStatement("update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID = ?");
        this.nodeReferenceSelect = this.con.prepareStatement("select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?");
        this.nodeReferenceSelectExist = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?");
        this.nodeReferenceDelete = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?");
        if (this.externalBLOBs) {
            LocalFileSystem blobFS = new LocalFileSystem();
            blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
            blobFS.init();
            this.blobFS = blobFS;
            this.blobStore = new FileSystemBLOBStore(blobFS);
        } else {
            this.blobStore = new DbBLOBStore();
            this.blobInsert = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "BINVAL (BINVAL_DATA, BINVAL_ID) values (?, ?)");
            this.blobUpdate = this.con.prepareStatement("update " + this.schemaObjectPrefix + "BINVAL set BINVAL_DATA = ? where BINVAL_ID = ?");
            this.blobSelect = this.con.prepareStatement("select BINVAL_DATA from " + this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?");
            this.blobSelectExist = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?");
            this.blobDelete = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?");
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.closeStatement(this.nodeStateInsert);
            this.closeStatement(this.nodeStateUpdate);
            this.closeStatement(this.nodeStateSelect);
            this.closeStatement(this.nodeStateSelectExist);
            this.closeStatement(this.nodeStateDelete);
            this.closeStatement(this.propertyStateInsert);
            this.closeStatement(this.propertyStateUpdate);
            this.closeStatement(this.propertyStateSelect);
            this.closeStatement(this.propertyStateSelectExist);
            this.closeStatement(this.propertyStateDelete);
            this.closeStatement(this.nodeReferenceInsert);
            this.closeStatement(this.nodeReferenceUpdate);
            this.closeStatement(this.nodeReferenceSelect);
            this.closeStatement(this.nodeReferenceSelectExist);
            this.closeStatement(this.nodeReferenceDelete);
            if (!this.externalBLOBs) {
                this.closeStatement(this.blobInsert);
                this.closeStatement(this.blobUpdate);
                this.closeStatement(this.blobSelect);
                this.closeStatement(this.blobSelectExist);
                this.closeStatement(this.blobDelete);
            } else {
                this.blobFS.close();
                this.blobFS = null;
            }
            this.blobStore = null;
            this.con.close();
        }
        finally {
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        ItemStateException ise;
        block14: {
            ise = null;
            super.store(changeLog);
            Object var5_3 = null;
            if (ise != null) break block14;
            try {
                this.con.commit();
            }
            catch (SQLException e2) {
                String msg = "committing change log failed";
                log.error(msg, (Throwable)e2);
                throw new ItemStateException(msg, e2);
            }
        }
        try {
            this.con.rollback();
        }
        catch (SQLException e3) {
            String msg = "rollback of change log failed";
            log.error(msg, (Throwable)e3);
        }
        throw ise;
        {
            catch (ItemStateException e) {
                ise = e;
                Object var5_4 = null;
                if (ise == null) {
                    try {
                        this.con.commit();
                    }
                    catch (SQLException e2) {
                        String msg = "committing change log failed";
                        log.error(msg, (Throwable)e2);
                        throw new ItemStateException(msg, e2);
                    }
                }
                try {
                    this.con.rollback();
                }
                catch (SQLException e3) {
                    String msg = "rollback of change log failed";
                    log.error(msg, (Throwable)e3);
                }
                throw ise;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ise == null) {
                try {
                    this.con.commit();
                }
                catch (SQLException e2) {
                    String msg = "committing change log failed";
                    log.error(msg, (Throwable)e2);
                    throw new ItemStateException(msg, e2);
                }
            }
            try {
                this.con.rollback();
            }
            catch (SQLException e3) {
                String msg = "rollback of change log failed";
                log.error(msg, (Throwable)e3);
            }
            throw ise;
            throw throwable;
        }
    }

    public NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement preparedStatement = stmt = this.nodeStateSelect;
        synchronized (preparedStatement) {
            NodeState nodeState;
            ResultSet rs = null;
            InputStream in = null;
            try {
                stmt.setString(1, id.toString());
                stmt.execute();
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new NoSuchItemStateException(id.toString());
                }
                in = rs.getBinaryStream(1);
                NodeState state = this.createNew(id);
                Serializer.deserialize(state, in);
                nodeState = state;
                this.closeStream(in);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (Exception e) {
                try {
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read node state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeStream(in);
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return nodeState;
        }
    }

    public PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement preparedStatement = stmt = this.propertyStateSelect;
        synchronized (preparedStatement) {
            PropertyState propertyState;
            ResultSet rs = null;
            InputStream in = null;
            try {
                stmt.setString(1, id.toString());
                stmt.execute();
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new NoSuchItemStateException(id.toString());
                }
                in = rs.getBinaryStream(1);
                PropertyState state = this.createNew(id);
                Serializer.deserialize(state, in, this.blobStore);
                propertyState = state;
                this.closeStream(in);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (Exception e) {
                try {
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read property state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeStream(in);
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return propertyState;
        }
    }

    public synchronized void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        PreparedStatement stmt = update ? this.nodeStateUpdate : this.nodeStateInsert;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, (OutputStream)out);
            stmt.setBytes(1, out.toByteArray());
            stmt.setString(2, state.getNodeId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "failed to write node state: " + state.getNodeId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.resetStatement(stmt);
        }
    }

    public synchronized void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        PreparedStatement stmt = update ? this.propertyStateUpdate : this.propertyStateInsert;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, out, this.blobStore);
            stmt.setBytes(1, out.toByteArray());
            stmt.setString(2, state.getPropertyId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "failed to write property state: " + state.getPropertyId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.resetStatement(stmt);
        }
    }

    public synchronized void destroy(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement stmt = this.nodeStateDelete;
        try {
            stmt.setString(1, state.getNodeId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "failed to delete node state: " + state.getNodeId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.resetStatement(stmt);
        }
    }

    public synchronized void destroy(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                if (val == null || val.getType() != 2) continue;
                BLOBFileValue blobVal = (BLOBFileValue)val.internalValue();
                blobVal.delete(true);
                String blobId = this.blobStore.createId(state.getPropertyId(), i);
                try {
                    this.blobStore.remove(blobId);
                    continue;
                }
                catch (Exception e) {
                    log.warn("failed to remove from BLOBStore: " + blobId, (Throwable)e);
                }
            }
        }
        PreparedStatement stmt = this.propertyStateDelete;
        try {
            stmt.setString(1, state.getPropertyId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "failed to delete property state: " + state.getPropertyId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.resetStatement(stmt);
        }
    }

    public NodeReferences load(NodeReferencesId targetId) throws NoSuchItemStateException, ItemStateException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement preparedStatement = stmt = this.nodeReferenceSelect;
        synchronized (preparedStatement) {
            NodeReferences nodeReferences;
            ResultSet rs = null;
            InputStream in = null;
            try {
                stmt.setString(1, targetId.toString());
                stmt.execute();
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new NoSuchItemStateException(targetId.toString());
                }
                in = rs.getBinaryStream(1);
                NodeReferences refs = new NodeReferences(targetId);
                Serializer.deserialize(refs, in);
                nodeReferences = refs;
                this.closeStream(in);
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (Exception e) {
                try {
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read node references: " + targetId;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeStream(in);
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return nodeReferences;
        }
    }

    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.exists(refs.getId());
        PreparedStatement stmt = update ? this.nodeReferenceUpdate : this.nodeReferenceInsert;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            stmt.setBytes(1, out.toByteArray());
            stmt.setString(2, refs.getId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "failed to write node references: " + refs.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.resetStatement(stmt);
        }
    }

    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement stmt = this.nodeReferenceDelete;
        try {
            stmt.setString(1, refs.getId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            String msg = "failed to delete node references: " + refs.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
        finally {
            this.resetStatement(stmt);
        }
    }

    public boolean exists(NodeId id) throws ItemStateException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement preparedStatement = stmt = this.nodeStateSelectExist;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs = null;
            try {
                stmt.setString(1, id.toString());
                stmt.execute();
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of node state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean exists(PropertyId id) throws ItemStateException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement preparedStatement = stmt = this.propertyStateSelectExist;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs = null;
            try {
                stmt.setString(1, id.toString());
                stmt.execute();
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of property state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean exists(NodeReferencesId targetId) throws ItemStateException {
        PreparedStatement stmt;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        PreparedStatement preparedStatement = stmt = this.nodeReferenceSelectExist;
        synchronized (preparedStatement) {
            boolean bl;
            ResultSet rs = null;
            try {
                stmt.setString(1, targetId.toString());
                stmt.execute();
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.resetStatement(stmt);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of node references: " + targetId;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.resetStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    protected void resetStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.clearParameters();
                stmt.clearWarnings();
            }
            catch (SQLException se) {
                this.logException("failed resetting PreparedStatement", se);
            }
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                this.logException("failed closing ResultSet", se);
            }
        }
    }

    protected void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException se) {
                this.logException("failed closing Statement", se);
            }
        }
    }

    protected void logException(String message, SQLException se) {
        if (message != null) {
            log.error(message);
        }
        log.error("    reason: " + se.getMessage());
        log.error("state/code: " + se.getSQLState() + "/" + se.getErrorCode());
        log.debug("      dump:", (Throwable)se);
    }

    protected void prepareSchemaObjectPrefix() throws Exception {
        DatabaseMetaData metaData = this.con.getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append("_x");
                String hex = Integer.toHexString(c);
                escaped.append("0000".toCharArray(), 0, 4 - hex.length());
                escaped.append(hex);
                escaped.append("_");
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws Exception {
        boolean schemaExists;
        DatabaseMetaData metaData = this.con.getMetaData();
        String tableName = this.schemaObjectPrefix + "NODE";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        ResultSet rs = metaData.getTables(null, null, tableName, null);
        try {
            schemaExists = rs.next();
        }
        finally {
            rs.close();
        }
        if (!schemaExists) {
            InputStream in = this.getClass().getResourceAsStream(this.schema + ".ddl");
            if (in == null) {
                String msg = "Configuration error: unknown schema '" + this.schema + "'";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.con.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    sql = Text.replace(sql, SCHEMA_OBJECT_PREFIX_VARIABLE, this.schemaObjectPrefix);
                    stmt.executeUpdate(sql);
                    sql = reader.readLine();
                }
                this.con.commit();
            }
            finally {
                this.closeStream(in);
                this.closeStatement(stmt);
            }
        }
    }

    class DbBLOBStore
    implements BLOBStore {
        DbBLOBStore() {
        }

        public String createId(PropertyId id, int index) {
            StringBuffer sb = new StringBuffer();
            sb.append(id.toString());
            sb.append('[');
            sb.append(index);
            sb.append(']');
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream get(String blobId) throws Exception {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = SimpleDbPersistenceManager.this.blobSelect;
            synchronized (preparedStatement) {
                try {
                    stmt.setString(1, blobId);
                    stmt.execute();
                    ResultSet rs = stmt.getResultSet();
                    if (!rs.next()) {
                        SimpleDbPersistenceManager.this.closeResultSet(rs);
                        throw new Exception("no such BLOB: " + blobId);
                    }
                    InputStream in = rs.getBinaryStream(1);
                    if (in == null) {
                        SimpleDbPersistenceManager.this.closeResultSet(rs);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                        return byteArrayInputStream;
                    }
                    FilterInputStream filterInputStream = new FilterInputStream(this, in, rs){
                        private final /* synthetic */ ResultSet val$rs;
                        private final /* synthetic */ DbBLOBStore this$1;
                        {
                            this.this$1 = this$1;
                            this.val$rs = val$rs;
                            super(x0);
                        }

                        public void close() throws IOException {
                            this.in.close();
                            DbBLOBStore.access$000(this.this$1).closeResultSet(this.val$rs);
                        }
                    };
                    return filterInputStream;
                }
                finally {
                    SimpleDbPersistenceManager.this.resetStatement(stmt);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            PreparedStatement stmt = SimpleDbPersistenceManager.this.blobSelectExist;
            try {
                stmt.setString(1, blobId);
                stmt.execute();
                ResultSet rs = stmt.getResultSet();
                boolean exists = rs.next();
                SimpleDbPersistenceManager.this.resetStatement(stmt);
                SimpleDbPersistenceManager.this.closeResultSet(rs);
                stmt = exists ? SimpleDbPersistenceManager.this.blobUpdate : SimpleDbPersistenceManager.this.blobInsert;
                stmt.setBinaryStream(1, in, (int)size);
                stmt.setString(2, blobId);
                stmt.executeUpdate();
            }
            finally {
                SimpleDbPersistenceManager.this.resetStatement(stmt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean remove(String blobId) throws Exception {
            PreparedStatement stmt = SimpleDbPersistenceManager.this.blobDelete;
            try {
                stmt.setString(1, blobId);
                boolean bl = stmt.executeUpdate() == 1;
                return bl;
            }
            finally {
                SimpleDbPersistenceManager.this.resetStatement(stmt);
            }
        }

        static /* synthetic */ SimpleDbPersistenceManager access$000(DbBLOBStore x0) {
            return x0.SimpleDbPersistenceManager.this;
        }
    }
}

