/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.version.VersionSelector;

public class GenericVersionSelector
implements VersionSelector {
    private String name = null;
    private String label = null;
    private Calendar date = null;
    private boolean returnLatest = true;

    public GenericVersionSelector() {
    }

    public GenericVersionSelector(String label) {
        this.label = label;
    }

    public GenericVersionSelector(Calendar date) {
        this.date = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public boolean isReturnLatest() {
        return this.returnLatest;
    }

    public void setReturnLatest(boolean returnLatest) {
        this.returnLatest = returnLatest;
    }

    public Version select(VersionHistory versionHistory) throws RepositoryException {
        Version selected = null;
        if (this.name != null) {
            selected = GenericVersionSelector.selectByName(versionHistory, this.name);
        }
        if (selected == null && this.label != null) {
            selected = GenericVersionSelector.selectByLabel(versionHistory, this.label);
        }
        if (selected == null && this.date != null) {
            selected = GenericVersionSelector.selectByDate(versionHistory, this.date);
        }
        if (selected == null && this.returnLatest) {
            selected = GenericVersionSelector.selectByDate(versionHistory, null);
        }
        return selected;
    }

    public static Version selectByName(VersionHistory history, String name) throws RepositoryException {
        if (history.hasNode(name)) {
            return history.getVersion(name);
        }
        return null;
    }

    public static Version selectByLabel(VersionHistory history, String label) throws RepositoryException {
        return history.getVersionByLabel(label);
    }

    public static Version selectByDate(VersionHistory history, Calendar date) throws RepositoryException {
        long time = date != null ? date.getTimeInMillis() : Long.MAX_VALUE;
        long latestDate = Long.MIN_VALUE;
        Version latestVersion = null;
        VersionIterator iter = history.getAllVersions();
        while (iter.hasNext()) {
            Version v = iter.nextVersion();
            long c = v.getCreated().getTimeInMillis();
            if (c <= latestDate || c > time) continue;
            latestDate = c;
            latestVersion = v;
        }
        return latestVersion;
    }
}

