/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PersistenceManager;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.AbstractVersion;
import org.apache.jackrabbit.core.version.AbstractVersionHistory;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalFrozenVHImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionItemStateProvider;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionManagerImpl
extends AbstractVersionManager {
    private static Logger log = LoggerFactory.getLogger((Class)VersionManager.class);
    private static final Path VERSION_STORAGE_PATH;
    private final PersistenceManager pMgr;
    private SharedItemStateManager sharedStateMgr;
    private final VersionItemStateProvider versProvider;
    private NodeTypeRegistry ntReg;
    private final DynamicESCFactory escFactory;
    private final ReferenceMap versionItems = new ReferenceMap(0, 2);

    public VersionManagerImpl(PersistenceManager pMgr, NodeTypeRegistry ntReg, DelegatingObservationDispatcher obsMgr, NodeId rootId, NodeId rootParentId) throws RepositoryException {
        try {
            this.pMgr = pMgr;
            this.ntReg = ntReg;
            this.escFactory = new DynamicESCFactory(obsMgr);
            if (!pMgr.exists(rootId)) {
                NodeState root = pMgr.createNew(rootId);
                root.setParentId(rootParentId);
                root.setDefinitionId(ntReg.getEffectiveNodeType(QName.REP_SYSTEM).getApplicableChildNodeDef(QName.JCR_VERSIONSTORAGE, QName.REP_VERSIONSTORAGE).getId());
                root.setNodeTypeName(QName.REP_VERSIONSTORAGE);
                PropertyState pt = pMgr.createNew(new PropertyId(rootId, QName.JCR_PRIMARYTYPE));
                pt.setDefinitionId(ntReg.getEffectiveNodeType(QName.REP_SYSTEM).getApplicablePropertyDef(QName.JCR_PRIMARYTYPE, 7, false).getId());
                pt.setMultiValued(false);
                pt.setType(7);
                pt.setValues(new InternalValue[]{InternalValue.create(QName.REP_VERSIONSTORAGE)});
                root.addPropertyName(pt.getName());
                ChangeLog cl = new ChangeLog();
                cl.added(root);
                cl.added(pt);
                pMgr.store(cl);
            }
            this.sharedStateMgr = new VersionItemStateManager(pMgr, rootId, ntReg);
            this.stateMgr = new LocalItemStateManager(this.sharedStateMgr, this.escFactory);
            NodeState nodeState = (NodeState)this.stateMgr.getItemState(rootId);
            this.historyRoot = new NodeStateEx(this.stateMgr, ntReg, nodeState, QName.JCR_VERSIONSTORAGE);
            this.versProvider = new VersionItemStateProvider(this, this.sharedStateMgr);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public VirtualItemStateProvider getVirtualItemStateProvider() {
        return this.versProvider;
    }

    public void close() throws Exception {
        this.pMgr.close();
    }

    public DynamicESCFactory getEscFactory() {
        return this.escFactory;
    }

    public VersionHistory createVersionHistory(Session session, final NodeState node) throws RepositoryException {
        InternalVersionHistory history = (InternalVersionHistory)this.escFactory.doSourced((SessionImpl)session, new SourcedTarget(){

            public Object run() throws RepositoryException {
                return VersionManagerImpl.this.createVersionHistory(node);
            }
        });
        if (history == null) {
            throw new VersionException("History already exists for node " + node.getNodeId());
        }
        return (VersionHistory)((SessionImpl)session).getNodeById(history.getId());
    }

    public boolean hasItem(NodeId id) {
        return this.stateMgr.hasItemState(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalVersionItem getItem(NodeId id) throws RepositoryException {
        if (id.equals(this.getHistoryRootId())) {
            return null;
        }
        try {
            ReferenceMap referenceMap = this.versionItems;
            synchronized (referenceMap) {
                InternalVersionItem item = (InternalVersionItem)this.versionItems.get((Object)id);
                if (item == null) {
                    if (this.stateMgr.hasItemState(id)) {
                        NodeState state = (NodeState)this.stateMgr.getItemState(id);
                        NodeStateEx pNode = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
                        NodeId parentId = pNode.getParentId();
                        InternalVersionItem parent = this.getItem(parentId);
                        QName ntName = state.getNodeTypeName();
                        if (ntName.equals(QName.NT_FROZENNODE)) {
                            item = new InternalFrozenNodeImpl(this, pNode, parent);
                        } else if (ntName.equals(QName.NT_VERSIONEDCHILD)) {
                            item = new InternalFrozenVHImpl(this, pNode, parent);
                        } else if (ntName.equals(QName.NT_VERSION)) {
                            item = ((InternalVersionHistory)parent).getVersion(id);
                        } else if (ntName.equals(QName.NT_VERSIONHISTORY)) {
                            item = new InternalVersionHistoryImpl(this, pNode);
                        } else {
                            return null;
                        }
                    }
                    this.versionItems.put((Object)id, (Object)item);
                }
                return item;
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Version checkin(final NodeImpl node) throws RepositoryException {
        InternalVersion version = (InternalVersion)this.escFactory.doSourced((SessionImpl)node.getSession(), new SourcedTarget(){

            public Object run() throws RepositoryException {
                String histUUID = node.getProperty(QName.JCR_VERSIONHISTORY).getString();
                InternalVersion version = VersionManagerImpl.this.checkin((InternalVersionHistoryImpl)VersionManagerImpl.this.getVersionHistory(NodeId.valueOf(histUUID)), node);
                InternalVersion[] preds = version.getPredecessors();
                for (int i = 0; i < preds.length; ++i) {
                    PropertyId propId = new PropertyId(preds[i].getId(), QName.JCR_SUCCESSORS);
                    VersionManagerImpl.this.versProvider.onPropertyChanged(propId);
                }
                return version;
            }
        });
        return (AbstractVersion)((SessionImpl)node.getSession()).getNodeById(version.getId());
    }

    public void removeVersion(VersionHistory history, final QName name) throws VersionException, RepositoryException {
        final AbstractVersionHistory historyImpl = (AbstractVersionHistory)history;
        if (!historyImpl.hasNode(name)) {
            throw new VersionException("Version with name " + name.toString() + " does not exist in this VersionHistory");
        }
        this.escFactory.doSourced((SessionImpl)history.getSession(), new SourcedTarget(){

            public Object run() throws RepositoryException {
                AbstractVersion version = (AbstractVersion)historyImpl.getNode(name);
                InternalVersion[] preds = version.getInternalVersion().getPredecessors();
                InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)historyImpl.getInternalVersionHistory();
                VersionManagerImpl.this.removeVersion(vh, name);
                for (int i = 0; i < preds.length; ++i) {
                    PropertyId propId = new PropertyId(preds[i].getId(), QName.JCR_SUCCESSORS);
                    VersionManagerImpl.this.versProvider.onPropertyChanged(propId);
                }
                return null;
            }
        });
    }

    public Version setVersionLabel(final VersionHistory history, final QName version, final QName label, final boolean move) throws RepositoryException {
        InternalVersion v = (InternalVersion)this.escFactory.doSourced((SessionImpl)history.getSession(), new SourcedTarget(){

            public Object run() throws RepositoryException {
                InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)((AbstractVersionHistory)history).getInternalVersionHistory();
                return VersionManagerImpl.this.setVersionLabel(vh, version, label, move);
            }
        });
        if (v == null) {
            return null;
        }
        return (Version)((SessionImpl)history.getSession()).getNodeByUUID(v.getId().getUUID());
    }

    public void itemsUpdated(Collection items) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            this.itemUpdated((InternalVersionItem)iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemUpdated(InternalVersionItem item) {
        ReferenceMap referenceMap = this.versionItems;
        synchronized (referenceMap) {
            InternalVersionItem cached = (InternalVersionItem)this.versionItems.remove((Object)item.getId());
            if (cached != null && cached instanceof InternalVersionHistoryImpl) {
                InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)cached;
                try {
                    vh.reload();
                    this.versionItems.put((Object)vh.getId(), (Object)vh);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to update version history: " + e.toString());
                }
            }
        }
    }

    public boolean setNodeReferences(NodeReferences references) {
        try {
            NodeReferences refs = new NodeReferences(references.getId());
            Iterator iter = references.getReferences().iterator();
            while (iter.hasNext()) {
                PropertyId id = (PropertyId)iter.next();
                if (this.hasItem(id.getParentId())) continue;
                refs.addReference(id);
            }
            ChangeLog log = new ChangeLog();
            log.modified(refs);
            this.pMgr.store(log);
            return true;
        }
        catch (ItemStateException e) {
            log.error("Error while setting references: " + e.toString());
            return false;
        }
    }

    protected List getItemReferences(InternalVersionItem item) {
        try {
            NodeReferences refs = this.pMgr.load(new NodeReferencesId(item.getId()));
            return refs.getReferences();
        }
        catch (ItemStateException itemStateException) {
            return Collections.EMPTY_LIST;
        }
    }

    NodeId getHistoryRootId() {
        return this.historyRoot.getState().getNodeId();
    }

    SharedItemStateManager getSharedStateMgr() {
        return this.sharedStateMgr;
    }

    static {
        try {
            Path.PathBuilder builder = new Path.PathBuilder();
            builder.addRoot();
            builder.addLast(QName.JCR_SYSTEM);
            builder.addLast(QName.JCR_VERSIONSTORAGE);
            VERSION_STORAGE_PATH = builder.getPath();
        }
        catch (MalformedPathException e) {
            throw new InternalError("Cannot initialize path");
        }
    }

    private abstract class SourcedTarget {
        private SourcedTarget() {
        }

        public abstract Object run() throws RepositoryException;
    }

    public static final class DynamicESCFactory
    implements EventStateCollectionFactory {
        private DelegatingObservationDispatcher obsMgr;
        private SessionImpl source;

        public DynamicESCFactory(DelegatingObservationDispatcher obsMgr) {
            this.obsMgr = obsMgr;
        }

        public synchronized EventStateCollection createEventStateCollection() throws RepositoryException {
            if (this.source == null) {
                throw new RepositoryException("Unknown event source.");
            }
            return this.createEventStateCollection(this.source);
        }

        public EventStateCollection createEventStateCollection(SessionImpl source) {
            return this.obsMgr.createEventStateCollection(source, VERSION_STORAGE_PATH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object doSourced(SessionImpl eventSource, SourcedTarget runnable) throws RepositoryException {
            this.source = eventSource;
            try {
                Object object = runnable.run();
                return object;
            }
            finally {
                this.source = null;
            }
        }
    }

    class VersionItemStateManager
    extends SharedItemStateManager {
        public VersionItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg) throws ItemStateException {
            super(persistMgr, rootNodeId, ntReg, false);
        }

        protected void checkReferentialIntegrity(ChangeLog changes) throws ReferentialIntegrityException, ItemStateException {
            Iterator iter = changes.modifiedRefs();
            while (iter.hasNext()) {
                NodeReferences refs = (NodeReferences)iter.next();
                NodeId id = refs.getTargetId();
                if (!refs.hasReferences() || changes.has(id) || this.hasItemState(id)) continue;
                iter.remove();
            }
        }
    }
}

