/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.AbstractVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.XAVersionManager;

public class XAVersionHistory
extends AbstractVersionHistory {
    private InternalVersionHistory history;
    private final XAVersionManager vMgr;

    public XAVersionHistory(ItemManager itemMgr, SessionImpl session, NodeId id, NodeState state, NodeDefinition definition, ItemLifeCycleListener[] listeners, InternalVersionHistory history) {
        super(itemMgr, session, id, state, definition, listeners);
        this.history = history;
        this.vMgr = (XAVersionManager)session.getVersionManager();
    }

    protected InternalVersionHistory getInternalVersionHistory() throws RepositoryException {
        this.ensureUpToDate();
        this.sanityCheck();
        return this.history;
    }

    protected void sanityCheck() throws RepositoryException {
        super.sanityCheck();
        if (this.history == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
    }

    private synchronized void ensureUpToDate() throws RepositoryException {
        if (this.history != null && this.vMgr.differentXAEnv((InternalVersionHistoryImpl)this.history)) {
            this.history = this.vMgr.getVersionHistory(this.history.getId());
        }
    }
}

