/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.ReferenceValue;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImporter
implements Importer {
    private static Logger log = LoggerFactory.getLogger((Class)SessionImporter.class);
    private final SessionImpl session;
    private final NodeImpl importTargetNode;
    private final int uuidBehavior;
    private Stack parents;
    private final ReferenceChangeTracker refTracker;

    public SessionImporter(NodeImpl importTargetNode, SessionImpl session, int uuidBehavior) {
        this.importTargetNode = importTargetNode;
        this.session = session;
        this.uuidBehavior = uuidBehavior;
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(importTargetNode);
    }

    protected NodeImpl createNode(NodeImpl parent, QName nodeName, QName nodeTypeName, QName[] mixinNames, NodeId id) throws RepositoryException {
        PropertyImpl conflicting;
        if (parent.hasProperty(nodeName) && (conflicting = parent.getProperty(nodeName)).isNew()) {
            QName newName = new QName(nodeName.getNamespaceURI(), nodeName.getLocalName() + "_");
            if (parent.hasProperty(newName)) {
                newName = new QName(newName.getNamespaceURI(), newName.getLocalName() + "_");
            }
            if (conflicting.getDefinition().isMultiple()) {
                parent.setProperty(newName, conflicting.getValues());
            } else {
                parent.setProperty(newName, conflicting.getValue());
            }
            conflicting.remove();
        }
        UUID uuid = id == null ? null : id.getUUID();
        NodeImpl node = parent.addNode(nodeName, nodeTypeName, uuid);
        if (mixinNames != null) {
            for (int i = 0; i < mixinNames.length; ++i) {
                node.addMixin(mixinNames[i]);
            }
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    protected NodeImpl resolveUUIDConflict(NodeImpl parent, NodeImpl conflicting, Importer.NodeInfo nodeInfo) throws RepositoryException {
        void var4_4;
        NodeImpl node;
        if (this.uuidBehavior == 0) {
            node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), null);
            if (node.isNodeType(QName.MIX_REFERENCEABLE)) {
                this.refTracker.mappedUUID(nodeInfo.getId().getUUID(), node.getNodeId().getUUID());
            }
        } else {
            if (this.uuidBehavior == 3) {
                String msg = "a node with uuid " + nodeInfo.getId() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                if (this.importTargetNode.getPath().startsWith(conflicting.getPath())) {
                    String msg = "cannot remove ancestor node";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                conflicting.remove();
                node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else if (this.uuidBehavior == 2) {
                if (conflicting.getDepth() == 0) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                parent = (NodeImpl)conflicting.getParent();
                conflicting.remove();
                node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return var4_4;
    }

    public void start() throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNode(Importer.NodeInfo nodeInfo, List propInfos, NamespaceResolver nsContext) throws RepositoryException {
        NodeImpl existing;
        NodeDefinition def;
        NodeImpl parent = (NodeImpl)this.parents.peek();
        NodeImpl node = null;
        NodeId id = nodeInfo.getId();
        QName nodeName = nodeInfo.getName();
        QName ntName = nodeInfo.getNodeTypeName();
        QName[] mixins = nodeInfo.getMixinNames();
        if (parent == null) {
            this.parents.push(null);
            log.debug("skipping node " + nodeName);
            return;
        }
        if (parent.hasNode(nodeName) && !(def = (existing = parent.getNode(nodeName)).getDefinition()).allowsSameNameSiblings()) {
            if (def.isProtected() && existing.isNodeType(ntName)) {
                this.parents.push(null);
                log.debug("skipping protected node " + existing.safeGetJCRPath());
                return;
            }
            if (def.isAutoCreated() && existing.isNodeType(ntName)) {
                node = existing;
            } else {
                throw new ItemExistsException(existing.safeGetJCRPath());
            }
        }
        if (node == null) {
            if (id == null) {
                node = this.createNode(parent, nodeName, ntName, mixins, null);
            } else {
                NodeImpl conflicting;
                try {
                    conflicting = this.session.getNodeById(id);
                }
                catch (ItemNotFoundException infe) {
                    conflicting = null;
                }
                node = conflicting != null ? this.resolveUUIDConflict(parent, conflicting, nodeInfo) : this.createNode(parent, nodeName, ntName, mixins, id);
            }
        }
        Iterator iter = propInfos.iterator();
        while (iter.hasNext()) {
            Importer.PropInfo pi = (Importer.PropInfo)iter.next();
            QName propName = pi.getName();
            Importer.TextValue[] tva = pi.getValues();
            int type = pi.getType();
            EffectiveNodeType ent = node.getEffectiveNodeType();
            PropDef def2 = tva.length == 1 ? ent.getApplicablePropertyDef(propName, type) : ent.getApplicablePropertyDef(propName, type, true);
            if (def2.isProtected()) {
                log.debug("skipping protected property " + propName);
                continue;
            }
            Value[] va = new Value[tva.length];
            int targetType = def2.getRequiredType();
            if (targetType == 0) {
                targetType = type == 0 ? 1 : type;
            }
            for (int i = 0; i < tva.length; ++i) {
                String serValue;
                Importer.TextValue tv = tva[i];
                if (targetType == 7 || targetType == 8) {
                    try {
                        serValue = tv.retrieve();
                    }
                    catch (IOException ioe) {
                        String msg = "failed to retrieve serialized value";
                        log.debug(msg, (Throwable)ioe);
                        throw new RepositoryException(msg, (Throwable)ioe);
                    }
                    InternalValue ival = InternalValue.create(serValue, targetType, nsContext);
                    va[i] = ival.toJCRValue(this.session.getNamespaceResolver());
                    continue;
                }
                if (targetType == 2) {
                    try {
                        if (tv.length() < 65536L) {
                            va[i] = ValueHelper.deserialize(tv.retrieve(), targetType, false);
                            continue;
                        }
                        Reader reader = tv.reader();
                        try {
                            va[i] = ValueHelper.deserialize(reader, targetType, false);
                            continue;
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException ioe) {
                        String msg = "failed to deserialize binary value";
                        log.debug(msg, (Throwable)ioe);
                        throw new RepositoryException(msg, (Throwable)ioe);
                    }
                }
                try {
                    serValue = tv.retrieve();
                }
                catch (IOException ioe) {
                    String msg = "failed to retrieve serialized value";
                    log.debug(msg, (Throwable)ioe);
                    throw new RepositoryException(msg, (Throwable)ioe);
                }
                va[i] = ValueHelper.deserialize(serValue, targetType, true);
            }
            if (va.length == 1) {
                try {
                    node.setProperty(propName, va[0]);
                }
                catch (ValueFormatException vfe) {
                    node.setProperty(propName, va, type);
                }
                catch (ConstraintViolationException cve) {
                    node.setProperty(propName, va, type);
                }
            } else {
                node.setProperty(propName, va, type);
            }
            if (type != 9) continue;
            this.refTracker.processedReference(node.getProperty(propName));
        }
        this.parents.push(node);
    }

    public void endNode(Importer.NodeInfo nodeInfo) throws RepositoryException {
        this.parents.pop();
    }

    public void end() throws RepositoryException {
        Iterator iter = this.refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop.getType() != 9) continue;
            if (prop.getDefinition().isMultiple()) {
                Value[] values = prop.getValues();
                Value[] newVals = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value val = values[i];
                    UUID original = UUID.fromString(val.getString());
                    UUID adjusted = this.refTracker.getMappedUUID(original);
                    newVals[i] = adjusted != null ? new ReferenceValue(this.session.getNodeByUUID(adjusted)) : val;
                }
                prop.setValue(newVals);
                continue;
            }
            Value val = prop.getValue();
            UUID original = UUID.fromString(val.getString());
            UUID adjusted = this.refTracker.getMappedUUID(original);
            if (adjusted == null) continue;
            prop.setValue(this.session.getNodeByUUID(adjusted));
        }
        this.refTracker.clear();
    }
}

