/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SysViewImportHandler
extends TargetImportHandler {
    private final Stack stack = new Stack();
    private QName currentPropName;
    private int currentPropType = 0;
    private ArrayList currentPropValues = new ArrayList();
    private TargetImportHandler.AppendableValue currentPropValue;

    SysViewImportHandler(Importer importer, NamespaceResolver nsContext) {
        super(importer, nsContext);
    }

    private void processNode(ImportState state, boolean start, boolean end) throws SAXException {
        if (!start && !end) {
            return;
        }
        Importer.NodeInfo node = new Importer.NodeInfo();
        node.setName(state.nodeName);
        node.setNodeTypeName(state.nodeTypeName);
        if (state.mixinNames != null) {
            QName[] mixins = state.mixinNames.toArray(new QName[state.mixinNames.size()]);
            node.setMixinNames(mixins);
        }
        if (state.uuid != null) {
            node.setId(NodeId.valueOf(state.uuid));
        }
        try {
            if (start) {
                this.importer.startNode(node, state.props, this.nsContext);
                Iterator iter = state.props.iterator();
                while (iter.hasNext()) {
                    Importer.PropInfo pi = (Importer.PropInfo)iter.next();
                    this.disposePropertyValues(pi);
                }
            }
            if (end) {
                this.importer.endNode(node);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.importer.start();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI)) {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid namespace for element in system view xml document: " + namespaceURI));
        }
        if ("node".equals(localName)) {
            String name = atts.getValue("sv:name");
            if (name == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:node"));
            }
            if (!this.stack.isEmpty()) {
                ImportState current = (ImportState)this.stack.peek();
                if (!current.started) {
                    this.processNode(current, true, false);
                    current.started = true;
                }
            }
            ImportState state = new ImportState();
            try {
                state.nodeName = QName.fromJCRName(name, this.nsContext);
            }
            catch (IllegalNameException ine) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + name, (Throwable)ine));
            }
            catch (UnknownPrefixException upe) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + name, (Throwable)upe));
            }
            this.stack.push(state);
        } else if ("property".equals(localName)) {
            this.currentPropValues.clear();
            String name = atts.getValue("sv:name");
            if (name == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:property"));
            }
            try {
                this.currentPropName = QName.fromJCRName(name, this.nsContext);
            }
            catch (IllegalNameException ine) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + name, (Throwable)ine));
            }
            catch (UnknownPrefixException upe) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + name, (Throwable)upe));
            }
            String type = atts.getValue("sv:type");
            if (type == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:type attribute of element sv:property"));
            }
            this.currentPropType = PropertyType.valueFromName((String)type);
        } else if ("value".equals(localName)) {
            this.currentPropValue = new TargetImportHandler.BufferedStringValue(this);
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("unexpected element found in system view xml document: " + localName));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ImportState state = (ImportState)this.stack.peek();
        if ("node".equals(localName)) {
            if (!state.started) {
                this.processNode(state, true, true);
                state.started = true;
            } else {
                this.processNode(state, false, true);
            }
            this.stack.pop();
        } else if ("property".equals(localName)) {
            if (this.currentPropName.equals(QName.JCR_PRIMARYTYPE)) {
                TargetImportHandler.AppendableValue val = (TargetImportHandler.AppendableValue)this.currentPropValues.get(0);
                String s = null;
                try {
                    s = val.retrieve();
                    state.nodeTypeName = QName.fromJCRName(s, this.nsContext);
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
                catch (IllegalNameException ine) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)ine));
                }
                catch (UnknownPrefixException upe) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)upe));
                }
            } else if (this.currentPropName.equals(QName.JCR_MIXINTYPES)) {
                if (state.mixinNames == null) {
                    state.mixinNames = new ArrayList(this.currentPropValues.size());
                }
                for (int i = 0; i < this.currentPropValues.size(); ++i) {
                    TargetImportHandler.AppendableValue val = (TargetImportHandler.AppendableValue)this.currentPropValues.get(i);
                    String s = null;
                    try {
                        s = val.retrieve();
                        QName mixin = QName.fromJCRName(s, this.nsContext);
                        state.mixinNames.add(mixin);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new SAXException("error while retrieving value", ioe);
                    }
                    catch (IllegalNameException ine) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)ine));
                    }
                    catch (UnknownPrefixException upe) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)upe));
                    }
                }
            } else if (this.currentPropName.equals(QName.JCR_UUID)) {
                TargetImportHandler.AppendableValue val = (TargetImportHandler.AppendableValue)this.currentPropValues.get(0);
                try {
                    state.uuid = val.retrieve();
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
            } else {
                Importer.PropInfo prop = new Importer.PropInfo();
                prop.setName(this.currentPropName);
                prop.setType(this.currentPropType);
                prop.setValues(this.currentPropValues.toArray(new Importer.TextValue[this.currentPropValues.size()]));
                state.props.add(prop);
            }
            this.currentPropValues.clear();
        } else if ("value".equals(localName)) {
            this.currentPropValues.add(this.currentPropValue);
            this.currentPropValue = null;
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid element in system view xml document: " + localName));
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.importer.end();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    class ImportState {
        QName nodeName;
        QName nodeTypeName;
        ArrayList mixinNames;
        String uuid;
        ArrayList props = new ArrayList();
        boolean started = false;

        ImportState() {
        }
    }
}

