/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.xml.AbstractSAXEventGenerator;
import org.apache.jackrabbit.value.ValueHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SysViewSAXEventGenerator
extends AbstractSAXEventGenerator {
    public static final String NODE_ELEMENT = "node";
    public static final String PREFIXED_NODE_ELEMENT = "sv:node";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String PREFIXED_PROPERTY_ELEMENT = "sv:property";
    public static final String VALUE_ELEMENT = "value";
    public static final String PREFIXED_VALUE_ELEMENT = "sv:value";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PREFIXED_NAME_ATTRIBUTE = "sv:name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PREFIXED_TYPE_ATTRIBUTE = "sv:type";
    public static final String CDATA_TYPE = "CDATA";
    public static final String ENUMERATION_TYPE = "ENUMERATION";

    public SysViewSAXEventGenerator(Node node, boolean noRecurse, boolean skipBinary, ContentHandler contentHandler) throws RepositoryException {
        super(node, noRecurse, skipBinary, contentHandler);
    }

    protected void entering(Node node, int level) throws RepositoryException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        String nodeName = node.getDepth() == 0 ? this.jcrRoot : node.getName();
        attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", NAME_ATTRIBUTE, PREFIXED_NAME_ATTRIBUTE, CDATA_TYPE, nodeName);
        this.contentHandler.startElement("http://www.jcp.org/jcr/sv/1.0", NODE_ELEMENT, PREFIXED_NODE_ELEMENT, attrs);
    }

    protected void enteringProperties(Node node, int level) throws RepositoryException, SAXException {
    }

    protected void leavingProperties(Node node, int level) throws RepositoryException, SAXException {
    }

    protected void leaving(Node node, int level) throws RepositoryException, SAXException {
        this.contentHandler.endElement("http://www.jcp.org/jcr/sv/1.0", NODE_ELEMENT, PREFIXED_NODE_ELEMENT);
    }

    protected void entering(Property prop, int level) throws RepositoryException, SAXException {
        String typeName;
        String propName = prop.getName();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", NAME_ATTRIBUTE, PREFIXED_NAME_ATTRIBUTE, CDATA_TYPE, propName);
        int type = prop.getType();
        try {
            typeName = PropertyType.nameFromValue((int)type);
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("unexpected property-type ordinal: " + type, (Throwable)iae);
        }
        attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", TYPE_ATTRIBUTE, PREFIXED_TYPE_ATTRIBUTE, ENUMERATION_TYPE, typeName);
        this.contentHandler.startElement("http://www.jcp.org/jcr/sv/1.0", PROPERTY_ELEMENT, PREFIXED_PROPERTY_ELEMENT, attrs);
        if (prop.getType() == 2 && this.skipBinary) {
            this.contentHandler.startElement("http://www.jcp.org/jcr/sv/1.0", VALUE_ELEMENT, PREFIXED_VALUE_ELEMENT, new AttributesImpl());
            this.contentHandler.endElement("http://www.jcp.org/jcr/sv/1.0", VALUE_ELEMENT, PREFIXED_VALUE_ELEMENT);
        } else {
            boolean multiValued = prop.getDefinition().isMultiple();
            Value[] vals = multiValued ? prop.getValues() : new Value[]{prop.getValue()};
            for (int i = 0; i < vals.length; ++i) {
                Value val = vals[i];
                this.contentHandler.startElement("http://www.jcp.org/jcr/sv/1.0", VALUE_ELEMENT, PREFIXED_VALUE_ELEMENT, new AttributesImpl());
                Writer writer = new Writer(){

                    public void close() {
                    }

                    public void flush() {
                    }

                    public void write(char[] cbuf, int off, int len) throws IOException {
                        try {
                            SysViewSAXEventGenerator.this.contentHandler.characters(cbuf, off, len);
                        }
                        catch (SAXException se) {
                            throw new IOException(se.toString());
                        }
                    }
                };
                try {
                    ValueHelper.serialize(val, false, writer);
                }
                catch (IOException ioe) {
                    Throwable t = ioe.getCause();
                    if (t != null && t instanceof SAXException) {
                        throw (SAXException)t;
                    }
                    throw new SAXException(ioe);
                }
                this.contentHandler.endElement("http://www.jcp.org/jcr/sv/1.0", VALUE_ELEMENT, PREFIXED_VALUE_ELEMENT);
            }
        }
    }

    protected void leaving(Property prop, int level) throws RepositoryException, SAXException {
        this.contentHandler.endElement("http://www.jcp.org/jcr/sv/1.0", PROPERTY_ELEMENT, PREFIXED_PROPERTY_ELEMENT);
    }
}

