/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.name;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.Text;
import org.apache.xerces.util.XMLChar;

public final class Path {
    private static final PathElement ROOT_ELEMENT = new RootElement();
    private static final PathElement CURRENT_ELEMENT = new CurrentElement();
    private static final PathElement PARENT_ELEMENT = new ParentElement();
    public static final Path ROOT = new Path(new PathElement[]{ROOT_ELEMENT}, true);
    private static final Pattern PATH_ELEMENT_PATTERN = Pattern.compile("(\\.)|(\\.\\.)|(([^ /:\\[\\]*'\"|](?:[^/:\\[\\]*'\"|]*[^ /:\\[\\]*'\"|])?):)?([^ /:\\[\\]*'\"|](?:[^/:\\[\\]*'\"|]*[^ /:\\[\\]*'\"|])?)(\\[([1-9]\\d*)\\])?");
    private static final ThreadLocal PATH_ELEMENT_MATCHER = new ThreadLocal(){

        protected Object initialValue() {
            return PATH_ELEMENT_PATTERN.matcher("dummy");
        }
    };
    private final PathElement[] elements;
    private final boolean normalized;
    private final boolean absolute;
    private int hash = 0;
    private String string;

    private Path(PathElement[] elements, boolean isNormalized) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("Empty paths are not allowed");
        }
        this.elements = elements;
        this.absolute = elements[0].denotesRoot();
        this.normalized = isNormalized;
    }

    public static Path create(String jcrPath, NamespaceResolver resolver, boolean normalize) throws MalformedPathException {
        Path path = Path.parse(jcrPath, null, resolver);
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(Path parent, String relJCRPath, NamespaceResolver resolver, boolean canonicalize) throws MalformedPathException {
        Path path = Path.parse(relJCRPath, parent, resolver);
        if (canonicalize) {
            return path.getCanonicalPath();
        }
        return path;
    }

    public static Path create(Path parent, Path relPath, boolean normalize) throws MalformedPathException {
        if (relPath.isAbsolute()) {
            throw new MalformedPathException("relPath is not a relative path");
        }
        PathBuilder pb = new PathBuilder(parent.getElements());
        pb.addAll(relPath.getElements());
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(Path parent, QName name, boolean normalize) throws MalformedPathException {
        PathBuilder pb = new PathBuilder(parent.getElements());
        pb.addLast(name);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(Path parent, QName name, int index, boolean normalize) throws MalformedPathException {
        PathBuilder pb = new PathBuilder(parent.getElements());
        pb.addLast(name, index);
        Path path = pb.getPath();
        if (normalize) {
            return path.getNormalizedPath();
        }
        return path;
    }

    public static Path create(QName name, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("index must not be negative: " + index);
        }
        PathElement elem = index < 1 ? new PathElement(name) : new PathElement(name, index);
        return new Path(new PathElement[]{elem}, !elem.equals(CURRENT_ELEMENT));
    }

    private static Path parse(String jcrPath, Path master, NamespaceResolver resolver) throws MalformedPathException {
        int i;
        if ("/".equals(jcrPath)) {
            return ROOT;
        }
        String[] elems = Text.explode(jcrPath, 47, true);
        if (elems.length == 0) {
            throw new MalformedPathException("empty path");
        }
        ArrayList<PathElement> list = new ArrayList<PathElement>();
        boolean isNormalized = true;
        boolean leadingParent = true;
        if (master != null) {
            isNormalized = master.normalized;
            for (i = 0; i < master.elements.length; ++i) {
                list.add(master.elements[i]);
                leadingParent &= master.elements[i].denotesParent();
            }
        }
        for (i = 0; i < elems.length; ++i) {
            String elem = elems[i];
            if (i == 0 && elem.length() == 0) {
                if (!list.isEmpty()) {
                    throw new MalformedPathException("'" + jcrPath + "' is not a relative path");
                }
                list.add(ROOT_ELEMENT);
                leadingParent = false;
                continue;
            }
            if (elem.length() == 0 && i == elems.length - 1) break;
            Matcher matcher = (Matcher)PATH_ELEMENT_MATCHER.get();
            matcher.reset(elem);
            if (matcher.matches()) {
                String nsURI;
                String prefix;
                if (resolver == null) continue;
                if (matcher.group(1) != null) {
                    list.add(CURRENT_ELEMENT);
                    leadingParent = false;
                    isNormalized = false;
                    continue;
                }
                if (matcher.group(2) != null) {
                    list.add(PARENT_ELEMENT);
                    isNormalized &= leadingParent;
                    continue;
                }
                if (matcher.group(3) != null) {
                    prefix = matcher.group(4);
                    if (!XMLChar.isValidNCName((String)prefix)) {
                        throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + elem + "' specifies an illegal namespace prefix");
                    }
                } else {
                    prefix = "";
                }
                String localName = matcher.group(5);
                int index = matcher.group(6) != null ? Integer.parseInt(matcher.group(7)) : 0;
                try {
                    nsURI = resolver.getURI(prefix);
                }
                catch (NamespaceException nse) {
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + elem + "' specifies an unmapped namespace prefix");
                }
                PathElement element = index == 0 ? new PathElement(nsURI, localName) : new PathElement(nsURI, localName, index);
                list.add(element);
                leadingParent = false;
                continue;
            }
            throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + elem + "' is not a legal path element");
        }
        if (resolver != null) {
            return new Path(list.toArray(new PathElement[list.size()]), isNormalized);
        }
        return null;
    }

    public static void checkFormat(String jcrPath) throws MalformedPathException {
        Path.parse(jcrPath, null, null);
    }

    public boolean denotesRoot() {
        return this.absolute && this.elements.length == 1;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isCanonical() {
        return this.absolute && this.normalized;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public Path getNormalizedPath() throws MalformedPathException {
        if (this.isNormalized()) {
            return this;
        }
        LinkedList<PathElement> queue = new LinkedList<PathElement>();
        PathElement last = null;
        for (int i = 0; i < this.elements.length; ++i) {
            PathElement elem = this.elements[i];
            if (elem.denotesCurrent()) continue;
            if (elem.denotesParent() && last != null && !last.denotesParent()) {
                if (last.denotesRoot()) {
                    throw new MalformedPathException("Path can not be canonicalized: unresolvable '..' element");
                }
                queue.removeLast();
                if (queue.isEmpty()) {
                    last = null;
                    continue;
                }
                last = (PathElement)queue.getLast();
                continue;
            }
            last = elem;
            queue.add(elem);
        }
        if (queue.isEmpty()) {
            throw new MalformedPathException("Path can not be normalized: would result in an empty path.");
        }
        return new Path(queue.toArray(new PathElement[queue.size()]), true);
    }

    public Path getCanonicalPath() throws MalformedPathException {
        if (this.isCanonical()) {
            return this;
        }
        if (!this.isAbsolute()) {
            throw new MalformedPathException("only an absolute path can be canonicalized.");
        }
        return this.getNormalizedPath();
    }

    public Path computeRelativePath(Path other) throws MalformedPathException {
        Path p1;
        if (other == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (!this.isAbsolute() || !other.isAbsolute()) {
            throw new MalformedPathException("not an absolute path");
        }
        Path p0 = this.getCanonicalPath();
        if (p0.equals(p1 = other.getCanonicalPath())) {
            PathBuilder pb = new PathBuilder();
            pb.addLast(CURRENT_ELEMENT);
            return pb.getPath();
        }
        int lengthCommon = 0;
        for (int i = 0; i < p0.elements.length && i < p1.elements.length && p0.elements[i].equals(p1.elements[i]); ++i) {
            ++lengthCommon;
        }
        PathBuilder pb = new PathBuilder();
        if (lengthCommon < p0.elements.length) {
            int tmp = p0.elements.length - lengthCommon;
            while (tmp-- > 0) {
                pb.addFirst(PARENT_ELEMENT);
            }
        }
        for (int i = lengthCommon; i < p1.elements.length; ++i) {
            pb.addLast(p1.elements[i]);
        }
        return pb.getPath();
    }

    public Path getAncestor(int degree) throws IllegalArgumentException, PathNotFoundException {
        if (degree < 0) {
            throw new IllegalArgumentException("degree must be >= 0");
        }
        if (degree == 0) {
            return this;
        }
        int length = this.elements.length - degree;
        if (length < 1) {
            throw new PathNotFoundException("no such ancestor path of degree " + degree);
        }
        PathElement[] elements = new PathElement[length];
        for (int i = 0; i < length; ++i) {
            elements[i] = this.elements[i];
        }
        return new Path(elements, this.normalized);
    }

    public int getAncestorCount() {
        return this.getDepth() - 1;
    }

    public int getLength() {
        return this.elements.length;
    }

    public int getDepth() {
        int depth = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].denotesParent()) {
                --depth;
                continue;
            }
            if (this.elements[i].denotesCurrent()) continue;
            ++depth;
        }
        return depth;
    }

    public boolean isAncestorOf(Path other) throws MalformedPathException {
        Path p1;
        if (other == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new MalformedPathException("cannot compare a relative path with an absolute path");
        }
        Path p0 = this.getNormalizedPath();
        if (p0.equals(p1 = other.getNormalizedPath())) {
            return false;
        }
        if (p0.getDepth() >= p1.getDepth()) {
            return false;
        }
        for (int i = 0; i < p0.elements.length; ++i) {
            if (p0.elements[i].equals(p1.elements[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendantOf(Path other) throws MalformedPathException {
        if (other == null) {
            throw new IllegalArgumentException("null argument");
        }
        return other.isAncestorOf(this);
    }

    public PathElement getNameElement() {
        return this.elements[this.elements.length - 1];
    }

    public PathElement[] getElements() {
        return this.elements;
    }

    public String toJCRPath(NamespaceResolver resolver) throws NoPrefixDeclaredException {
        if (this.denotesRoot()) {
            return "/";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                sb.append('/');
            }
            PathElement element = this.elements[i];
            element.toJCRName(resolver, sb);
        }
        return sb.toString();
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.elements.length; ++i) {
                if (i > 0) {
                    sb.append('\t');
                }
                PathElement element = this.elements[i];
                String elem = element.toString();
                sb.append(elem);
            }
            this.string = sb.toString();
        }
        return this.string;
    }

    public static Path valueOf(String s) throws IllegalArgumentException {
        if ("".equals(s) || s == null) {
            throw new IllegalArgumentException("invalid Path literal");
        }
        String[] elements = Text.explode(s, 9, true);
        ArrayList<PathElement> list = new ArrayList<PathElement>();
        boolean isNormalized = true;
        boolean leadingParent = true;
        for (int i = 0; i < elements.length; ++i) {
            PathElement elem = PathElement.fromString(elements[i]);
            list.add(elem);
            isNormalized &= !elem.denotesCurrent() && ((leadingParent &= elem.denotesParent()) || !elem.denotesParent());
        }
        return new Path(list.toArray(new PathElement[list.size()]), isNormalized);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 17;
            for (int i = 0; i < this.elements.length; ++i) {
                h = 37 * h + this.elements[i].hashCode();
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            return Arrays.equals(this.elements, other.elements);
        }
        return false;
    }

    public static class PathElement {
        private final QName name;
        private final int index;

        private PathElement(String namespaceURI, String localName) {
            this(new QName(namespaceURI, localName));
        }

        private PathElement(String namespaceURI, String localName, int index) {
            this(new QName(namespaceURI, localName), index);
        }

        private PathElement(QName name) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            this.name = name;
            this.index = 0;
        }

        private PathElement(QName name, int index) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            if (index < 1) {
                throw new IllegalArgumentException("index is 1-based");
            }
            this.index = index;
            this.name = name;
        }

        public QName getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean denotesRoot() {
            return this.equals(ROOT_ELEMENT);
        }

        public boolean denotesParent() {
            return this.equals(PARENT_ELEMENT);
        }

        public boolean denotesCurrent() {
            return this.equals(CURRENT_ELEMENT);
        }

        public boolean denotesName() {
            return !this.denotesRoot() && !this.denotesParent() && !this.denotesCurrent();
        }

        public String toJCRName(NamespaceResolver resolver) throws NoPrefixDeclaredException {
            StringBuffer sb = new StringBuffer();
            this.toJCRName(resolver, sb);
            return sb.toString();
        }

        public void toJCRName(NamespaceResolver resolver, StringBuffer buf) throws NoPrefixDeclaredException {
            this.name.toJCRName(resolver, buf);
            int index = this.getIndex();
            if (index > 1) {
                buf.append('[');
                buf.append(index);
                buf.append(']');
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name.toString());
            int index = this.getIndex();
            if (index > 0) {
                sb.append('[');
                sb.append(index);
                sb.append(']');
            }
            return sb.toString();
        }

        public static PathElement fromString(String s) throws IllegalArgumentException {
            if (s == null) {
                throw new IllegalArgumentException("null PathElement literal");
            }
            if (s.equals("*")) {
                return ROOT_ELEMENT;
            }
            if (s.equals(".")) {
                return CURRENT_ELEMENT;
            }
            if (s.equals("..")) {
                return PARENT_ELEMENT;
            }
            int pos = s.indexOf(91);
            if (pos == -1) {
                QName name = QName.valueOf(s);
                return new PathElement(name.getNamespaceURI(), name.getLocalName());
            }
            QName name = QName.valueOf(s.substring(0, pos));
            int pos1 = s.indexOf(93);
            if (pos1 == -1) {
                throw new IllegalArgumentException("invalid PathElement literal: " + s + " (missing ']')");
            }
            try {
                int index = Integer.valueOf(s.substring(pos + 1, pos1));
                if (index < 1) {
                    throw new IllegalArgumentException("invalid PathElement literal: " + s + " (index is 1-based)");
                }
                return new PathElement(name.getNamespaceURI(), name.getLocalName(), index);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("invalid PathElement literal: " + s + " (" + t.getMessage() + ")");
            }
        }

        public int hashCode() {
            int h = 17;
            h = 37 * h + this.index;
            h = 37 * h + this.name.hashCode();
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PathElement) {
                PathElement other = (PathElement)obj;
                return this.name.equals(other.name) && this.index == other.index;
            }
            return false;
        }
    }

    public static final class ParentElement
    extends PathElement {
        static final String LITERAL = "..";

        private ParentElement() {
            super("", LITERAL);
        }

        public boolean denotesRoot() {
            return false;
        }

        public boolean denotesCurrent() {
            return false;
        }

        public boolean denotesParent() {
            return true;
        }

        public boolean denotesName() {
            return false;
        }

        public String toJCRName(NamespaceResolver resolver) throws NoPrefixDeclaredException {
            return LITERAL;
        }

        public String toString() {
            return LITERAL;
        }
    }

    public static final class CurrentElement
    extends PathElement {
        static final String LITERAL = ".";

        private CurrentElement() {
            super("", LITERAL);
        }

        public boolean denotesRoot() {
            return false;
        }

        public boolean denotesCurrent() {
            return true;
        }

        public boolean denotesParent() {
            return false;
        }

        public boolean denotesName() {
            return false;
        }

        public String toJCRName(NamespaceResolver resolver) throws NoPrefixDeclaredException {
            return LITERAL;
        }

        public String toString() {
            return LITERAL;
        }
    }

    public static final class RootElement
    extends PathElement {
        static final String LITERAL = "*";

        private RootElement() {
            super("", "");
        }

        public boolean denotesRoot() {
            return true;
        }

        public boolean denotesCurrent() {
            return false;
        }

        public boolean denotesParent() {
            return false;
        }

        public boolean denotesName() {
            return false;
        }

        public String toJCRName(NamespaceResolver resolver) throws NoPrefixDeclaredException {
            return "";
        }

        public String toString() {
            return LITERAL;
        }
    }

    public static final class PathBuilder
    implements Cloneable {
        private final LinkedList queue = new LinkedList();
        boolean isNormalized = true;
        boolean leadingParent = true;

        public PathBuilder() {
        }

        public PathBuilder(PathElement[] elements) {
            this();
            this.addAll(elements);
        }

        public void addRoot() {
            this.addFirst(ROOT_ELEMENT);
        }

        public void addAll(PathElement[] elements) {
            for (int i = 0; i < elements.length; ++i) {
                this.addLast(elements[i]);
            }
        }

        public void addFirst(PathElement elem) {
            if (this.queue.isEmpty()) {
                this.isNormalized &= !elem.denotesCurrent();
                this.leadingParent = elem.denotesParent();
            } else {
                this.isNormalized &= !elem.denotesCurrent() && (!this.leadingParent || elem.denotesParent());
                this.leadingParent |= elem.denotesParent();
            }
            this.queue.addFirst(elem);
        }

        public void addFirst(QName name) {
            this.addFirst(new PathElement(name));
        }

        public void addFirst(QName name, int index) {
            this.addFirst(new PathElement(name, index));
        }

        public void addLast(PathElement elem) {
            this.queue.addLast(elem);
            this.leadingParent &= elem.denotesParent();
            this.isNormalized &= !elem.denotesCurrent() && (this.leadingParent || !elem.denotesParent());
        }

        public void addLast(QName name) {
            this.addLast(new PathElement(name));
        }

        public void addLast(QName name, int index) {
            this.addLast(new PathElement(name, index));
        }

        public Path getPath() throws MalformedPathException {
            PathElement[] elements = this.queue.toArray(new PathElement[this.queue.size()]);
            if (elements.length == 0) {
                throw new MalformedPathException("empty path");
            }
            return new Path(elements, this.isNormalized);
        }

        public Object clone() {
            PathBuilder clone = new PathBuilder();
            clone.queue.addAll(this.queue);
            return clone;
        }
    }
}

