/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.value;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.apache.jackrabbit.value.BaseValue;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.NameValue;
import org.apache.jackrabbit.value.PathValue;
import org.apache.jackrabbit.value.ReferenceValue;
import org.apache.jackrabbit.value.StringValue;

public class ValueHelper {
    private ValueHelper() {
    }

    public static Value convert(String srcValue, int targetType) throws ValueFormatException, IllegalArgumentException {
        if (srcValue == null) {
            return null;
        }
        return ValueHelper.convert(new StringValue(srcValue), targetType);
    }

    public static Value[] convert(String[] srcValues, int targetType) throws ValueFormatException, IllegalArgumentException {
        if (srcValues == null) {
            return null;
        }
        Value[] newValues = new Value[srcValues.length];
        for (int i = 0; i < srcValues.length; ++i) {
            newValues[i] = ValueHelper.convert(srcValues[i], targetType);
        }
        return newValues;
    }

    public static Value[] convert(Value[] srcValues, int targetType) throws ValueFormatException, IllegalArgumentException {
        if (srcValues == null) {
            return null;
        }
        Value[] newValues = new Value[srcValues.length];
        int srcValueType = 0;
        for (int i = 0; i < srcValues.length; ++i) {
            if (srcValues[i] == null) {
                newValues[i] = null;
                continue;
            }
            if (srcValueType == 0) {
                srcValueType = srcValues[i].getType();
            } else if (srcValueType != srcValues[i].getType()) {
                String msg = "inhomogeneous type of values";
                throw new ValueFormatException(msg);
            }
            newValues[i] = ValueHelper.convert(srcValues[i], targetType);
        }
        return newValues;
    }

    /*
     * WARNING - void declaration
     */
    public static Value convert(Value srcValue, int targetType) throws ValueFormatException, IllegalStateException, IllegalArgumentException {
        void var2_3;
        if (srcValue == null) {
            return null;
        }
        int srcType = srcValue.getType();
        if (srcType == targetType) {
            return srcValue;
        }
        block9 : switch (targetType) {
            case 1: {
                BaseValue val;
                try {
                    val = new StringValue(srcValue.getString());
                    break;
                }
                catch (RepositoryException re) {
                    throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType), (Throwable)re);
                }
            }
            case 2: {
                BaseValue val;
                try {
                    val = new BinaryValue(srcValue.getStream());
                    break;
                }
                catch (RepositoryException re) {
                    throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType), (Throwable)re);
                }
            }
            case 6: {
                BaseValue val;
                try {
                    val = new BooleanValue(srcValue.getBoolean());
                    break;
                }
                catch (RepositoryException re) {
                    throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType), (Throwable)re);
                }
            }
            case 5: {
                BaseValue val;
                try {
                    val = new DateValue(srcValue.getDate());
                    break;
                }
                catch (RepositoryException re) {
                    throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType), (Throwable)re);
                }
            }
            case 4: {
                BaseValue val;
                try {
                    val = new DoubleValue(srcValue.getDouble());
                    break;
                }
                catch (RepositoryException re) {
                    throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType), (Throwable)re);
                }
            }
            case 3: {
                BaseValue val;
                try {
                    val = new LongValue(srcValue.getLong());
                    break;
                }
                catch (RepositoryException re) {
                    throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType), (Throwable)re);
                }
            }
            case 8: {
                BaseValue val;
                switch (srcType) {
                    case 8: {
                        return srcValue;
                    }
                    case 1: 
                    case 2: 
                    case 7: {
                        String path;
                        try {
                            path = srcValue.getString();
                        }
                        catch (RepositoryException re) {
                            throw new ValueFormatException("failed to convert source value to PATH value", (Throwable)re);
                        }
                        val = PathValue.valueOf(path);
                        break block9;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType));
                    }
                }
                throw new IllegalArgumentException("not a valid type constant: " + srcType);
            }
            case 7: {
                BaseValue val;
                switch (srcType) {
                    case 7: {
                        return srcValue;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        String name;
                        try {
                            name = srcValue.getString();
                        }
                        catch (RepositoryException re) {
                            throw new ValueFormatException("failed to convert source value to NAME value", (Throwable)re);
                        }
                        val = NameValue.valueOf(name);
                        break block9;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType));
                    }
                }
                throw new IllegalArgumentException("not a valid type constant: " + srcType);
            }
            case 9: {
                BaseValue val;
                switch (srcType) {
                    case 9: {
                        return srcValue;
                    }
                    case 1: 
                    case 2: {
                        String uuid;
                        try {
                            uuid = srcValue.getString();
                        }
                        catch (RepositoryException re) {
                            throw new ValueFormatException("failed to convert source value to REFERENCE value", (Throwable)re);
                        }
                        val = ReferenceValue.valueOf(uuid);
                        break block9;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        throw new ValueFormatException("conversion failed: " + PropertyType.nameFromValue((int)srcType) + " to " + PropertyType.nameFromValue((int)targetType));
                    }
                }
                throw new IllegalArgumentException("not a valid type constant: " + srcType);
            }
            default: {
                throw new IllegalArgumentException("not a valid type constant: " + targetType);
            }
        }
        return var2_3;
    }

    public static Value copy(Value srcValue) throws IllegalStateException {
        if (srcValue == null) {
            return null;
        }
        BaseValue newVal = null;
        try {
            switch (srcValue.getType()) {
                case 2: {
                    newVal = new BinaryValue(srcValue.getStream());
                    break;
                }
                case 6: {
                    newVal = new BooleanValue(srcValue.getBoolean());
                    break;
                }
                case 5: {
                    newVal = new DateValue(srcValue.getDate());
                    break;
                }
                case 4: {
                    newVal = new DoubleValue(srcValue.getDouble());
                    break;
                }
                case 3: {
                    newVal = new LongValue(srcValue.getLong());
                    break;
                }
                case 8: {
                    newVal = PathValue.valueOf(srcValue.getString());
                    break;
                }
                case 7: {
                    newVal = NameValue.valueOf(srcValue.getString());
                    break;
                }
                case 9: {
                    newVal = ReferenceValue.valueOf(srcValue.getString());
                    break;
                }
                case 1: {
                    newVal = new StringValue(srcValue.getString());
                }
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return newVal;
    }

    public static Value[] copy(Value[] srcValues) throws IllegalStateException {
        if (srcValues == null) {
            return null;
        }
        Value[] newValues = new Value[srcValues.length];
        for (int i = 0; i < srcValues.length; ++i) {
            newValues[i] = ValueHelper.copy(srcValues[i]);
        }
        return newValues;
    }

    public static String serialize(Value value, boolean encodeBlanks) throws IllegalStateException, RepositoryException {
        StringWriter writer = new StringWriter();
        try {
            ValueHelper.serialize(value, encodeBlanks, writer);
        }
        catch (IOException ioe) {
            throw new RepositoryException("failed to serialize value", (Throwable)ioe);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Value value, boolean encodeBlanks, Writer writer) throws IllegalStateException, IOException, RepositoryException {
        if (value.getType() == 2) {
            InputStream in = value.getStream();
            try {
                Base64.encode(in, writer);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        String textVal = value.getString();
        if (encodeBlanks) {
            textVal = Text.replace(textVal, " ", "_x0020_");
        }
        writer.write(textVal);
    }

    public static Value deserialize(String value, int type, boolean decodeBlanks) throws ValueFormatException, RepositoryException {
        if (type == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Base64.decode(value, (OutputStream)baos);
            }
            catch (IOException ioe) {
                throw new RepositoryException("failed to decode binary value", (Throwable)ioe);
            }
            return new BinaryValue(baos.toByteArray());
        }
        if (decodeBlanks) {
            value = Text.replace(value, "_x0020_", " ");
        }
        return ValueHelper.convert(value, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value deserialize(Reader reader, int type, boolean decodeBlanks) throws IOException, ValueFormatException, RepositoryException {
        int read;
        if (type == 2) {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            FileOutputStream out = new FileOutputStream(tmpFile);
            try {
                Base64.decode(reader, (OutputStream)out);
            }
            finally {
                out.close();
            }
            return new BinaryValue(new FilterInputStream(new FileInputStream(tmpFile)){
                File f;
                {
                    super(x0);
                    this.f = tmpFile;
                }

                public void close() throws IOException {
                    this.in.close();
                    this.f.delete();
                    this.f = null;
                }
            });
        }
        char[] chunk = new char[8192];
        StringBuffer buf = new StringBuffer();
        while ((read = reader.read(chunk)) > -1) {
            buf.append(chunk, 0, read);
        }
        String value = buf.toString();
        if (decodeBlanks) {
            value = Text.replace(value, "_x0020_", " ");
        }
        return ValueHelper.convert(value, type);
    }
}

