/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.PurgatoryElement;
import org.apache.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.CacheInfo;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public abstract class AbstractDiskCache
implements AuxiliaryCache,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$AbstractDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$AbstractDiskCache = AbstractDiskCache.class$("org.apache.jcs.auxiliary.disk.AbstractDiskCache")) : class$org$apache$jcs$auxiliary$disk$AbstractDiskCache));
    private IDiskCacheAttributes dcattr = null;
    protected Map purgatory = new HashMap();
    protected ICacheEventQueue cacheEventQueue;
    protected boolean alive = false;
    protected String cacheName;
    protected int purgHits = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$AbstractDiskCache;

    public AbstractDiskCache(IDiskCacheAttributes attr) {
        this.dcattr = attr;
        this.cacheName = attr.getCacheName();
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new MyCacheListener(), CacheInfo.listenerId, this.cacheName, this.dcattr.getEventQueuePoolName(), this.dcattr.getEventQueueTypeFactoryCode());
        this.initPurgatory();
    }

    private void initPurgatory() {
        this.purgatory = null;
        this.purgatory = this.dcattr.getMaxPurgatorySize() >= 0 ? new LRUMapJCS(this.dcattr.getMaxPurgatorySize()) : new HashMap();
    }

    public final void update(ICacheElement cacheElement) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting element in purgatory, cacheName: " + this.cacheName + ", key: " + cacheElement.getKey()));
        }
        try {
            PurgatoryElement pe = new PurgatoryElement(cacheElement);
            pe.setSpoolable(true);
            Map map = this.purgatory;
            synchronized (map) {
                this.purgatory.put(pe.getKey(), pe);
            }
            this.cacheEventQueue.addPutEvent(pe);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.cacheEventQueue.destroy();
        }
    }

    public final ICacheElement get(Serializable key) {
        if (!this.alive) {
            return null;
        }
        PurgatoryElement pe = null;
        Map map = this.purgatory;
        synchronized (map) {
            pe = (PurgatoryElement)this.purgatory.get(key);
        }
        if (pe != null) {
            ++this.purgHits;
            if (log.isDebugEnabled() && this.purgHits % 100 == 0) {
                log.debug((Object)("Purgatory hits = " + this.purgHits));
            }
            log.debug((Object)("Found element in purgatory, cacheName: " + this.cacheName + ", key: " + key));
            return pe.cacheElement;
        }
        try {
            return this.doGet(key);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.cacheEventQueue.destroy();
            return null;
        }
    }

    public abstract Set getGroupKeys(String var1);

    public final boolean remove(Serializable key) {
        PurgatoryElement pe = null;
        Map map = this.purgatory;
        synchronized (map) {
            pe = (PurgatoryElement)this.purgatory.remove(key);
        }
        if (pe != null) {
            pe.setSpoolable(false);
        }
        this.doRemove(key);
        return false;
    }

    public final void removeAll() {
        this.initPurgatory();
        this.doRemoveAll();
    }

    public final void dispose() {
        this.cacheEventQueue.destroy();
        this.doDispose();
        this.alive = false;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Disk Cache");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Purgatory Hits");
        se.setData("" + this.purgHits);
        elems.add(se);
        se = new StatElement();
        se.setName("Purgatory Size");
        se.setData("" + this.purgatory.size());
        elems.add(se);
        IStats eqStats = this.cacheEventQueue.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public int getStatus() {
        return this.alive ? 1 : 2;
    }

    public abstract int getSize();

    public int getCacheType() {
        return 2;
    }

    protected abstract ICacheElement doGet(Serializable var1);

    protected abstract void doUpdate(ICacheElement var1);

    protected abstract boolean doRemove(Serializable var1);

    protected abstract void doRemoveAll();

    protected abstract void doDispose();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyCacheListener
    implements ICacheListener {
        private long listenerId = 0L;

        private MyCacheListener() {
        }

        public long getListenerId() throws IOException {
            return this.listenerId;
        }

        public void setListenerId(long id) throws IOException {
            this.listenerId = id;
        }

        public void handlePut(ICacheElement element) throws IOException {
            if (AbstractDiskCache.this.alive) {
                if (element instanceof PurgatoryElement) {
                    PurgatoryElement pe = (PurgatoryElement)element;
                    Map map = AbstractDiskCache.this.purgatory;
                    synchronized (map) {
                        if (!AbstractDiskCache.this.purgatory.containsKey(pe.getKey())) {
                            return;
                        }
                        element = pe.getCacheElement();
                        if (pe.isSpoolable()) {
                            AbstractDiskCache.this.doUpdate(element);
                        }
                        AbstractDiskCache.this.purgatory.remove(element.getKey());
                    }
                } else {
                    AbstractDiskCache.this.doUpdate(element);
                }
            } else {
                Map map = AbstractDiskCache.this.purgatory;
                synchronized (map) {
                    AbstractDiskCache.this.purgatory.remove(element.getKey());
                }
            }
        }

        public void handleRemove(String cacheName, Serializable key) throws IOException {
            if (AbstractDiskCache.this.alive && AbstractDiskCache.this.doRemove(key)) {
                log.debug((Object)("Element removed, key: " + key));
            }
        }

        public void handleRemoveAll(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doRemoveAll();
            }
        }

        public void handleDispose(String cacheName) throws IOException {
            if (AbstractDiskCache.this.alive) {
                AbstractDiskCache.this.doDispose();
            }
        }
    }
}

