/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.servlet.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.utils.servlet.session.ISessionConstants;
import org.apache.jcs.utils.servlet.session.SessionIdGenerator;
import org.apache.jcs.utils.servlet.session.SessionInfo;

public class DistSession
implements HttpSession,
ISessionConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$servlet$session$DistSession == null ? (class$org$apache$jcs$utils$servlet$session$DistSession = DistSession.class$("org.apache.jcs.utils.servlet.session.DistSession")) : class$org$apache$jcs$utils$servlet$session$DistSession));
    private static boolean SET_ATTR_INVOCATION = true;
    private static boolean REMOVE_ATTR_INVOCATION = false;
    private ServletContext context;
    private String session_id;
    private SessionInfo sessInfo;
    private GroupCacheAccess sessCache;
    private boolean isNew;
    private boolean isValid = true;
    static /* synthetic */ Class class$org$apache$jcs$utils$servlet$session$DistSession;

    public DistSession() {
        this(null);
    }

    public DistSession(ServletContext context) {
        this.context = context;
        try {
            this.sessCache = GroupCacheAccess.getGroupAccess("sessionCache");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean init(String session_id) {
        this.isNew = false;
        this.session_id = session_id;
        this.sessInfo = (SessionInfo)this.sessCache.getFromGroup(session_id, session_id);
        if (this.sessInfo == null) {
            log.info((Object)("session not found for " + session_id));
            return false;
        }
        log.info((Object)("found session" + this.sessInfo));
        return true;
    }

    public void initNew() {
        try {
            this.isNew = true;
            this.sessInfo = new SessionInfo();
            this.session_id = SessionIdGenerator.createSessionId();
            this.sessCache.putInGroup(this.session_id, this.session_id, this.sessInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info((Object)("createUserSession " + this));
    }

    public void clean() {
        this.sessInfo = null;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot setAttribute on an invalid session " + this);
        }
        return this.sessCache.getFromGroup(name, this.session_id);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.sessCache.getGroupKeys(this.session_id));
    }

    public long getCreationTime() {
        return this.sessInfo.creationTime;
    }

    public String getId() {
        return this.session_id;
    }

    public long getLastAccessedTime() {
        return this.sessInfo.lastAccessedTime;
    }

    public void access() {
        try {
            log.info((Object)("updating lastAccess for " + this));
            this.sessInfo.lastAccessedTime = System.currentTimeMillis();
            this.sessCache.putInGroup(this.session_id, this.session_id, this.sessInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMaxInactiveInterval() {
        return this.sessInfo.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.sessCache.getGroupKeys(this.session_id).toArray(new String[0]);
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot setAttribute on an invalid session " + this);
        }
        log.info((Object)("destroying session " + this));
        this.isValid = false;
        this.sessCache.invalidateGroup(this.session_id);
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot setAttribute on an invalid session " + this);
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, REMOVE_ATTR_INVOCATION);
    }

    private void removeAttribute(String name, boolean invocation) {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot setAttribute on an invalid session " + this);
        }
        Serializable val = (Serializable)this.sessCache.getFromGroup(name, this.session_id);
        if (val == null) {
            return;
        }
        if (invocation == REMOVE_ATTR_INVOCATION) {
            this.sessCache.remove(name, this.session_id);
        }
        if (val instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)val).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (!this.isValid) {
            throw new IllegalStateException("Cannot setAttribute on an invalid session " + this);
        }
        try {
            this.sessCache.putInGroup(name, this.session_id, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
    }

    public void setMaxInactiveInterval(int i) {
        this.sessInfo.maxInactiveInterval = i;
    }

    public String toString() {
        return "[sesson_id=" + this.session_id + ", sessInfo=" + this.sessInfo + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

