/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.Bits;
import net.sf.pizzacompiler.compiler.Chain;
import net.sf.pizzacompiler.compiler.Code;
import net.sf.pizzacompiler.compiler.ConstType;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.FunSymbol;
import net.sf.pizzacompiler.compiler.Gen$$closures;
import net.sf.pizzacompiler.compiler.Pool;
import net.sf.pizzacompiler.compiler.Position;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.VarSymbol;

class Gen
implements Constants {
    static int dontgoto = 168;
    private static Code code;
    static boolean alive;
    static FunSymbol curMethod;
    private static boolean fixedPc;
    private static int stacksize;
    private static int nextadr;
    private static int nextreg;
    private static int[] adrmap;
    private static final int UNUSED = Integer.MIN_VALUE;
    static int statPos;
    static VarSymbol[] locals;
    static Bits inloop;
    static Bits uninits;
    static Bits inits;
    static int[] freq;
    static boolean statistics;
    static int total;
    static int adr1;
    static int adr2;
    static int adr4;
    static int field2;
    static int field4;
    private static Pool pool;
    private static int[] stackdiff;
    private static String[] mnem;

    static int curPc() {
        fixedPc = true;
        return Gen.code.cp;
    }

    static int stackSize() {
        return stacksize;
    }

    static int nextVar() {
        return nextadr;
    }

    static Bits uninitSet() {
        return uninits.dup();
    }

    static Bits initSet() {
        return inits.dup();
    }

    static void emit1(int n) {
        if (alive) {
            if (Gen.code.cp == Gen.code.code.length) {
                code.addCode((byte)n);
            } else {
                Gen.code.code[Gen.code.cp++] = (byte)n;
            }
            if (statistics) {
                ++total;
            }
        }
    }

    static void emit2(int n) {
        if (alive) {
            if (Gen.code.cp + 2 > Gen.code.code.length) {
                code.addCode(n >> 8);
                code.addCode(n);
            } else {
                Gen.code.code[Gen.code.cp++] = (byte)(n >> 8);
                Gen.code.code[Gen.code.cp++] = (byte)n;
            }
            if (statistics) {
                total += 2;
            }
            if (statistics) {
                ++field2;
            }
        }
    }

    static void emit4(int n) {
        Gen.emit1(n >> 24);
        Gen.emit1(n >> 16);
        Gen.emit1(n >> 8);
        Gen.emit1(n);
        if (statistics) {
            ++field4;
        }
    }

    static void emitop(int n, int n2) {
        if (alive) {
            Gen.emit1(n);
            if (n2 <= -1000) {
                stacksize = stacksize + n2 + 1000;
                Gen.markDead();
                Basic.assert(stacksize == 0);
            } else {
                Basic.assert((stacksize += n2) >= 0);
                if (stacksize > Gen.code.max_stack) {
                    Gen.code.max_stack = stacksize;
                }
            }
            if (statistics) {
                int n3 = n;
                freq[n3] = freq[n3] + 1;
            }
        }
    }

    static void emitop(int n) {
        Gen.emitop(n, stackdiff[n]);
    }

    static void emitop1(int n, int n2) {
        Gen.emitop(n);
        Gen.emit1(n2);
        if (statistics) {
            ++adr1;
        }
    }

    static void emitop1w(int n, int n2) {
        if (n2 > 255) {
            Gen.emit1(196);
            Gen.emitop2(n, n2);
        } else {
            Gen.emitop1(n, n2);
        }
    }

    static void emitop2(int n, int n2) {
        Gen.emitop(n);
        Gen.emit2(n2);
        if (statistics) {
            ++adr2;
        }
        if (statistics) {
            --field2;
        }
    }

    static void emitop4(int n, int n2) {
        Gen.emitop(n);
        Gen.emit4(n2);
        if (statistics) {
            ++adr4;
        }
        if (statistics) {
            --field4;
        }
    }

    static void put1(int n, int n2) {
        Gen.code.code[n] = (byte)n2;
    }

    static void put2(int n, int n2) {
        Gen.put1(n, n2 >> 8);
        Gen.put1(n + 1, n2);
    }

    static void put4(int n, int n2) {
        Gen.put1(n, n2 >> 24);
        Gen.put1(n + 1, n2 >> 16);
        Gen.put1(n + 2, n2 >> 8);
        Gen.put1(n + 3, n2);
    }

    static int get1(int n) {
        return Gen.code.code[n] & 0xFF;
    }

    static int get4(int n) {
        return Gen.get1(n) << 24 | Gen.get1(n + 1) << 16 | Gen.get1(n + 2) << 8 | Gen.get1(n + 3);
    }

    static void align(int n) {
        if (alive) {
            while (Gen.code.cp % n != 0) {
                Gen.emit1(0);
            }
        }
    }

    static void markDead() {
        alive = false;
        uninits.clear();
        inits.clear();
    }

    static void entryPoint(Bits bits, Bits bits2) {
        uninits.orSet(bits);
        inits.orSet(bits2);
        alive = true;
    }

    static Bits enterLoop() {
        Bits bits = inloop;
        inloop = new Bits();
        return bits;
    }

    static void exitLoop(Bits bits) {
        inloop = bits;
    }

    static void clearStack() {
        stacksize = 0;
    }

    static void pushStack(int n) {
        if ((stacksize += Gen.width(n)) > Gen.code.max_stack) {
            Gen.code.max_stack = stacksize;
        }
    }

    static void popStack(int n) {
        stacksize -= Gen.width(n);
    }

    static void registerCatch(int n, int n2, int n3, int n4) {
        if (n != n2) {
            code.addCatch(n, n2, n3, n4);
        }
    }

    static int newLocal(int n) {
        int n2 = nextadr++;
        int n3 = nextreg;
        int n4 = Gen.width(n);
        if ((nextreg = n3 + n4) > Gen.code.max_locals) {
            Gen.code.max_locals = nextreg;
        }
        while (n2 >= adrmap.length) {
            int[] nArray = new int[adrmap.length * 2];
            System.arraycopy(adrmap, 0, nArray, 0, adrmap.length);
            adrmap = nArray;
        }
        Gen.adrmap[n2] = n4 == 2 ? -n3 : n3;
        return n2;
    }

    static int newLocal(Type type) {
        return Gen.newLocal(Gen.typecode(type));
    }

    static void newLocal(VarSymbol varSymbol) {
        varSymbol.adr = Gen.newLocal(Gen.typecode(varSymbol.type));
        code.addLocalVar(Gen.regOf(varSymbol.adr), varSymbol);
        Gen.rememberLocal(varSymbol);
        if ((varSymbol.modifiers & 0x10) != 0 && inloop != null) {
            inloop.incl(varSymbol.adr);
        }
    }

    static void newFinal(VarSymbol varSymbol) {
        varSymbol.adr = nextadr++;
        Gen.rememberLocal(varSymbol);
    }

    static void endFinal(VarSymbol varSymbol) {
        Gen.locals[varSymbol.adr] = null;
    }

    static void newRegSegment() {
        nextreg = Gen.code.max_locals;
    }

    private static void rememberLocal(VarSymbol varSymbol) {
        while (varSymbol.adr >= locals.length) {
            VarSymbol[] varSymbolArray = new VarSymbol[locals.length * 2];
            System.arraycopy(locals, 0, varSymbolArray, 0, locals.length);
            locals = varSymbolArray;
        }
        Gen.locals[varSymbol.adr] = varSymbol;
    }

    static int regOf(int n) {
        int n2 = adrmap[n];
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2;
    }

    static void endScopes(int n) {
        if (n < nextadr) {
            for (int i = n; i < nextadr; ++i) {
                code.setEndPc(i);
            }
            nextreg = Gen.regOf(n);
        }
    }

    static void statBegin(int n) {
        if (n != 0) {
            if (alive) {
                statPos = n;
                Basic.assert(stacksize == 0);
                code.addLineNumber(Gen.code.cp, Position.line(n));
            } else {
                Report.warning(n, "statement is unreachable");
            }
        }
    }

    static void letUninit(int n) {
        uninits.incl(n);
        inits.excl(n);
    }

    static void letInit(int n) {
        if (alive) {
            uninits.excl(n);
            inits.incl(n);
            code.setStartPc(n);
        }
    }

    static void checkInit(int n, int n2) {
        if (alive && uninits.member(n2)) {
            Report.error(n, String.valueOf(locals[n2]).concat(String.valueOf(" might not have been initialized")));
            uninits.excl(n2);
        }
    }

    static void checkUninit(int n, int n2) {
        if (alive && (inits.member(n2) || inloop != null && !inloop.member(n2))) {
            Report.error(n, String.valueOf(locals[n2]).concat(String.valueOf(" might already have been assigned to")));
            inits.excl(n2);
        }
    }

    static void checkInit(int n, VarSymbol varSymbol) {
        if (varSymbol.adr >= 0 && varSymbol.adr < locals.length && locals[varSymbol.adr] == varSymbol) {
            Gen.checkInit(n, varSymbol.adr);
        }
    }

    static void checkFirstInit(int n, VarSymbol varSymbol) {
        if (varSymbol.adr >= 0 && varSymbol.adr < locals.length && locals[varSymbol.adr] == varSymbol) {
            Gen.checkUninit(n, varSymbol.adr);
            Gen.letInit(varSymbol.adr);
        }
    }

    static int putConstant(ConstType constType) {
        return pool.put(constType);
    }

    static int mkref(Type type) {
        Type type2 = type.deref();
        switch (type2.net$sf$pizzacompiler$compiler$Type$$tag) {
            case 3: {
                return pool.put(type.tsym());
            }
        }
        return pool.put(type);
    }

    static int mkref(Symbol symbol) {
        return pool.put(symbol);
    }

    static int typecode(Type type) {
        switch (type.net$sf$pizzacompiler$compiler$Type$$tag) {
            case 1: {
                int n = ((Type.NumType)type).tag;
                switch (n) {
                    case 1: {
                        return 5;
                    }
                    case 3: {
                        return 7;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 0;
                    }
                    case 5: {
                        return 1;
                    }
                    case 6: {
                        return 2;
                    }
                    case 7: {
                        return 3;
                    }
                    case 8: {
                        return 5;
                    }
                }
                throw new InternalError();
            }
            case 2: {
                return 8;
            }
            case 3: 
            case 4: 
            case 5: {
                return 4;
            }
            case 7: {
                Type type2 = ((Type.TypeVar)type).value;
                if (type2 != null && type2 != type) {
                    return Gen.typecode(type2);
                }
                return 4;
            }
        }
        throw new InternalError(String.valueOf("typecode ").concat(String.valueOf(new Gen$$closures(null, 0, new Object[]{type}))));
    }

    static int truncate(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return n;
    }

    static int shortcode(Type type) {
        return Gen.truncate(Gen.typecode(type));
    }

    static int width(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    static int width(Type type) {
        return Gen.width(Gen.typecode(type));
    }

    static int width(Type[] typeArray) {
        int n = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            n += Gen.width(typeArray[i]);
        }
        return n;
    }

    static int zero(int n) {
        switch (n) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new InternalError("zero");
    }

    static int one(int n) {
        return Gen.zero(n) + 1;
    }

    static void emitMinusOne(int n) {
        if (n == 1) {
            Gen.emitop(9);
            Gen.emitop(10);
            Gen.emitop(101);
        } else {
            Gen.emitop(2);
        }
    }

    static int negate(int n) {
        return (n + 1 ^ 1) - 1;
    }

    static void emitJump(Chain chain, int n) {
        if (Gen.code.fatcode) {
            if (n == 167 || n == 168) {
                Gen.emitop4(n + 200 - 167, 0);
            } else {
                Gen.emitop2(Gen.negate(n), 8);
                Gen.emitop4(200, 0);
                chain.pc += 3;
            }
        } else {
            Gen.emitop2(n, 0);
        }
    }

    static Chain branch(int n) {
        if (n == dontgoto || !alive) {
            return null;
        }
        int n2 = stackdiff[n];
        Chain chain = new Chain(Gen.code.cp, null, stacksize += n2, Gen.uninitSet(), Gen.initSet());
        stacksize -= n2;
        Gen.emitJump(chain, n);
        fixedPc = Gen.code.fatcode;
        if (n == 167) {
            Gen.markDead();
        }
        return chain;
    }

    static void resolve(Chain chain, int n) {
        if (chain != null) {
            Basic.assert(n > chain.pc || stacksize == 0);
            if (n > Gen.code.cp) {
                n = Gen.code.cp;
            }
            if (Gen.get1(chain.pc) == 167 && chain.pc + 3 == n && n == Gen.code.cp && !fixedPc) {
                Gen.code.cp -= 3;
                n -= 3;
            } else {
                if (Gen.code.fatcode) {
                    Gen.put4(chain.pc + 1, n - chain.pc);
                } else if (n - chain.pc < Short.MIN_VALUE || n - chain.pc > Short.MAX_VALUE) {
                    Gen.code.fatcode = true;
                } else {
                    Gen.put2(chain.pc + 1, n - chain.pc);
                }
                Basic.assert(!alive || chain.stacksize == stacksize);
            }
            fixedPc = true;
            Gen.resolve(chain.next, n);
            if (Gen.code.cp == n) {
                stacksize = chain.stacksize;
                alive = true;
                uninits.orSet(chain.uninits);
                inits.orSet(chain.inits);
            }
        }
    }

    static void resolve(Chain chain) {
        Gen.resolve(chain, Gen.code.cp);
    }

    static Chain mergeChains(Chain chain, Chain chain2) {
        if (chain2 == null) {
            return chain;
        }
        if (chain == null) {
            return chain2;
        }
        Basic.assert(chain.stacksize == chain2.stacksize);
        return new Chain(chain2.pc, Gen.mergeChains(chain, chain2.next), chain2.stacksize, chain2.uninits, chain2.inits);
    }

    static Pool newPool() {
        pool.reset();
        return pool;
    }

    static Code newCode(boolean bl, FunSymbol funSymbol) {
        code = new Code(bl);
        nextadr = 0;
        nextreg = 0;
        curMethod = funSymbol;
        uninits = new Bits();
        inits = new Bits();
        alive = true;
        return code;
    }

    public static void stats() {
        int n = 0;
        for (int i = 0; i < 203; ++i) {
            n += freq[i];
        }
        for (int i = 0; i < 203; ++i) {
            System.out.println(String.valueOf(String.valueOf(100.0f * (float)freq[i] / (float)n).concat(String.valueOf("% "))).concat(String.valueOf(mnem[i])));
        }
        System.out.println(String.valueOf(n).concat(String.valueOf(" instuctions")));
        System.out.println(String.valueOf(total).concat(String.valueOf(" bytes")));
        System.out.println(String.valueOf(adr1).concat(String.valueOf(" one byte operands")));
        System.out.println(String.valueOf(adr2).concat(String.valueOf(" two byte operands")));
        System.out.println(String.valueOf(adr4).concat(String.valueOf(" four byte operands")));
        System.out.println(String.valueOf(field2).concat(String.valueOf(" two byte fields")));
        System.out.println(String.valueOf(field4).concat(String.valueOf(" four byte fields")));
    }

    Gen() {
    }

    static /* synthetic */ int $closure$net$sf$pizzacompiler$compiler$Gen$0s(Object[] objectArray) {
        Type type = (Type)objectArray[0];
        return type.tag();
    }

    static {
        curMethod = null;
        stacksize = 0;
        nextadr = 0;
        nextreg = 0;
        adrmap = new int[64];
        locals = new VarSymbol[64];
        inloop = null;
        freq = new int[203];
        statistics = false;
        total = 0;
        adr1 = 0;
        adr2 = 0;
        adr4 = 0;
        field2 = 0;
        field4 = 0;
        pool = new Pool();
        stackdiff = new int[203];
        Gen.stackdiff[0] = 0;
        Gen.stackdiff[1] = 1;
        Gen.stackdiff[2] = 1;
        Gen.stackdiff[3] = 1;
        Gen.stackdiff[4] = 1;
        Gen.stackdiff[5] = 1;
        Gen.stackdiff[6] = 1;
        Gen.stackdiff[7] = 1;
        Gen.stackdiff[8] = 1;
        Gen.stackdiff[9] = 2;
        Gen.stackdiff[10] = 2;
        Gen.stackdiff[11] = 1;
        Gen.stackdiff[12] = 1;
        Gen.stackdiff[13] = 1;
        Gen.stackdiff[14] = 2;
        Gen.stackdiff[15] = 2;
        Gen.stackdiff[16] = 1;
        Gen.stackdiff[17] = 1;
        Gen.stackdiff[18] = -999;
        Gen.stackdiff[19] = -999;
        Gen.stackdiff[20] = -999;
        Gen.stackdiff[21] = 1;
        Gen.stackdiff[22] = 2;
        Gen.stackdiff[23] = 1;
        Gen.stackdiff[24] = 2;
        Gen.stackdiff[25] = 1;
        Gen.stackdiff[26] = 1;
        Gen.stackdiff[30] = 2;
        Gen.stackdiff[34] = 1;
        Gen.stackdiff[38] = 2;
        Gen.stackdiff[42] = 1;
        Gen.stackdiff[27] = 1;
        Gen.stackdiff[31] = 2;
        Gen.stackdiff[35] = 1;
        Gen.stackdiff[39] = 2;
        Gen.stackdiff[43] = 1;
        Gen.stackdiff[28] = 1;
        Gen.stackdiff[32] = 2;
        Gen.stackdiff[36] = 1;
        Gen.stackdiff[40] = 2;
        Gen.stackdiff[44] = 1;
        Gen.stackdiff[29] = 1;
        Gen.stackdiff[33] = 2;
        Gen.stackdiff[37] = 1;
        Gen.stackdiff[41] = 2;
        Gen.stackdiff[45] = 1;
        Gen.stackdiff[46] = -1;
        Gen.stackdiff[47] = 0;
        Gen.stackdiff[48] = -1;
        Gen.stackdiff[49] = 0;
        Gen.stackdiff[50] = -1;
        Gen.stackdiff[51] = -1;
        Gen.stackdiff[52] = -1;
        Gen.stackdiff[53] = -1;
        Gen.stackdiff[54] = -1;
        Gen.stackdiff[55] = -2;
        Gen.stackdiff[56] = -1;
        Gen.stackdiff[57] = -2;
        Gen.stackdiff[58] = -1;
        Gen.stackdiff[59] = -1;
        Gen.stackdiff[63] = -2;
        Gen.stackdiff[67] = -1;
        Gen.stackdiff[71] = -2;
        Gen.stackdiff[75] = -1;
        Gen.stackdiff[60] = -1;
        Gen.stackdiff[64] = -2;
        Gen.stackdiff[68] = -1;
        Gen.stackdiff[72] = -2;
        Gen.stackdiff[76] = -1;
        Gen.stackdiff[61] = -1;
        Gen.stackdiff[65] = -2;
        Gen.stackdiff[69] = -1;
        Gen.stackdiff[73] = -2;
        Gen.stackdiff[77] = -1;
        Gen.stackdiff[62] = -1;
        Gen.stackdiff[66] = -2;
        Gen.stackdiff[70] = -1;
        Gen.stackdiff[74] = -2;
        Gen.stackdiff[78] = -1;
        Gen.stackdiff[79] = -3;
        Gen.stackdiff[80] = -4;
        Gen.stackdiff[81] = -3;
        Gen.stackdiff[82] = -4;
        Gen.stackdiff[83] = -3;
        Gen.stackdiff[84] = -3;
        Gen.stackdiff[85] = -3;
        Gen.stackdiff[86] = -3;
        Gen.stackdiff[87] = -1;
        Gen.stackdiff[88] = -2;
        Gen.stackdiff[89] = 1;
        Gen.stackdiff[90] = 1;
        Gen.stackdiff[91] = 1;
        Gen.stackdiff[92] = 2;
        Gen.stackdiff[93] = 2;
        Gen.stackdiff[94] = 2;
        Gen.stackdiff[95] = 0;
        Gen.stackdiff[96] = -1;
        Gen.stackdiff[97] = -2;
        Gen.stackdiff[98] = -1;
        Gen.stackdiff[99] = -2;
        Gen.stackdiff[100] = -1;
        Gen.stackdiff[101] = -2;
        Gen.stackdiff[102] = -1;
        Gen.stackdiff[103] = -2;
        Gen.stackdiff[104] = -1;
        Gen.stackdiff[105] = -2;
        Gen.stackdiff[106] = -1;
        Gen.stackdiff[107] = -2;
        Gen.stackdiff[108] = -1;
        Gen.stackdiff[109] = -2;
        Gen.stackdiff[110] = -1;
        Gen.stackdiff[111] = -2;
        Gen.stackdiff[112] = -1;
        Gen.stackdiff[113] = -2;
        Gen.stackdiff[114] = -1;
        Gen.stackdiff[115] = -2;
        Gen.stackdiff[116] = 0;
        Gen.stackdiff[117] = 0;
        Gen.stackdiff[118] = 0;
        Gen.stackdiff[119] = 0;
        Gen.stackdiff[120] = -1;
        Gen.stackdiff[121] = -1;
        Gen.stackdiff[122] = -1;
        Gen.stackdiff[123] = -1;
        Gen.stackdiff[124] = -1;
        Gen.stackdiff[125] = -1;
        Gen.stackdiff[126] = -1;
        Gen.stackdiff[127] = -2;
        Gen.stackdiff[128] = -1;
        Gen.stackdiff[129] = -2;
        Gen.stackdiff[130] = -1;
        Gen.stackdiff[131] = -2;
        Gen.stackdiff[132] = 0;
        Gen.stackdiff[133] = 1;
        Gen.stackdiff[134] = 0;
        Gen.stackdiff[135] = 1;
        Gen.stackdiff[136] = -1;
        Gen.stackdiff[137] = -1;
        Gen.stackdiff[138] = 0;
        Gen.stackdiff[139] = 0;
        Gen.stackdiff[140] = 1;
        Gen.stackdiff[141] = 1;
        Gen.stackdiff[142] = -1;
        Gen.stackdiff[143] = 0;
        Gen.stackdiff[144] = -1;
        Gen.stackdiff[145] = 0;
        Gen.stackdiff[146] = 0;
        Gen.stackdiff[147] = 0;
        Gen.stackdiff[148] = -3;
        Gen.stackdiff[149] = -1;
        Gen.stackdiff[150] = -1;
        Gen.stackdiff[151] = -3;
        Gen.stackdiff[152] = -3;
        Gen.stackdiff[153] = -1;
        Gen.stackdiff[154] = -1;
        Gen.stackdiff[155] = -1;
        Gen.stackdiff[156] = -1;
        Gen.stackdiff[157] = -1;
        Gen.stackdiff[158] = -1;
        Gen.stackdiff[159] = -2;
        Gen.stackdiff[160] = -2;
        Gen.stackdiff[161] = -2;
        Gen.stackdiff[162] = -2;
        Gen.stackdiff[163] = -2;
        Gen.stackdiff[164] = -2;
        Gen.stackdiff[165] = -2;
        Gen.stackdiff[166] = -2;
        Gen.stackdiff[167] = 0;
        Gen.stackdiff[168] = 0;
        Gen.stackdiff[169] = 0;
        Gen.stackdiff[170] = -1;
        Gen.stackdiff[171] = -1;
        Gen.stackdiff[172] = -1001;
        Gen.stackdiff[173] = -1002;
        Gen.stackdiff[174] = -1001;
        Gen.stackdiff[175] = -1002;
        Gen.stackdiff[176] = -1001;
        Gen.stackdiff[177] = -1000;
        Gen.stackdiff[178] = -999;
        Gen.stackdiff[179] = -999;
        Gen.stackdiff[180] = -999;
        Gen.stackdiff[181] = -999;
        Gen.stackdiff[182] = -999;
        Gen.stackdiff[183] = -999;
        Gen.stackdiff[184] = -999;
        Gen.stackdiff[185] = -999;
        Gen.stackdiff[186] = 0;
        Gen.stackdiff[187] = 1;
        Gen.stackdiff[188] = 0;
        Gen.stackdiff[189] = 0;
        Gen.stackdiff[190] = 0;
        Gen.stackdiff[191] = -1001;
        Gen.stackdiff[192] = 0;
        Gen.stackdiff[193] = 0;
        Gen.stackdiff[194] = -1;
        Gen.stackdiff[195] = -1;
        Gen.stackdiff[196] = 0;
        Gen.stackdiff[197] = -999;
        Gen.stackdiff[198] = -1;
        Gen.stackdiff[199] = -1;
        Gen.stackdiff[200] = 0;
        Gen.stackdiff[201] = 0;
        Gen.stackdiff[202] = 0;
        mnem = new String[203];
        Gen.mnem[0] = "nop";
        Gen.mnem[1] = "aconst_null";
        Gen.mnem[2] = "iconst_m1";
        Gen.mnem[3] = "iconst_0";
        Gen.mnem[4] = "iconst_1";
        Gen.mnem[5] = "iconst_2";
        Gen.mnem[6] = "iconst_3";
        Gen.mnem[7] = "iconst_4";
        Gen.mnem[8] = "iconst_5";
        Gen.mnem[9] = "lconst_0";
        Gen.mnem[10] = "lconst_1";
        Gen.mnem[11] = "fconst_0";
        Gen.mnem[12] = "fconst_1";
        Gen.mnem[13] = "fconst_2";
        Gen.mnem[14] = "dconst_0";
        Gen.mnem[15] = "dconst_1";
        Gen.mnem[16] = "bipush";
        Gen.mnem[17] = "sipush";
        Gen.mnem[18] = "ldc1";
        Gen.mnem[19] = "ldc2";
        Gen.mnem[20] = "ldc2w";
        Gen.mnem[21] = "iload";
        Gen.mnem[22] = "lload";
        Gen.mnem[23] = "fload";
        Gen.mnem[24] = "dload";
        Gen.mnem[25] = "aload";
        Gen.mnem[26] = "iload_0";
        Gen.mnem[30] = "lload_0";
        Gen.mnem[34] = "fload_0";
        Gen.mnem[38] = "dload_0";
        Gen.mnem[42] = "aload_0";
        Gen.mnem[27] = "iload_1";
        Gen.mnem[31] = "lload_1";
        Gen.mnem[35] = "fload_1";
        Gen.mnem[39] = "dload_1";
        Gen.mnem[43] = "aload_1";
        Gen.mnem[28] = "iload_2";
        Gen.mnem[32] = "lload_2";
        Gen.mnem[36] = "fload_2";
        Gen.mnem[40] = "dload_2";
        Gen.mnem[44] = "aload_2";
        Gen.mnem[29] = "iload_3";
        Gen.mnem[33] = "lload_3";
        Gen.mnem[37] = "fload_3";
        Gen.mnem[41] = "dload_3";
        Gen.mnem[45] = "aload_3";
        Gen.mnem[46] = "iaload";
        Gen.mnem[47] = "laload";
        Gen.mnem[48] = "faload";
        Gen.mnem[49] = "daload";
        Gen.mnem[50] = "aaload";
        Gen.mnem[51] = "baload";
        Gen.mnem[52] = "caload";
        Gen.mnem[53] = "saload";
        Gen.mnem[54] = "istore";
        Gen.mnem[55] = "lstore";
        Gen.mnem[56] = "fstore";
        Gen.mnem[57] = "dstore";
        Gen.mnem[58] = "astore";
        Gen.mnem[59] = "istore_0";
        Gen.mnem[63] = "lstore_0";
        Gen.mnem[67] = "fstore_0";
        Gen.mnem[71] = "dstore_0";
        Gen.mnem[75] = "astore_0";
        Gen.mnem[60] = "istore_1";
        Gen.mnem[64] = "lstore_1";
        Gen.mnem[68] = "fstore_1";
        Gen.mnem[72] = "dstore_1";
        Gen.mnem[76] = "astore_1";
        Gen.mnem[61] = "istore_2";
        Gen.mnem[65] = "lstore_2";
        Gen.mnem[69] = "fstore_2";
        Gen.mnem[73] = "dstore_2";
        Gen.mnem[77] = "astore_2";
        Gen.mnem[62] = "istore_3";
        Gen.mnem[66] = "lstore_3";
        Gen.mnem[70] = "fstore_3";
        Gen.mnem[74] = "dstore_3";
        Gen.mnem[78] = "astore_3";
        Gen.mnem[79] = "iastore";
        Gen.mnem[80] = "lastore";
        Gen.mnem[81] = "fastore";
        Gen.mnem[82] = "dastore";
        Gen.mnem[83] = "aastore";
        Gen.mnem[84] = "bastore";
        Gen.mnem[85] = "castore";
        Gen.mnem[86] = "sastore";
        Gen.mnem[87] = "pop";
        Gen.mnem[88] = "pop2";
        Gen.mnem[89] = "dup";
        Gen.mnem[90] = "dup_x1";
        Gen.mnem[91] = "dup_x2";
        Gen.mnem[92] = "dup2";
        Gen.mnem[93] = "dup2_x1";
        Gen.mnem[94] = "dup2_x2";
        Gen.mnem[95] = "swap";
        Gen.mnem[96] = "iadd";
        Gen.mnem[97] = "ladd";
        Gen.mnem[98] = "fadd";
        Gen.mnem[99] = "dadd";
        Gen.mnem[100] = "isub";
        Gen.mnem[101] = "lsub";
        Gen.mnem[102] = "fsub";
        Gen.mnem[103] = "dsub";
        Gen.mnem[104] = "imul";
        Gen.mnem[105] = "lmul";
        Gen.mnem[106] = "fmul";
        Gen.mnem[107] = "dmul";
        Gen.mnem[108] = "idiv";
        Gen.mnem[109] = "ldiv";
        Gen.mnem[110] = "fdiv";
        Gen.mnem[111] = "ddiv";
        Gen.mnem[112] = "imod";
        Gen.mnem[113] = "lmod";
        Gen.mnem[114] = "fmod";
        Gen.mnem[115] = "dmod";
        Gen.mnem[116] = "ineg";
        Gen.mnem[117] = "lneg";
        Gen.mnem[118] = "fneg";
        Gen.mnem[119] = "dneg";
        Gen.mnem[120] = "ishl";
        Gen.mnem[121] = "lshl";
        Gen.mnem[122] = "ishr";
        Gen.mnem[123] = "lshr";
        Gen.mnem[124] = "iushr";
        Gen.mnem[125] = "lushr";
        Gen.mnem[126] = "iand";
        Gen.mnem[127] = "land";
        Gen.mnem[128] = "ior";
        Gen.mnem[129] = "lor";
        Gen.mnem[130] = "ixor";
        Gen.mnem[131] = "lxor";
        Gen.mnem[132] = "iinc";
        Gen.mnem[133] = "i2l";
        Gen.mnem[134] = "i2f";
        Gen.mnem[135] = "i2d";
        Gen.mnem[136] = "l2i";
        Gen.mnem[137] = "l2f";
        Gen.mnem[138] = "l2d";
        Gen.mnem[139] = "f2i";
        Gen.mnem[140] = "f2l";
        Gen.mnem[141] = "f2d";
        Gen.mnem[142] = "d2i";
        Gen.mnem[143] = "d2l";
        Gen.mnem[144] = "d2f";
        Gen.mnem[145] = "int2byte";
        Gen.mnem[146] = "int2char";
        Gen.mnem[147] = "int2short";
        Gen.mnem[148] = "lcmp";
        Gen.mnem[149] = "fcmpl";
        Gen.mnem[150] = "fcmpg";
        Gen.mnem[151] = "dcmpl";
        Gen.mnem[152] = "dcmpg";
        Gen.mnem[153] = "ifeq";
        Gen.mnem[154] = "ifne";
        Gen.mnem[155] = "iflt";
        Gen.mnem[156] = "ifge";
        Gen.mnem[157] = "ifgt";
        Gen.mnem[158] = "ifle";
        Gen.mnem[159] = "if_icmpeq";
        Gen.mnem[160] = "if_icmpne";
        Gen.mnem[161] = "if_icmplt";
        Gen.mnem[162] = "if_icmpge";
        Gen.mnem[163] = "if_icmpgt";
        Gen.mnem[164] = "if_icmple";
        Gen.mnem[165] = "if_acmpeq";
        Gen.mnem[166] = "if_acmpne";
        Gen.mnem[167] = "goto_";
        Gen.mnem[168] = "jsr";
        Gen.mnem[169] = "ret";
        Gen.mnem[170] = "tableswitch";
        Gen.mnem[171] = "lookupswitch";
        Gen.mnem[172] = "ireturn";
        Gen.mnem[173] = "lreturn";
        Gen.mnem[174] = "freturn";
        Gen.mnem[175] = "dreturn";
        Gen.mnem[176] = "areturn";
        Gen.mnem[177] = "return_";
        Gen.mnem[178] = "getstatic";
        Gen.mnem[179] = "putstatic";
        Gen.mnem[180] = "getfield";
        Gen.mnem[181] = "putfield";
        Gen.mnem[182] = "invokevirtual";
        Gen.mnem[183] = "invokenonvirtual";
        Gen.mnem[184] = "invokestatic";
        Gen.mnem[185] = "invokeinterface";
        Gen.mnem[186] = "newfromname";
        Gen.mnem[187] = "new_";
        Gen.mnem[188] = "newarray";
        Gen.mnem[189] = "anewarray";
        Gen.mnem[190] = "arraylength";
        Gen.mnem[191] = "athrow";
        Gen.mnem[192] = "checkcast";
        Gen.mnem[193] = "instanceof_";
        Gen.mnem[194] = "monitorenter";
        Gen.mnem[195] = "monitorexit";
        Gen.mnem[196] = "wide";
        Gen.mnem[197] = "multianewarray";
        Gen.mnem[198] = "if_acmp_null";
        Gen.mnem[199] = "if_acmp_nonnull";
        Gen.mnem[200] = "goto_w";
        Gen.mnem[201] = "jsr_w";
        Gen.mnem[202] = "breakpoint";
    }
}

